/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.handler;

import com.tvd12.ezyfox.util.EzyDirectories;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.youngmonkeys.ezyplatform.cli.Command;
import org.youngmonkeys.ezyplatform.cli.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.cli.handler.DeactivateModuleCommandHandler;
import org.youngmonkeys.ezyplatform.cli.io.CliFolderProxy;

public class RemoveModuleCommandHandler
extends DeactivateModuleCommandHandler {
    @Override
    protected void handle(List<String> moduleTypes, Map<String, Map<String, ModuleMetadata>> moduleMetadataByNameByModuleType, Map<String, List<String>> updatedModuleNamesByModuleType, boolean verbose) throws Exception {
        for (String moduleType : moduleTypes) {
            List<String> updatedModuleNames = updatedModuleNamesByModuleType.get(moduleType);
            if (updatedModuleNames == null) continue;
            Map<String, ModuleMetadata> moduleMetadataByName = moduleMetadataByNameByModuleType.get(moduleType);
            for (String moduleName : updatedModuleNames) {
                File moduleFolder = CliFolderProxy.getModuleFolder(moduleType, moduleName);
                if (moduleFolder.exists()) {
                    EzyDirectories.deleteFolder((File)moduleFolder, file -> {
                        if (verbose) {
                            this.println("Deleted: " + file);
                        }
                    });
                }
                if (moduleMetadataByName == null) continue;
                moduleMetadataByName.remove(moduleName);
            }
        }
    }

    @Override
    protected Command getActCommand() {
        return Command.REMOVE;
    }

    @Override
    protected String resultString() {
        return "removed";
    }
}

