/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageHeader;
import com.tvd12.ezyfox.codec.EzyMessageHeaderReader;
import com.tvd12.ezyfox.codec.EzySimpleMessage;
import com.tvd12.ezyfox.io.EzyBytes;
import com.tvd12.ezyfox.io.EzyInts;

public final class EzyMessageReaders {
    private EzyMessageReaders() {
    }

    public static EzyMessage bytesToMessage(byte[] bytes) {
        EzyMessageHeader header = EzyMessageHeaderReader.read(bytes[0]);
        int messageSizeLength = header.isBigSize() ? 4 : 2;
        int minSize = 2 + messageSizeLength;
        if (bytes.length < minSize) {
            return null;
        }
        byte[] messageSizeBytes = EzyBytes.copy((byte[])bytes, (int)1, (int)messageSizeLength);
        int messageSize = EzyInts.bin2int((byte[])messageSizeBytes);
        int allSize = 1 + messageSizeLength + messageSize;
        if (bytes.length < allSize) {
            return null;
        }
        int contentStart = 1 + messageSizeLength;
        byte[] messageContent = EzyBytes.copy((byte[])bytes, (int)contentStart, (int)messageSize);
        return new EzySimpleMessage(header, messageContent, messageSize);
    }
}

