/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.io.EzyStrings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Keywords {
    public static final int DEFAULT_MAX_KEYWORD_LENGTH = 300;

    private Keywords() {
    }

    public static List<String> toKeywords(String str) {
        return Keywords.toKeywords(str, false);
    }

    public static List<String> toKeywords(String str, boolean nullIfBlank) {
        return Keywords.toKeywords(str, nullIfBlank, 300);
    }

    public static List<String> toKeywords(String str, boolean nullIfBlank, int maxKeywordLength) {
        if (EzyStrings.isBlank((String)str)) {
            return nullIfBlank ? null : Collections.emptyList();
        }
        ArrayList<String> wordTrims = new ArrayList<String>();
        ArrayList<String> word2s = new ArrayList<String>();
        ArrayList<String> word3s = new ArrayList<String>();
        ArrayList<String> longKeywords = new ArrayList<String>();
        List<String> words = Keywords.splitString(str);
        int longKeywordLength = 0;
        LinkedList<String> longKeyword = null;
        for (String word : words) {
            String wordTrim = word.trim();
            if (wordTrim.length() > maxKeywordLength) {
                wordTrim = wordTrim.substring(0, maxKeywordLength);
            }
            if (longKeyword == null) {
                longKeyword = new LinkedList<String>();
            }
            longKeyword.add(wordTrim);
            longKeywordLength += wordTrim.length();
            if (longKeyword.size() > 1) {
                ++longKeywordLength;
            }
            while (longKeywordLength > maxKeywordLength) {
                String firstWord = (String)longKeyword.poll();
                longKeywordLength -= Objects.requireNonNull(firstWord).length();
                --longKeywordLength;
            }
            String wordTrimLowerCase = wordTrim.toLowerCase();
            wordTrims.add(wordTrimLowerCase);
            if (wordTrimLowerCase.length() > 2) {
                word2s.add(wordTrimLowerCase.substring(0, 2));
            }
            if (wordTrimLowerCase.length() > 3) {
                word3s.add(wordTrimLowerCase.substring(0, 3));
            }
            String longKeywordString = String.join((CharSequence)" ", longKeyword);
            longKeywords.add(longKeywordString.toLowerCase());
        }
        ArrayList answer = new ArrayList();
        for (int i = longKeywords.size() - 1; i >= 0; --i) {
            answer.add(longKeywords.get(i));
        }
        answer.addAll(wordTrims);
        answer.addAll(word3s);
        answer.addAll(word2s);
        return answer.stream().distinct().collect(Collectors.toList());
    }

    public static String keywordFromEmail(String email) {
        int atIndex = email.indexOf("@");
        return atIndex < 1 ? "" : email.substring(0, atIndex).toLowerCase();
    }

    public static List<String> splitString(String str) {
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (EzyStrings.isWordSeparator((char)ch) || ch == '/') {
                if (buffer.length() == 0) continue;
                answer.add(buffer.toString());
                buffer.delete(0, buffer.length());
                continue;
            }
            buffer.append(ch);
        }
        if (buffer.length() > 0) {
            answer.add(buffer.toString());
        }
        return answer;
    }
}

