/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import javax.servlet.http.HttpServletRequest;

public final class ServletRequests {
    private static final String UNKNOWN_IP = "unknown";

    private ServletRequests() {
    }

    public static String getClientIp(HttpServletRequest request, boolean requestDirectly) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ServletRequests.isUnknownIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ServletRequests.isUnknownIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ServletRequests.isUnknownIp(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ServletRequests.isUnknownIp(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ServletRequests.isUnknownIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ServletRequests.isUnknownIp(ip)) {
            ip = requestDirectly ? request.getRemoteAddr() : UNKNOWN_IP;
        }
        return ip;
    }

    public static boolean isUnknownIp(String ip) {
        return ip == null || ip.isEmpty() || UNKNOWN_IP.equalsIgnoreCase(ip);
    }
}

