/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.youngmonkeys.ezyplatform.cli.data.ModuleMetadata;
import org.youngmonkeys.ezyplatform.cli.io.CliFolderProxy;
import org.youngmonkeys.ezyplatform.cli.io.CliModuleMetadataMapReader;

public final class CliClasspathBuilder {
    private static final CliClasspathBuilder INSTANCE = new CliClasspathBuilder();

    private CliClasspathBuilder() {
    }

    public static CliClasspathBuilder getInstance() {
        return INSTANCE;
    }

    public String build(String target) throws Exception {
        File[] containerFolders = CliFolderProxy.getContainerFoldersByTarget(target);
        StringBuilder builder = new StringBuilder();
        for (File containerFolder : containerFolders) {
            File[] modules;
            Map<String, ModuleMetadata> metadataMap = this.readModuleMetadataMapByTarget(target, containerFolder.getName());
            for (File file : modules = CliFolderProxy.listFiles(containerFolder)) {
                Path resourcesFolder;
                String moduleName;
                ModuleMetadata metadata;
                if (file.isFile() || (metadata = metadataMap.get(moduleName = file.getName())) == null || !metadata.isActive()) continue;
                Path libFolder = Paths.get(file.getPath(), "lib");
                if (Files.exists(libFolder, new LinkOption[0])) {
                    builder.append(libFolder).append(File.separator).append("*").append(File.pathSeparator);
                }
                if (!Files.exists(resourcesFolder = Paths.get(file.getPath(), "resources"), new LinkOption[0])) continue;
                builder.append(resourcesFolder).append(File.pathSeparator);
            }
        }
        return builder.toString();
    }

    private Map<String, ModuleMetadata> readModuleMetadataMapByTarget(String target, String containerFolder) throws Exception {
        return CliModuleMetadataMapReader.getInstance().readByTargetAndFileName(target, containerFolder);
    }
}

