/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.jpa.repository;

import com.tvd12.ezydata.database.EzyDatabaseContext;
import com.tvd12.ezydata.database.EzyDatabaseContextAware;
import com.tvd12.ezydata.database.EzyDatabaseRepository;
import com.tvd12.ezydata.jpa.EzyJpaDatabaseContext;
import com.tvd12.ezydata.jpa.reflect.EzyJpaIdProxy;
import com.tvd12.ezyfox.exception.UnimplementedOperationException;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;

public class EzyJpaRepository<I, E>
extends EzyLoggable
implements EzyDatabaseRepository<I, E>,
EzyDatabaseContextAware {
    protected final Class<E> entityType = this.getEntityType();
    protected final EzyClass entityClass = new EzyClass(this.entityType);
    protected final EzyJpaIdProxy idProxy = new EzyJpaIdProxy(this.entityClass);
    protected EzyJpaDatabaseContext databaseContext;
    protected static final Object[] NO_PARAMETERS = new Object[0];

    public void setDatabaseContext(EzyDatabaseContext context) {
        this.databaseContext = (EzyJpaDatabaseContext)context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(E entity) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                Object result = entityManager.merge(entity);
                transaction.commit();
                this.idProxy.setId(result, entity);
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Iterable<E> entities) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                ArrayList<Object> results = new ArrayList<Object>();
                for (E entity : entities) {
                    Object result = entityManager.merge(entity);
                    results.add(result);
                }
                transaction.commit();
                int i = 0;
                for (E entity : entities) {
                    this.idProxy.setId(results.get(i++), entity);
                }
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    public E findById(I id) {
        return this.findByField("id", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E findByField(String field, Object value) {
        List resultList;
        String queryString = "select e from " + this.entityType.getName() + " e where e." + field + " = ?0";
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createQuery(queryString);
            query.setParameter(0, value);
            query.setMaxResults(1);
            resultList = query.getResultList();
        }
        E entity = resultList.isEmpty() ? null : (E)resultList.get(0);
        return entity;
    }

    public List<E> findListByField(String field, Object value, int skip, int limit) {
        String queryString = "select e from " + this.entityType.getName() + " e where e." + field + " = ?0";
        return this.findListByQueryString(queryString, new Object[]{value}, skip, limit);
    }

    public List<E> findListByField(String field, Object value) {
        String queryString = "select e from " + this.entityType.getName() + " e where e." + field + " = ?0";
        return this.findListByQueryString(queryString, new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E findByQueryString(String queryString, Object[] parameters) {
        List resultList;
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            query.setMaxResults(1);
            resultList = query.getResultList();
        }
        E entity = resultList.isEmpty() ? null : (E)resultList.get(0);
        return entity;
    }

    public List<E> findListByIds(Collection<I> ids) {
        String queryString = "select e from " + this.entityType.getName() + " e where e.id in ?0";
        return this.findListByQueryString(queryString, new Object[]{ids});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<E> findListByQueryString(String queryString, Object[] parameters) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            List list = query.getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<E> findListByQueryString(String queryString, Object[] parameters, int skip, int limit) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            query.setFirstResult(skip);
            query.setMaxResults(limit);
            List list = query.getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<E> findListByQueryString(String queryString, Map<String, Object> parameters, int skip, int limit) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            query.setFirstResult(skip);
            query.setMaxResults(limit);
            List list = query.getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> List<R> fetchListByQueryString(String queryString, Object[] parameters, Class<R> resultType, int skip, int limit) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            query.setFirstResult(skip);
            query.setMaxResults(limit);
            List list = this.databaseContext.deserializeResultList(query.getResultList(), resultType);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> List<R> fetchListByQueryString(String queryString, Map<String, Object> parameters, Class<R> resultType, int skip, int limit) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            query.setFirstResult(skip);
            query.setMaxResults(limit);
            List list = this.databaseContext.deserializeResultList(query.getResultList(), resultType);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> findAll() {
        String queryString = "select e from " + this.entityType.getName() + " e ";
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createQuery(queryString);
            List list = query.getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> findAll(int skip, int limit) {
        String queryString = "select e from " + this.entityType.getName() + " e ";
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createQuery(queryString);
            query.setFirstResult(skip);
            query.setMaxResults(limit);
            List list = query.getResultList();
            return list;
        }
    }

    public boolean containsById(I id) {
        return this.containsByField("id", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsByField(String field, Object value) {
        List resultList;
        String queryString = "select e." + field + " from " + this.entityType.getName() + " e where e." + field + " = ?0";
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createQuery(queryString);
            query.setParameter(0, value);
            query.setMaxResults(1);
            resultList = query.getResultList();
        }
        return resultList.size() > 0;
    }

    public int deleteAll() {
        String queryString = "delete from " + this.entityType.getName() + " e ";
        return this.deleteByQueryString(queryString, NO_PARAMETERS);
    }

    public void delete(I id) {
        String queryString = "delete from " + this.entityType.getName() + " e where e.id = ?0";
        this.deleteByQueryString(queryString, new Object[]{id});
    }

    public int deleteByIds(Collection<I> ids) {
        String queryString = "delete from " + this.entityType.getName() + " e where e.id in ?0";
        return this.deleteByQueryString(queryString, new Object[]{ids});
    }

    protected int deleteByQueryString(String queryString, Object[] parameters) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                int deletedRows = query.executeUpdate();
                transaction.commit();
                int n = deletedRows;
                return n;
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        String queryString = "select count(e.id) from " + this.entityType.getName() + " e ";
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createQuery(queryString);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long countByQueryString(String queryString, Object[] parameters) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long countByQueryString(String queryString, Map<String, Object> parameters) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = this.createQuery(entityManager, queryString, parameters);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    protected Query createQuery(EntityManager entityManager, String queryString, Object[] parameters) {
        Query query = entityManager.createQuery(queryString);
        for (int i = 0; i < parameters.length; ++i) {
            query.setParameter(i, parameters[i]);
        }
        return query;
    }

    protected Query createQuery(EntityManager entityManager, String queryString, Map<String, Object> parameters) {
        Query query = entityManager.createQuery(queryString);
        for (String paramName : parameters.keySet()) {
            Object paramValue = parameters.get(paramName);
            if (paramValue == null) continue;
            query.setParameter(paramName, paramValue);
        }
        return query;
    }

    protected Class<E> getEntityType() {
        try {
            Type genericSuperclass = ((Object)((Object)this)).getClass().getGenericSuperclass();
            Class[] genericArgs = EzyGenerics.getTwoGenericClassArguments((Type)genericSuperclass);
            return genericArgs[1];
        }
        catch (Exception e) {
            throw new UnimplementedOperationException("class " + ((Object)((Object)this)).getClass().getName() + " hasn't implemented method 'getEntityType'", (Throwable)e);
        }
    }
}

