/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.manager;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.PostRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.manager.EnvironmentManager;
import org.youngmonkeys.ezyplatform.manager.MarketUrlManager;
import org.youngmonkeys.ezyplatform.manager.SimpleFileSystemManager;

public class EzyPlatformKeyManager
extends EzyLoggable {
    private final HttpClient httpClient;
    private final MarketUrlManager marketUrlManager;
    private final EnvironmentManager environmentManager;
    private final SimpleFileSystemManager fileSystemManager;
    private final AtomicReference<String> platformKeyRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlatformKey() {
        if (this.platformKeyRef.get() == null) {
            AtomicReference<String> atomicReference = this.platformKeyRef;
            synchronized (atomicReference) {
                if (this.platformKeyRef.get() == null) {
                    this.platformKeyRef.set(this.doGetPlatformKey());
                }
            }
        }
        return this.platformKeyRef.get();
    }

    private String doGetPlatformKey() {
        try {
            String currentKey = "";
            File platformKeyFile = this.fileSystemManager.getPlatformKeyFile();
            if (platformKeyFile.exists()) {
                if (!platformKeyFile.canRead()) {
                    throw FilePermissionException.fromFileAction((File)platformKeyFile, (String)"read");
                }
                if (!platformKeyFile.canWrite()) {
                    throw FilePermissionException.fromFileAction((File)platformKeyFile, (String)"write");
                }
                currentKey = this.getCurrentPlatformKey(platformKeyFile);
            }
            String newKey = this.getNewPlatformKey(currentKey);
            FolderProxy.createNewFile((File)platformKeyFile);
            Files.write(platformKeyFile.toPath(), newKey.getBytes(), new OpenOption[0]);
            return newKey;
        }
        catch (FilePermissionException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warn("get new platform key error", (Throwable)e);
            return null;
        }
    }

    private String getNewPlatformKey(String currentKey) throws Exception {
        Map response = (Map)this.httpClient.call((Request)((PostRequest)((PostRequest)new PostRequest().setURL(this.marketUrlManager.getPlatformGenerateNewKeyUrl(this.environmentManager.getPlatformVersion()))).setResponseType(Map.class)).setEntity(RequestEntity.builder().header("platformKey", currentKey).build()));
        return (String)response.get("newKey");
    }

    private String getCurrentPlatformKey(File platformKeyFile) throws IOException {
        if (platformKeyFile.exists()) {
            return new String(Files.readAllBytes(platformKeyFile.toPath()));
        }
        return null;
    }

    @Generated
    public EzyPlatformKeyManager(HttpClient httpClient, MarketUrlManager marketUrlManager, EnvironmentManager environmentManager, SimpleFileSystemManager fileSystemManager) {
        this.httpClient = httpClient;
        this.marketUrlManager = marketUrlManager;
        this.environmentManager = environmentManager;
        this.fileSystemManager = fileSystemManager;
    }
}

