/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.util;

import com.tvd12.reflections.util.ImmutableEntry;
import com.tvd12.reflections.util.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class AbstractMultimap<K, V>
implements Multimap<K, V> {
    protected final Map map;
    protected final Supplier factory;

    public AbstractMultimap(Map<K, ? extends Collection<V>> map, Supplier<? extends Collection<V>> factory) {
        this.map = map;
        this.factory = factory;
    }

    @Override
    public boolean put(K key, V item) {
        Collection<V> value = this.get(key);
        boolean answer = value.add(item);
        return answer;
    }

    @Override
    public boolean putAll(Multimap<K, V> multimap) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    public Collection<V> get(K key) {
        Object answer = this.map.get(key);
        if (answer == null) {
            answer = this.factory.get();
            this.map.put(key, answer);
        }
        return (Collection)answer;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Iterable<Map.Entry<K, V>> entries() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>();
        for (Object key : this.map.keySet()) {
            Collection items = (Collection)this.map.get(key);
            for (Object value : items) {
                set.add(new ImmutableEntry(key, value));
            }
        }
        return set;
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

