/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.management;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.handler.ManagementController;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import com.tvd12.ezyhttp.server.core.manager.RequestHandlerManager;
import com.tvd12.ezyhttp.server.core.request.RequestURI;
import com.tvd12.ezyhttp.server.management.data.ApiInformation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@Api
@Authenticated
@Controller
public class WebManagementController
implements ManagementController {
    private final FeatureURIManager futureURIManager;
    private final RequestHandlerManager requestHandlerManager;

    @EzyFeature(value="devops")
    @DoGet(value="/management/apis")
    public List<ApiInformation> apiListGet() {
        return this.requestHandlerManager.getHandlerListByURI().entrySet().stream().map(it -> new ApiInformation((RequestURI)it.getKey(), (List)it.getValue())).collect(Collectors.toList());
    }

    @EzyFeature(value="devops")
    @DoGet(value="/management/features")
    public Map<String, Map<String, List<HttpMethod>>> featuresGet() {
        return this.futureURIManager.getURIsByFeatureMap();
    }

    @EzyFeature(value="devops")
    @DoGet(value="/management/feature-names")
    public List<String> featureNamesGet() {
        return this.futureURIManager.getFeatures();
    }

    @Generated
    public WebManagementController(FeatureURIManager futureURIManager, RequestHandlerManager requestHandlerManager) {
        this.futureURIManager = futureURIManager;
        this.requestHandlerManager = requestHandlerManager;
    }
}

