/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyDates;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.jackson.JacksonObjectMapperBuilder;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.function.Consumer;

public class ObjectMapperBuilder
implements EzyBuilder<ObjectMapper> {
    private Consumer<ObjectMapper> decorator;

    public ObjectMapper build() {
        ObjectMapper objectMapper = JacksonObjectMapperBuilder.newInstance().build().registerModule(this.newModule()).findAndRegisterModules();
        if (this.decorator != null) {
            this.decorator.accept(objectMapper);
        }
        return objectMapper;
    }

    public ObjectMapperBuilder decorator(Consumer<ObjectMapper> decorator) {
        this.decorator = decorator;
        return this;
    }

    protected Module newModule() {
        SimpleModule module = new SimpleModule("ezyhttp");
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserialize());
        module.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserialize());
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserialize());
        module.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserialize());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserialize());
        return module;
    }

    public static class LocalDateTimeDeserialize
    extends StdDeserializer<LocalDateTime> {
        private static final long serialVersionUID = -7550269143426341730L;

        public LocalDateTimeDeserialize() {
            super(LocalDateTime.class);
        }

        public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() == JsonToken.VALUE_NUMBER_INT.id()) {
                return EzyDates.millisToDateTime((long)p.getValueAsLong());
            }
            if (p.currentTokenId() == JsonToken.VALUE_STRING.id()) {
                String value = p.getValueAsString();
                if (EzyStrings.isBlank((String)value)) {
                    return null;
                }
                try {
                    return LocalDateTime.parse(value);
                }
                catch (Exception e) {
                    return EzyDates.parseDateTime((String)value);
                }
            }
            throw new IOException("can deserialize value: " + p.getValueAsString() + " to LocalDateTime");
        }
    }

    public static class LocalTimeDeserialize
    extends StdDeserializer<LocalTime> {
        private static final long serialVersionUID = -7550269143426341730L;

        public LocalTimeDeserialize() {
            super(LocalTime.class);
        }

        public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() == JsonToken.VALUE_NUMBER_INT.id()) {
                return EzyDates.millisToDateTime((long)p.getValueAsLong()).toLocalTime();
            }
            if (p.currentTokenId() == JsonToken.VALUE_STRING.id()) {
                String value = p.getValueAsString();
                if (EzyStrings.isBlank((String)value)) {
                    return null;
                }
                try {
                    return LocalTime.parse(value);
                }
                catch (Exception e) {
                    return EzyDates.parseTime((String)value);
                }
            }
            throw new IOException("can deserialize value: " + p.getValueAsString() + " to LocalTime");
        }
    }

    public static class LocalDateDeserialize
    extends StdDeserializer<LocalDate> {
        private static final long serialVersionUID = -7550269143426341730L;

        public LocalDateDeserialize() {
            super(LocalDate.class);
        }

        public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() == JsonToken.VALUE_NUMBER_INT.id()) {
                return EzyDates.millisToDateTime((long)p.getValueAsLong()).toLocalDate();
            }
            if (p.currentTokenId() == JsonToken.VALUE_STRING.id()) {
                String value = p.getValueAsString();
                if (EzyStrings.isBlank((String)value)) {
                    return null;
                }
                return EzyDates.parseDate((String)value);
            }
            throw new IOException("can deserialize value: " + p.getValueAsString() + " to LocalDate");
        }
    }

    public static class InstantDeserialize
    extends StdDeserializer<Instant> {
        private static final long serialVersionUID = -7550269143426341730L;

        public InstantDeserialize() {
            super(Instant.class);
        }

        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() == JsonToken.VALUE_NUMBER_INT.id()) {
                return Instant.ofEpochMilli(p.getValueAsLong());
            }
            if (p.currentTokenId() == JsonToken.VALUE_STRING.id()) {
                String value = p.getValueAsString();
                if (EzyStrings.isBlank((String)value)) {
                    return null;
                }
                return EzyDates.parse((String)value).toInstant();
            }
            throw new IOException("can deserialize value: " + p.getValueAsString() + " to Instant");
        }
    }

    public static class DateDeserialize
    extends StdDeserializer<Date> {
        private static final long serialVersionUID = -7550269143426341730L;

        public DateDeserialize() {
            super(Date.class);
        }

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentTokenId() == JsonToken.VALUE_NUMBER_INT.id()) {
                return new Date(p.getValueAsLong());
            }
            if (p.currentTokenId() == JsonToken.VALUE_STRING.id()) {
                String value = p.getValueAsString();
                if (EzyStrings.isBlank((String)value)) {
                    return null;
                }
                return EzyDates.parse((String)value);
            }
            throw new IOException("can deserialize value: " + p.getValueAsString() + " to Date");
        }
    }
}

