/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.resources;

import com.tvd12.ezyfox.concurrent.EzyCallableFutureTask;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureConcurrentHashMap;
import com.tvd12.ezyfox.concurrent.EzyFutureMap;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import com.tvd12.ezyfox.concurrent.callback.EzyResultCallback;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyStoppable;
import com.tvd12.ezyhttp.core.concurrent.HttpThreadFactory;
import com.tvd12.ezyhttp.core.exception.MaxResourceUploadCapacity;
import com.tvd12.ezyhttp.core.exception.MaxUploadSizeException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;

public class ResourceUploadManager
extends EzyLoggable
implements EzyStoppable,
EzyDestroyable {
    protected volatile boolean active;
    protected final int capacity;
    protected final int threadPoolSize;
    protected final int bufferSize;
    protected final ExecutorService executorService;
    protected final BlockingQueue<Entry> queue;
    protected final EzyFutureMap<Entry> futureMap;
    protected static final Entry POISON = new Entry();
    public static final int DEFAULT_CAPACITY = 100000;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_TIMEOUT = 900000;
    public static final long UNLIMITED_UPLOAD_SIZE = -1L;
    public static final int DEFAULT_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;

    public ResourceUploadManager() {
        this(100000, DEFAULT_THREAD_POOL_SIZE, 1024);
    }

    public ResourceUploadManager(int capacity, int threadPoolSize, int bufferSize) {
        this.capacity = capacity;
        this.threadPoolSize = threadPoolSize;
        this.bufferSize = bufferSize;
        this.queue = new LinkedBlockingQueue<Entry>(capacity);
        this.futureMap = new EzyFutureConcurrentHashMap();
        this.executorService = this.newExecutorService(threadPoolSize);
        this.start(threadPoolSize);
    }

    private ExecutorService newExecutorService(int threadPoolSize) {
        return EzyExecutors.newFixedThreadPool((int)threadPoolSize, (ThreadFactory)((Object)HttpThreadFactory.create("upload-manager")));
    }

    private void start(int threadPoolSize) {
        this.active = true;
        for (int i = 0; i < threadPoolSize; ++i) {
            this.executorService.execute(this::loop);
        }
    }

    private void loop() {
        byte[] buffer = new byte[this.bufferSize];
        while (this.active) {
            Entry entry = null;
            boolean done = true;
            boolean isMaxUploaded = false;
            Exception exception = null;
            try {
                entry = this.queue.take();
                if (entry == POISON) break;
                InputStream inputStream = entry.inputStream;
                OutputStream outputStream = entry.outputStream;
                int read = inputStream.read(buffer);
                if (entry.increaseUploadedSize(read)) {
                    if (read > 0) {
                        outputStream.write(buffer, 0, read);
                        done = false;
                    }
                } else {
                    isMaxUploaded = true;
                }
            }
            catch (Exception e) {
                exception = e;
                this.logger.info("upload broken", (Throwable)e);
            }
            catch (Throwable e) {
                exception = new IllegalStateException(e);
                this.logger.info("upload fatal error", e);
            }
            if (entry == null) continue;
            if (isMaxUploaded) {
                exception = new MaxUploadSizeException(entry.maxUploadSize);
            }
            try {
                EzyFuture future;
                if (done) {
                    future = this.futureMap.removeFuture((Object)entry);
                    if (future == null) continue;
                    if (exception != null) {
                        future.setException(exception);
                        continue;
                    }
                    future.setResult((Object)Boolean.TRUE);
                    continue;
                }
                if (this.queue.offer(entry) || (future = this.futureMap.removeFuture((Object)entry)) == null) continue;
                future.setException((Exception)new MaxResourceUploadCapacity(this.capacity));
            }
            catch (Throwable e) {
                this.logger.info("handle upload result error", e);
            }
        }
    }

    public void drain(InputStream from, OutputStream to, long maxUploadSize) throws Exception {
        Entry entry = new Entry(from, to, maxUploadSize);
        EzyFutureTask future = new EzyFutureTask();
        this.drain(entry, (EzyFuture)future);
        future.get(900000L);
    }

    public void drain(InputStream from, OutputStream to) throws Exception {
        this.drain(from, to, -1L);
    }

    private void drain(Entry entry, EzyFuture future) {
        this.futureMap.addFuture((Object)entry, future);
        boolean success = this.queue.offer(entry);
        if (!success) {
            this.futureMap.removeFuture((Object)entry);
            throw new MaxResourceUploadCapacity(this.capacity);
        }
    }

    public void drainAsync(InputStream from, OutputStream to, long maxUploadSize, EzyResultCallback<Boolean> callback) {
        Entry entry = new Entry(from, to, maxUploadSize);
        EzyCallableFutureTask future = new EzyCallableFutureTask(callback);
        this.drain(entry, (EzyFuture)future);
    }

    public void drainAsync(InputStream from, OutputStream to, EzyResultCallback<Boolean> callback) {
        this.drainAsync(from, to, -1L, callback);
    }

    public void stop() {
        this.active = false;
        for (int i = 0; i < this.threadPoolSize; ++i) {
            this.queue.offer(POISON);
        }
        this.executorService.shutdown();
    }

    public void destroy() {
        this.stop();
    }

    private static class Entry {
        private final InputStream inputStream;
        private final OutputStream outputStream;
        private final long maxUploadSize;
        private long currentUploadedSize;

        public Entry() {
            this(null, null, 0L);
        }

        public Entry(InputStream inputStream, OutputStream outputStream, long maxUploadSize) {
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            this.maxUploadSize = maxUploadSize;
        }

        public boolean increaseUploadedSize(int uploadedSize) {
            this.currentUploadedSize += (long)uploadedSize;
            if (this.maxUploadSize <= 0L) {
                return true;
            }
            return this.currentUploadedSize <= this.maxUploadSize;
        }
    }
}

