/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfoxserver.EzyZonesStarter;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.event.EzySimpleServerInitializingEvent;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;

public class EzyBootstrap
extends EzyLoggable
implements EzyStartable,
EzyDestroyable {
    protected final EzyServerContext context;

    protected EzyBootstrap(Builder builder) {
        this.context = builder.context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() throws Exception {
        this.notifyServerInitializing();
        this.startAllZones();
        this.startSessionManager();
    }

    protected void notifyServerInitializing() {
        EzySimpleServerInitializingEvent event = new EzySimpleServerInitializingEvent();
        this.context.handleEvent(EzyEventType.SERVER_INITIALIZING, event);
    }

    public void destroy() {
    }

    private void startAllZones() {
        EzyZonesStarter.Builder builder = (EzyZonesStarter.Builder)this.newZonesStarterBuilder().serverContext(this.context);
        EzyZonesStarter starter = builder.build();
        starter.start();
    }

    protected EzyZonesStarter.Builder newZonesStarterBuilder() {
        return new EzyZonesStarter.Builder();
    }

    protected void startSessionManager() throws Exception {
        EzySessionManager sessionManager = this.context.getServer().getSessionManager();
        ((EzyStartable)sessionManager).start();
    }

    public static class Builder
    implements EzyBuilder<EzyBootstrap> {
        protected EzyServerContext context;

        public Builder context(EzyServerContext context) {
            this.context = context;
            return this;
        }

        public EzyBootstrap build() {
            return new EzyBootstrap(this);
        }
    }
}

