/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.mapping.jaxb.EzySimpleXmlMapper;
import com.tvd12.ezyfox.mapping.jaxb.EzyXmlReader;
import com.tvd12.ezyfox.util.EzyInitable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyAppsSetting;
import com.tvd12.ezyfoxserver.setting.EzyHomePathAware;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginsSetting;
import com.tvd12.ezyfoxserver.setting.EzySessionManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySettingsDecorator;
import com.tvd12.ezyfoxserver.setting.EzySettingsReader;
import com.tvd12.ezyfoxserver.setting.EzySimpleSettings;
import com.tvd12.ezyfoxserver.setting.EzySimpleZoneFilesSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleZoneSetting;
import com.tvd12.ezyfoxserver.setting.EzyUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import java.nio.file.Paths;

public class EzySimpleSettingsReader
extends EzyLoggable
implements EzySettingsReader {
    protected String homePath;
    protected ClassLoader classLoader;
    protected EzySettingsDecorator settingsDecorator;

    protected EzySimpleSettingsReader(Builder builder) {
        this.homePath = builder.homePath;
        this.classLoader = builder.classLoader;
        this.settingsDecorator = builder.settingsDecorator;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EzySettings read() {
        EzySettings settings = this.readSettings();
        this.postReadSettings(settings);
        return settings;
    }

    protected EzySettings readSettings() {
        this.logger.info("read setting file: {}", (Object)this.getSettingsFilePath());
        EzyXmlReader xmlReader = this.newXmlReader();
        EzySimpleSettings settings = this.readSettingsFile(xmlReader);
        EzySimpleZoneFilesSetting zoneFiles = settings.getZoneFiles();
        zoneFiles.forEach(zf -> {
            if (!zf.isActive()) {
                return;
            }
            EzySimpleZoneSetting zoneSetting = this.readZoneConfigFile(xmlReader, zf.getConfigFile());
            this.postReadZoneSettings(zoneSetting);
            zoneSetting.setName(zf.getName());
            zoneSetting.setConfigFile(zf.getConfigFile());
            zoneSetting.init();
            settings.addZone(zoneSetting);
        });
        if (this.settingsDecorator != null) {
            this.settingsDecorator.decorate(this.homePath, settings);
        }
        return settings;
    }

    protected EzySimpleSettings readSettingsFile(EzyXmlReader xmlReader) {
        return (EzySimpleSettings)xmlReader.read(this.getSettingsFilePath(), EzySimpleSettings.class);
    }

    protected EzySimpleZoneSetting readZoneConfigFile(EzyXmlReader xmlReader, String configFile) {
        return (EzySimpleZoneSetting)xmlReader.read(this.getZoneConfigFilePath(configFile), EzySimpleZoneSetting.class);
    }

    protected void postReadSettings(EzySettings settings) {
        this.updateSessionManagementSetting(settings.getSessionManagement());
    }

    protected void postReadZoneSettings(EzyZoneSetting zoneSetting) {
        this.updatePluginsSetting(zoneSetting.getPlugins());
        this.updateAppsSetting(zoneSetting.getApplications());
        this.updateUserManagementSetting(zoneSetting.getUserManagement());
    }

    protected void updateAppsSetting(EzyAppsSetting apps) {
        for (EzyAppSetting app : apps.getApps()) {
            ((EzyHomePathAware)((Object)app)).setHomePath(this.homePath);
        }
    }

    protected void updatePluginsSetting(EzyPluginsSetting plugins) {
        for (EzyPluginSetting plugin : plugins.getPlugins()) {
            ((EzyHomePathAware)((Object)plugin)).setHomePath(this.homePath);
        }
    }

    protected void updateUserManagementSetting(EzyUserManagementSetting setting) {
        ((EzyInitable)setting).init();
    }

    protected void updateSessionManagementSetting(EzySessionManagementSetting setting) {
        ((EzyInitable)setting).init();
    }

    protected EzyXmlReader newXmlReader() {
        return EzySimpleXmlMapper.builder().classLoader(this.classLoader).contextPath("com.tvd12.ezyfoxserver").build();
    }

    protected String getSettingsPath() {
        return this.getPath(this.homePath, "settings");
    }

    protected String getSettingsFilePath() {
        return this.getPath(this.getSettingsPath(), "ezy-settings.xml");
    }

    protected String getZoneConfigFilePath(String configFile) {
        return this.getPath(this.getSettingsPath(), "zones", configFile);
    }

    protected String getPath(String first, String ... more) {
        return Paths.get(first, more).toString();
    }

    public static class Builder
    implements EzyBuilder<EzySettingsReader> {
        protected String homePath;
        protected ClassLoader classLoader;
        protected EzySettingsDecorator settingsDecorator;

        public Builder homePath(String homePath) {
            this.homePath = homePath;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder settingsDecorator(EzySettingsDecorator settingsDecorator) {
            this.settingsDecorator = settingsDecorator;
            return this;
        }

        public EzySettingsReader build() {
            return new EzySimpleSettingsReader(this);
        }
    }
}

