/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.handler;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.view.View;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface UnhandledErrorHandler {
    default public Object processError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode, Exception exception) {
        return null;
    }

    default public Object handleError(HttpMethod method, HttpServletRequest request, HttpServletResponse response, int errorStatusCode, Exception exception) {
        Object result = this.processError(method, request, response, errorStatusCode, exception);
        if (result != null) {
            if (result instanceof ResponseEntity) {
                response.setContentType(((ResponseEntity)result).getContentType());
            } else if (result instanceof View) {
                response.setContentType("text/html; charset=utf-8");
            }
            if (EzyStrings.isNoContent((String)response.getContentType())) {
                response.setContentType("application/json");
            }
        }
        return result;
    }
}

