/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.resources;

import com.tvd12.ezyfox.concurrent.callback.EzyResultCallback;
import com.tvd12.ezyfox.function.EzyExceptionVoid;
import com.tvd12.ezyfox.util.EzyFileUtil;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyhttp.core.exception.MaxUploadSizeException;
import com.tvd12.ezyhttp.core.resources.ResourceUploadManager;
import com.tvd12.ezyhttp.server.core.resources.FileUploadCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import lombok.Generated;

public class FileUploader
extends EzyLoggable {
    private final ResourceUploadManager resourceUploadManager;
    private final int defaultTimeout;
    private static final byte[] OVER_UPLOAD_SIZE_MESSAGE = "{\"uploadSize\":\"over\"}".getBytes();

    public FileUploader(ResourceUploadManager resourceUploadManager) {
        this(resourceUploadManager, 0);
    }

    public void accept(AsyncContext asyncContext, Part part, File outputFile, EzyExceptionVoid callback) {
        this.accept(asyncContext, part, outputFile, -1L, callback);
    }

    public void accept(final AsyncContext asyncContext, Part part, File outputFile, long maxUploadSize, final EzyExceptionVoid callback) {
        final HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
        this.accept(asyncContext, part, outputFile, maxUploadSize, new FileUploadCallback(){

            @Override
            public void onSuccess() {
                try {
                    callback.apply();
                    response.setStatus(200);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof MaxUploadSizeException) {
                    EzyProcessor.processWithLogException(() -> response.getOutputStream().write(OVER_UPLOAD_SIZE_MESSAGE));
                    response.setStatus(400);
                } else {
                    response.setStatus(500);
                }
                HttpServletRequest request = (HttpServletRequest)asyncContext.getRequest();
                FileUploader.this.logger.info("accept request: {} error", (Object)request.getRequestURI(), (Object)e);
            }
        });
    }

    public void accept(AsyncContext asyncContext, Part part, File outputFile, FileUploadCallback callback) {
        this.accept(asyncContext, part, outputFile, -1L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(AsyncContext asyncContext, Part part, File outputFile, long maxUploadSize, FileUploadCallback callback) {
        try {
            this.accept(asyncContext, part.getInputStream(), outputFile, maxUploadSize, callback);
        }
        catch (Exception e) {
            try {
                callback.onFailure(e);
            }
            finally {
                EzyProcessor.processWithLogException(() -> ((AsyncContext)asyncContext).complete());
            }
        }
    }

    public void accept(AsyncContext asyncContext, InputStream inputStream, File outputFile, FileUploadCallback callback) {
        this.accept(asyncContext, inputStream, outputFile, -1L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(AsyncContext asyncContext, InputStream inputStream, File outputFile, long maxUploadSize, final FileUploadCallback callback) {
        try {
            EzyFileUtil.createFileIfNotExists((File)outputFile);
            final FileOutputStream outputStream = new FileOutputStream(outputFile);
            this.accept(asyncContext, inputStream, outputStream, maxUploadSize, new FileUploadCallback(){

                @Override
                public void onSuccess() {
                    EzyProcessor.processWithLogException(outputStream::close);
                    callback.onSuccess();
                }

                @Override
                public void onFailure(Exception e) {
                    EzyProcessor.processWithLogException(outputStream::close);
                    callback.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            try {
                callback.onFailure(e);
            }
            finally {
                EzyProcessor.processWithLogException(() -> ((AsyncContext)asyncContext).complete());
            }
        }
    }

    public void accept(AsyncContext asyncContext, InputStream inputStream, OutputStream outputStream, FileUploadCallback callback) {
        this.accept(asyncContext, inputStream, outputStream, -1L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(final AsyncContext asyncContext, InputStream inputStream, OutputStream outputStream, long maxUploadSize, final FileUploadCallback callback) {
        try {
            if (this.defaultTimeout > 0) {
                asyncContext.setTimeout((long)this.defaultTimeout);
            }
            this.resourceUploadManager.drainAsync(inputStream, outputStream, maxUploadSize, (EzyResultCallback)new EzyResultCallback<Boolean>(){

                public void onResponse(Boolean response) {
                    try {
                        callback.onSuccess();
                    }
                    finally {
                        asyncContext.complete();
                    }
                }

                public void onException(Exception e) {
                    try {
                        callback.onFailure(e);
                    }
                    finally {
                        asyncContext.complete();
                    }
                }
            });
        }
        catch (Exception e) {
            try {
                callback.onFailure(e);
            }
            finally {
                EzyProcessor.processWithLogException(() -> ((AsyncContext)asyncContext).complete());
            }
        }
    }

    @Generated
    public FileUploader(ResourceUploadManager resourceUploadManager, int defaultTimeout) {
        this.resourceUploadManager = resourceUploadManager;
        this.defaultTimeout = defaultTimeout;
    }
}

