/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.resources;

import com.tvd12.ezyfox.function.EzySupplier;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.server.core.resources.ResourceFile;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceLoader
extends EzyLoggable {
    private static final String PROTOCOL_FILE = "file";
    private static final String PROTOCOL_JAR = "jar";
    private static final String PROTOCOL_FILE_PREFIX = "file:";

    public List<String> listResources(String rootPath) {
        return EzyLists.newArrayList(this.listResourceFiles(rootPath), ResourceFile::getRelativePath);
    }

    public List<String> listResources(String rootPath, Set<String> regexes) {
        return EzyLists.newArrayList(this.listResourceFiles(rootPath, regexes), ResourceFile::getRelativePath);
    }

    public List<ResourceFile> listResourceFiles(String rootPath) {
        return this.listResourceFiles(rootPath, Collections.emptySet());
    }

    public List<ResourceFile> listResourceFiles(String rootPath, Set<String> regexes) {
        ArrayList<ResourceFile> answer = new ArrayList<ResourceFile>();
        Set<URL> resourceURLs = this.getResourceURLs(rootPath);
        if (resourceURLs.isEmpty()) {
            this.listResourcesByFolder(new File(rootPath), regexes, rootPath, answer);
        } else {
            for (URL url : resourceURLs) {
                this.listResourcesByURL(url, regexes, rootPath, answer);
            }
        }
        return answer;
    }

    protected void listResourcesByURL(URL url, Set<String> regexes, String rootPath, List<ResourceFile> answer) {
        if (url.getProtocol().equals(PROTOCOL_FILE)) {
            this.listResourcesByFileURL(url, regexes, rootPath, answer);
        } else if (url.getProtocol().equals(PROTOCOL_JAR)) {
            this.listResourcesByJarURL(url, regexes, rootPath, answer);
        }
    }

    protected void listResourcesByFileURL(URL url, Set<String> regexes, String rootPath, List<ResourceFile> answer) {
        this.listResourcesByFolder(new File(url.getPath()), regexes, rootPath, answer);
    }

    protected void listResourcesByFolder(File rootFolder, Set<String> regexes, String rootPath, List<ResourceFile> answer) {
        LinkedList<File> folders = new LinkedList<File>();
        folders.offer(rootFolder);
        while (!folders.isEmpty()) {
            File[] fileList;
            File folder = (File)folders.poll();
            for (File resource : fileList = this.listFile(folder)) {
                String resourcePath = resource.toString().substring(rootFolder.toString().length() + 1);
                String relativePath = rootPath + "/" + resourcePath;
                boolean addable = regexes.isEmpty();
                for (String regex : regexes) {
                    if (!ResourceFile.isResourcePathMatch(relativePath, regex)) continue;
                    addable = true;
                    break;
                }
                if (addable && resource.isFile()) {
                    answer.add(new ResourceFile(relativePath, resource.toString(), false));
                }
                if (!resource.isDirectory()) continue;
                folders.offer(resource);
            }
        }
    }

    protected void listResourcesByJarURL(URL url, Set<String> regexes, String rootPath, List<ResourceFile> answer) {
        String jarPath = url.getPath().substring(PROTOCOL_FILE_PREFIX.length(), url.getPath().indexOf("!"));
        JarFile jar = this.getJarFile(jarPath);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith(rootPath)) continue;
            boolean addable = regexes.isEmpty();
            for (String regex : regexes) {
                if (!ResourceFile.isResourcePathMatch(name, regex)) continue;
                addable = true;
                break;
            }
            if (!addable || !this.isFileElement(name)) continue;
            answer.add(new ResourceFile(name, jarPath + "!/" + name, true));
        }
    }

    protected File[] listFile(File folder) {
        File[] files = folder.listFiles();
        return files != null ? files : new File[]{};
    }

    protected boolean isFileElement(String elementName) {
        return !elementName.endsWith("/") && !elementName.endsWith("\\");
    }

    protected JarFile getJarFile(String filePath) {
        try {
            return new JarFile(URLDecoder.decode(filePath, "UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Set<URL> getResourceURLs(String resource) {
        String[] resources;
        HashSet<URL> answer = new HashSet<URL>();
        for (String res : resources = new String[]{resource, "/" + resource}) {
            this.addURLsToSet(answer, (EzySupplier<Enumeration<URL>>)((EzySupplier)() -> this.getContextClassLoader().getResources(res)));
            this.addURLsToSet(answer, (EzySupplier<Enumeration<URL>>)((EzySupplier)() -> ((Object)((Object)this)).getClass().getClassLoader().getResources(res)));
            this.addURLsToSet(answer, (EzySupplier<Enumeration<URL>>)((EzySupplier)() -> ClassLoader.getSystemResources(res)));
            this.addURLToSet(answer, this.getContextClassLoader().getResource(res));
            this.addURLToSet(answer, ((Object)((Object)this)).getClass().getResource(res));
            this.addURLToSet(answer, ((Object)((Object)this)).getClass().getClassLoader().getResource(res));
            this.addURLToSet(answer, ClassLoader.getSystemResource(res));
        }
        return answer;
    }

    private void addURLsToSet(Set<URL> answer, EzySupplier<Enumeration<URL>> supplier) {
        try {
            Enumeration urls = (Enumeration)supplier.get();
            this.addURLsToSet(answer, urls);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addURLsToSet(Set<URL> answer, Enumeration<URL> urls) {
        if (urls != null) {
            while (urls.hasMoreElements()) {
                answer.add(urls.nextElement());
            }
        }
    }

    private void addURLToSet(Set<URL> answer, URL url) {
        if (url != null) {
            answer.add(url);
        }
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

