/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.handler;

import com.tvd12.ezyfox.callback.EzyCallback;
import com.tvd12.ezyfox.codec.EzyByteToObjectDecoder;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageDataDecoder;
import com.tvd12.ezyfox.codec.EzyMessageHeader;
import com.tvd12.ezyfox.codec.EzySimpleMessageDataDecoder;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.nio.handler.EzyAbstractHandlerGroup;
import com.tvd12.ezyfoxserver.nio.handler.EzyNioHandlerGroup;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import com.tvd12.ezyfoxserver.socket.EzySimpleSocketStream;
import com.tvd12.ezyfoxserver.socket.EzySocketStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public class EzySimpleNioHandlerGroup
extends EzyAbstractHandlerGroup<EzyMessageDataDecoder>
implements EzyNioHandlerGroup {
    private final EzyCallback<EzyMessage> decodeBytesCallback = this::executeHandleReceivedMessage;

    public EzySimpleNioHandlerGroup(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected EzyMessageDataDecoder newDecoder(Object decoder) {
        return new EzySimpleMessageDataDecoder((EzyByteToObjectDecoder)decoder);
    }

    @Override
    public void fireBytesReceived(byte[] bytes) {
        try {
            ((EzyMessageDataDecoder)this.decoder).decode(bytes, this.decodeBytesCallback);
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void fireMessageReceived(EzyMessage message) {
        this.executeHandleReceivedMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHandleReceivedMessage(EzyMessage message) {
        try {
            EzyMessageHeader header = message.getHeader();
            if (header.isRawBytes()) {
                boolean sessionStreamingEnable = this.session.isStreamingEnable();
                if (!this.streamingEnable || !sessionStreamingEnable) {
                    return;
                }
                byte[] rawBytes = message.getContent();
                EzySimpleSocketStream stream = new EzySimpleSocketStream((EzySession)this.session, rawBytes);
                this.streamQueue.add((EzySocketStream)stream);
            } else {
                Object data = ((EzyMessageDataDecoder)this.decoder).decode(message, this.session.getSessionKey());
                int dataSize = message.getByteCount();
                this.handleReceivedData(data, dataSize);
            }
        }
        catch (Throwable e) {
            this.fireExceptionCaught(e);
        }
        finally {
            this.executeAddReadBytes(message.getByteCount());
        }
    }

    @Override
    protected void doSendPacketNow(EzyPacket packet) {
        ByteBuffer writeBuffer = ByteBuffer.allocate(packet.getSize());
        this.executeSendingPacket(packet, writeBuffer);
    }

    @Override
    protected int writePacketToSocket(EzyPacket packet, Object writeBuffer) throws Exception {
        byte[] bytes = this.getBytesToWrite(packet);
        int bytesToWrite = bytes.length;
        ByteBuffer buffer = this.getWriteBuffer((ByteBuffer)writeBuffer, bytesToWrite);
        buffer.clear();
        buffer.put(bytes);
        buffer.flip();
        int bytesWritten = this.channel.write((Object)buffer, packet.isBinary());
        if (bytesWritten < bytesToWrite) {
            byte[] remainBytes = this.getPacketFragment(buffer);
            packet.setFragment((Object)remainBytes);
            SelectionKey selectionKey = this.session.getSelectionKey();
            if (selectionKey != null && selectionKey.isValid()) {
                selectionKey.interestOps(5);
            } else {
                this.logger.warn("selection key invalid, written bytes: {}, session: {}", (Object)bytesWritten, (Object)this.session);
            }
        } else {
            packet.release();
        }
        return bytesWritten;
    }

    private byte[] getPacketFragment(ByteBuffer buffer) {
        byte[] remainBytes = new byte[buffer.remaining()];
        buffer.get(remainBytes);
        return remainBytes;
    }

    public static class Builder
    extends EzyAbstractHandlerGroup.Builder {
        public EzyNioHandlerGroup build() {
            return new EzySimpleNioHandlerGroup(this);
        }
    }
}

