/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.entity;

import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.entity.EzyTransformable;
import com.tvd12.ezyfox.exception.EzyObjectGetException;
import com.tvd12.ezyfox.io.EzyInputTransformer;
import com.tvd12.ezyfox.io.EzyOutputTransformer;
import com.tvd12.ezyfox.util.EzyObjectToMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class EzyHashMap
extends EzyTransformable
implements EzyObject {
    private static final long serialVersionUID = 2273868568933801751L;
    protected final HashMap<Object, Object> map = new HashMap();

    public EzyHashMap(EzyInputTransformer inputTransformer, EzyOutputTransformer outputTransformer) {
        super(inputTransformer, outputTransformer);
    }

    public EzyHashMap(Map map, EzyInputTransformer inputTransformer, EzyOutputTransformer outputTransformer) {
        this(inputTransformer, outputTransformer);
        this.map.putAll(map);
    }

    @Override
    public <V> V put(Object key, Object value) {
        return (V)this.map.put(key, this.transformInput(value));
    }

    @Override
    public void putAll(Map m) {
        for (Object key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public <V> V get(Object key, Class<V> type) {
        return (V)this.getValue(key, type);
    }

    @Override
    public <V> V get(Object key) {
        return (V)this.map.get(key);
    }

    @Override
    public Object getValue(Object key, Class type) {
        Object value = this.map.get(key);
        try {
            return this.transformOutput(value, type);
        }
        catch (Exception e) {
            throw new EzyObjectGetException(key, value, type, e);
        }
    }

    @Override
    public <V> V remove(Object key) {
        return (V)this.map.remove(key);
    }

    @Override
    public void removeAll(Collection keys) {
        for (Object key : keys) {
            this.map.remove(key);
        }
    }

    @Override
    public <V> V compute(Object key, BiFunction func) {
        return (V)this.map.compute(key, func);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeys(Collection keys) {
        for (Object key : keys) {
            if (this.map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNotNullValue(Object key) {
        return this.map.get(key) != null;
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map toMap() {
        EzyObjectToMap objectToMap = EzyObjectToMap.getInstance();
        return objectToMap.toMap(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new EzyHashMap(this.map, this.inputTransformer, this.outputTransformer);
    }

    @Override
    public EzyObject duplicate() {
        try {
            return (EzyObject)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(EzyObject o) {
        EzyHashMap other = (EzyHashMap)o;
        int result = this.map.size() - other.map.size();
        if (result != 0) {
            return result;
        }
        for (Object key : this.map.keySet()) {
            Object value = this.map.get(key);
            Object otherValue = other.map.get(key);
            if (value == null) {
                if (otherValue == null) continue;
                return -1;
            }
            if (otherValue == null) {
                return 1;
            }
            if (value instanceof Comparable && otherValue instanceof Comparable) {
                result = ((Comparable)value).compareTo(otherValue);
                if (result == 0) continue;
                return result;
            }
            if (!(value instanceof Comparable)) {
                throw new IllegalArgumentException("value: " + value.getClass().getName() + "(" + value + ") is not comparable");
            }
            throw new IllegalArgumentException("value: " + otherValue.getClass().getName() + "(" + otherValue + ") is not comparable");
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        EzyHashMap t = (EzyHashMap)other;
        return t.map.equals(this.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    protected Object transformInput(Object input) {
        return this.inputTransformer.transform(input);
    }

    protected Object transformOutput(Object output, Class type) {
        return this.outputTransformer.transform(output, type);
    }

    public String toString() {
        return this.map.toString();
    }
}

