/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.reflect;

import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyhttp.server.core.annotation.TryCatch;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerMethod;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ExceptionHandlerProxy {
    protected final EzyClass clazz;
    protected final Object instance;
    protected final List<ExceptionHandlerMethod> exceptionHandlerMethods;

    public ExceptionHandlerProxy(Object instance) {
        this.instance = instance;
        this.clazz = new EzyClass(instance.getClass());
        this.exceptionHandlerMethods = this.fetchExceptionHandlerMethods();
    }

    public List<ExceptionHandlerMethod> fetchExceptionHandlerMethods() {
        ArrayList<ExceptionHandlerMethod> list = new ArrayList<ExceptionHandlerMethod>();
        List methods = this.clazz.getPublicMethods(m -> m.isAnnotated(TryCatch.class));
        for (EzyMethod method : methods) {
            ExceptionHandlerMethod m2 = new ExceptionHandlerMethod(method);
            list.add(m2);
        }
        return list;
    }

    public String getClassSimpleName() {
        return this.clazz.getClazz().getSimpleName();
    }

    public String toString() {
        return this.clazz.getName() + "(\n\tinstance: " + this.instance + ",\n\texceptionHandlerMethods: " + this.exceptionHandlerMethods + "\n)";
    }

    @Generated
    public EzyClass getClazz() {
        return this.clazz;
    }

    @Generated
    public Object getInstance() {
        return this.instance;
    }

    @Generated
    public List<ExceptionHandlerMethod> getExceptionHandlerMethods() {
        return this.exceptionHandlerMethods;
    }
}

