/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.servlet;

import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AsyncCallback
extends AsyncListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(AsyncCallback.class);

    default public void onError(AsyncEvent event) {
        try {
            AsyncContext asyncContext = event.getAsyncContext();
            ServletResponse response = asyncContext.getResponse();
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).setStatus(500);
            }
            asyncContext.complete();
            LOGGER.info("AsyncCallback.onError, request = {}", (Object)event.getSuppliedRequest());
        }
        catch (Throwable e) {
            LOGGER.info("AsyncCallback.onError failed, request = {}", (Object)event.getSuppliedRequest());
        }
    }

    default public void onTimeout(AsyncEvent event) {
        try {
            AsyncContext asyncContext = event.getAsyncContext();
            ServletResponse response = asyncContext.getResponse();
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).setStatus(408);
            }
            asyncContext.complete();
            LOGGER.info("AsyncCallback.onTimeout, request = {}", (Object)event.getSuppliedRequest());
        }
        catch (Throwable e) {
            LOGGER.info("AsyncCallback.onTimeout failed, request = {}", (Object)event.getSuppliedRequest());
        }
    }

    default public void onStartAsync(AsyncEvent event) {
        LOGGER.info("AsyncCallback.onStartAsync, request = {}", (Object)event.getSuppliedRequest());
    }
}

