/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.annotation.EzyPackagesToScan;
import com.tvd12.ezyfox.binding.EzyBindingContext;
import com.tvd12.ezyfox.binding.EzyBindingContextBuilder;
import com.tvd12.ezyfox.binding.EzyMarshaller;
import com.tvd12.ezyfox.binding.EzyReader;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.binding.EzyUnwrapper;
import com.tvd12.ezyfox.binding.EzyWriter;
import com.tvd12.ezyfox.binding.annotation.EzyArrayBinding;
import com.tvd12.ezyfox.binding.annotation.EzyBindingPackagesToScan;
import com.tvd12.ezyfox.binding.annotation.EzyConfiguration;
import com.tvd12.ezyfox.binding.annotation.EzyObjectBinding;
import com.tvd12.ezyfox.binding.annotation.EzyReaderImpl;
import com.tvd12.ezyfox.binding.annotation.EzyTemplateImpl;
import com.tvd12.ezyfox.binding.annotation.EzyWriterImpl;
import com.tvd12.ezyfox.binding.impl.EzyArrayReaderBuilder;
import com.tvd12.ezyfox.binding.impl.EzyArrayUnwrapperBuilder;
import com.tvd12.ezyfox.binding.impl.EzyArrayWriterBuilder;
import com.tvd12.ezyfox.binding.impl.EzyObjectReaderBuilder;
import com.tvd12.ezyfox.binding.impl.EzyObjectUnwrapperBuilder;
import com.tvd12.ezyfox.binding.impl.EzyObjectWriterBuilder;
import com.tvd12.ezyfox.binding.impl.EzySimpleConfigurationLoader;
import com.tvd12.ezyfox.binding.impl.EzySimpleMarshaller;
import com.tvd12.ezyfox.binding.impl.EzySimpleUnmarshaller;
import com.tvd12.ezyfox.binding.writer.EzyMapArrayWriter;
import com.tvd12.ezyfox.binding.writer.EzyMapObjectWriter;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyPackages;
import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleBindingContext
extends EzyLoggable
implements EzyBindingContext {
    protected Set<EzyWriter> writers = new HashSet<EzyWriter>();
    protected Set<EzyReader> readers = new HashSet<EzyReader>();
    protected Map<Class, EzyWriter> writersByObjectType = new ConcurrentHashMap<Class, EzyWriter>();
    protected Map<Class, EzyReader> readersByObjectType = new ConcurrentHashMap<Class, EzyReader>();
    protected Map<Class, EzyUnwrapper> unwrappersByObjectType = new ConcurrentHashMap<Class, EzyUnwrapper>();

    public static EzyBindingContextBuilder builder() {
        return new Builder();
    }

    @Override
    public EzyMarshaller newMarshaller() {
        EzySimpleMarshaller marshaller = new EzySimpleMarshaller();
        marshaller.addWriters(this.writers);
        marshaller.addWriters(this.writersByObjectType);
        return marshaller;
    }

    @Override
    public EzyUnmarshaller newUnmarshaller() {
        EzySimpleUnmarshaller unmarshaller = new EzySimpleUnmarshaller();
        unmarshaller.addReaders(this.readers);
        unmarshaller.addReaders(this.readersByObjectType);
        unmarshaller.addUnwrappers(this.unwrappersByObjectType);
        return unmarshaller;
    }

    @Override
    public void addReader(EzyReader reader) {
        this.readers.add(reader);
    }

    @Override
    public void addWriter(EzyWriter writer) {
        this.writers.add(writer);
    }

    @Override
    public void addTemplate(Object template) {
        if (template instanceof EzyReader) {
            this.addReader((EzyReader)template);
        }
        if (template instanceof EzyWriter) {
            this.addWriter((EzyWriter)template);
        }
    }

    @Override
    public void bindReader(Class clazz, EzyReader reader) {
        this.readersByObjectType.put(clazz, reader);
    }

    @Override
    public void bindWriter(Class clazz, EzyWriter writer) {
        this.writersByObjectType.put(clazz, writer);
    }

    @Override
    public void bindTemplate(Class clazz, Object template) {
        if (template instanceof EzyReader) {
            this.bindReader(clazz, (EzyReader)template);
        }
        if (template instanceof EzyWriter) {
            this.bindWriter(clazz, (EzyWriter)template);
        }
        if (template instanceof EzyUnwrapper) {
            this.bindUnwrapper(clazz, (EzyUnwrapper)template);
        }
    }

    public void bindUnwrapper(Class clazz, EzyUnwrapper unwrapper) {
        this.unwrappersByObjectType.put(clazz, unwrapper);
    }

    public static class Builder
    implements EzyBindingContextBuilder {
        protected Set<EzyWriter> writers = new HashSet<EzyWriter>();
        protected Set<EzyReader> readers = new HashSet<EzyReader>();
        protected Map<Class, EzyWriter> writersByObjectType = new HashMap<Class, EzyWriter>();
        protected Map<Class, EzyReader> readersByObjectType = new HashMap<Class, EzyReader>();
        protected Map<Class, EzyUnwrapper> unwrappersByObjectType = new HashMap<Class, EzyUnwrapper>();
        protected Set<Class> writerImplClasses = new HashSet<Class>();
        protected Set<Class> readerImplClasses = new HashSet<Class>();
        protected Set<Class> objectBindingClasses = new HashSet<Class>();
        protected Set<Class> arrayBindingClasses = new HashSet<Class>();
        protected Set<Class> packagesScanClasses = new HashSet<Class>();
        protected Set<Class> configurationClasses = new HashSet<Class>();

        @Override
        public EzyBindingContextBuilder scan(String packageName) {
            EzyReflection reflection = EzyPackages.scanPackage((String)packageName);
            this.addAllClassesFromReflection(reflection);
            return this;
        }

        @Override
        public EzyBindingContextBuilder scan(String ... packageNames) {
            return this.scan(Sets.newHashSet((Object[])packageNames));
        }

        @Override
        public EzyBindingContextBuilder scan(Iterable<String> packageNames) {
            HashSet<String> set = new HashSet<String>();
            for (String packet : packageNames) {
                set.add(packet);
            }
            return this.scan((Collection<String>)set);
        }

        @Override
        public EzyBindingContextBuilder scan(Collection<String> packageNames) {
            if (packageNames.size() > 0) {
                EzyReflection reflection = EzyPackages.scanPackages(packageNames);
                this.addAllClassesFromReflection(reflection);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addClass(Class clazz) {
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return this;
            }
            if (clazz.isAnnotationPresent(EzyArrayBinding.class)) {
                this.arrayBindingClasses.add(clazz);
            } else {
                this.objectBindingClasses.add(clazz);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addObjectBindingClass(Class clazz) {
            this.objectBindingClasses.add(clazz);
            return this;
        }

        @Override
        public EzyBindingContextBuilder addArrayBindingClass(Class clazz) {
            this.arrayBindingClasses.add(clazz);
            return this;
        }

        @Override
        public EzyBindingContextBuilder addClasses(Class ... classes) {
            return this.addClasses(Sets.newHashSet((Object[])classes));
        }

        @Override
        public EzyBindingContextBuilder addClasses(Iterable<Class> classes) {
            for (Class clazz : classes) {
                this.addClass(clazz);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addAllClasses(Object reflection) {
            if (reflection instanceof EzyReflection) {
                this.addAllClassesFromReflection((EzyReflection)reflection);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addTemplate(Object template) {
            if (template instanceof EzyWriter) {
                this.writers.add((EzyWriter)template);
            }
            if (template instanceof EzyReader) {
                this.readers.add((EzyReader)template);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addTemplate(Class type, Object template) {
            if (template instanceof EzyWriter) {
                this.writers.add((EzyWriter)template);
                this.writersByObjectType.put(type, (EzyWriter)template);
            }
            if (template instanceof EzyReader) {
                this.readers.add((EzyReader)template);
                this.readersByObjectType.put(type, (EzyReader)template);
            }
            if (template instanceof EzyUnwrapper) {
                this.unwrappersByObjectType.put(type, (EzyUnwrapper)template);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addTemplateClass(Class clazz) {
            if (EzyWriter.class.isAssignableFrom(clazz)) {
                this.writerImplClasses.add(clazz);
            }
            if (EzyReader.class.isAssignableFrom(clazz)) {
                this.readerImplClasses.add(clazz);
            }
            return this;
        }

        @Override
        public EzyBindingContextBuilder addTemplateClasses(Iterable<Class<?>> classes) {
            for (Class<?> clazz : classes) {
                this.addTemplateClass(clazz);
            }
            return this;
        }

        @Override
        public EzySimpleBindingContext build() {
            EzySimpleBindingContext context = new EzySimpleBindingContext();
            this.scanPackagesScanClasses();
            this.parseObjectBindingClasses();
            this.parseArrayBindingClasses();
            this.parseTemplateClasses();
            this.mapSubTypesToReaders();
            this.mapSubTypesToWriters();
            context.writers.add(EzyMapArrayWriter.getInstance());
            context.writers.add(EzyMapObjectWriter.getInstance());
            context.writers.addAll(this.writers);
            context.readers.addAll(this.readers);
            context.writersByObjectType.putAll(this.writersByObjectType);
            context.readersByObjectType.putAll(this.readersByObjectType);
            context.unwrappersByObjectType.putAll(this.unwrappersByObjectType);
            this.loadConfigurationClasses(context);
            return context;
        }

        private void parseObjectBindingClasses() {
            for (Class clazz : this.objectBindingClasses) {
                this.parseObjectBindingClass(clazz);
            }
        }

        private void parseArrayBindingClasses() {
            for (Class clazz : this.arrayBindingClasses) {
                this.parseArrayBindingClass(clazz);
            }
        }

        private void parseObjectBindingClass(Class<?> clazz) {
            EzyObjectBinding anno = clazz.getAnnotation(EzyObjectBinding.class);
            if (anno == null || anno.write()) {
                this.addTemplate(clazz, new EzyObjectWriterBuilder(new EzyClass(clazz)).build());
            }
            if (anno == null || anno.read()) {
                this.addTemplate(clazz, new EzyObjectReaderBuilder(new EzyClass(clazz)).build());
                this.addTemplate(clazz, new EzyObjectUnwrapperBuilder(new EzyClass(clazz)).build());
            }
        }

        private void parseArrayBindingClass(Class<?> clazz) {
            EzyArrayBinding anno = clazz.getAnnotation(EzyArrayBinding.class);
            if (anno == null || anno.write()) {
                this.addTemplate(clazz, new EzyArrayWriterBuilder(new EzyClass(clazz)).build());
            }
            if (anno == null || anno.read()) {
                this.addTemplate(clazz, new EzyArrayReaderBuilder(new EzyClass(clazz)).build());
                this.addTemplate(clazz, new EzyArrayUnwrapperBuilder(new EzyClass(clazz)).build());
            }
        }

        private void parseTemplateClasses() {
            for (Class clazz : this.writerImplClasses) {
                this.parseTemplateClass(clazz);
            }
            for (Class clazz : this.readerImplClasses) {
                this.parseTemplateClass(clazz);
            }
        }

        private void parseTemplateClass(Class templateClass) {
            this.addTemplate(EzyClasses.newInstance((Class)templateClass));
        }

        private void scanPackagesScanClasses() {
            for (Class clazz : this.packagesScanClasses) {
                this.scanPackagesScanClass(clazz);
            }
        }

        private void scanPackagesScanClass(Class<?> clazz) {
            EzyBindingPackagesToScan bindingPackagesToScanAnno;
            EzyPackagesToScan packagesToScanAnno = clazz.getAnnotation(EzyPackagesToScan.class);
            if (packagesToScanAnno != null) {
                this.scan(packagesToScanAnno.value());
            }
            if ((bindingPackagesToScanAnno = clazz.getAnnotation(EzyBindingPackagesToScan.class)) != null) {
                this.scan(bindingPackagesToScanAnno.value());
            }
        }

        private void loadConfigurationClasses(EzyBindingContext context) {
            for (Class clazz : this.configurationClasses) {
                this.loadConfigurationClass(clazz, context);
            }
        }

        private void loadConfigurationClass(Class<?> clazz, EzyBindingContext context) {
            new EzySimpleConfigurationLoader(new EzyClass(clazz)).load(context);
        }

        private void mapSubTypesToWriters() {
            HashSet<Class> classes = new HashSet<Class>(this.writersByObjectType.keySet());
            for (Class clazz : classes) {
                this.mapSubTypesToWriter(clazz, this.writersByObjectType.get(clazz));
            }
        }

        private void mapSubTypesToWriter(Class clazz, EzyWriter writer) {
            Set<Class> subTypes = this.getSubTypes(clazz);
            for (Class subType : subTypes) {
                this.writersByObjectType.put(subType, writer);
            }
        }

        private void mapSubTypesToReaders() {
            HashSet<Class> classes = new HashSet<Class>(this.readersByObjectType.keySet());
            for (Class clazz : classes) {
                this.mapSubTypesToReader(clazz, this.readersByObjectType.get(clazz));
            }
        }

        private void mapSubTypesToReader(Class clazz, EzyReader writer) {
            Set<Class> subTypes = this.getSubTypes(clazz);
            for (Class subType : subTypes) {
                this.readersByObjectType.put(subType, writer);
            }
        }

        private Set<Class> getSubTypes(Class<?> clazz) {
            boolean includeSubTypes = false;
            HashSet<Class> answer = new HashSet<Class>();
            if (clazz.isAnnotationPresent(EzyObjectBinding.class)) {
                EzyObjectBinding anno = clazz.getAnnotation(EzyObjectBinding.class);
                includeSubTypes = anno.subTypes();
                answer.addAll(Sets.newHashSet((Object[])anno.subTypeClasses()));
            } else if (clazz.isAnnotationPresent(EzyArrayBinding.class)) {
                EzyArrayBinding anno = clazz.getAnnotation(EzyArrayBinding.class);
                includeSubTypes = anno.subTypes();
                answer.addAll(Sets.newHashSet((Object[])anno.subTypeClasses()));
            }
            if (!includeSubTypes) {
                return new HashSet<Class>();
            }
            if (!answer.isEmpty()) {
                return answer;
            }
            return EzyClasses.flatSuperAndInterfaceClasses(clazz);
        }

        private void addAllClassesFromReflection(EzyReflection reflection) {
            this.objectBindingClasses.addAll(reflection.getAnnotatedClasses(EzyObjectBinding.class));
            this.arrayBindingClasses.addAll(reflection.getAnnotatedClasses(EzyArrayBinding.class));
            this.writerImplClasses.addAll(reflection.getAnnotatedClasses(EzyWriterImpl.class));
            this.readerImplClasses.addAll(reflection.getAnnotatedClasses(EzyReaderImpl.class));
            this.addTemplateClasses(reflection.getAnnotatedClasses(EzyTemplateImpl.class));
            this.packagesScanClasses.addAll(reflection.getAnnotatedClasses(EzyPackagesToScan.class));
            this.packagesScanClasses.addAll(reflection.getAnnotatedClasses(EzyBindingPackagesToScan.class));
            this.configurationClasses.addAll(reflection.getAnnotatedClasses(EzyConfiguration.class));
        }
    }
}

