/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.security.EzyBase64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.pagination.PaginationParameterConverter;

public abstract class ComplexPaginationParameterConverter<S, M> {
    private final PaginationParameterConverter converter;
    private final Map<S, String> defaultPageTokenBySortOrder;
    private final Map<Object, Class<?>> paginationParameterTypeBySortOrder;
    private final Map<S, Function<M, Object>> paginationParameterExtractorBySortOrder;

    public ComplexPaginationParameterConverter(PaginationParameterConverter converter) {
        this.converter = converter;
        this.defaultPageTokenBySortOrder = new HashMap<S, String>();
        this.paginationParameterTypeBySortOrder = new HashMap();
        this.mapPaginationParametersToTypes(this.paginationParameterTypeBySortOrder);
        new HashMap(this.paginationParameterTypeBySortOrder).forEach(this::registerPaginationParameter);
        this.paginationParameterExtractorBySortOrder = new HashMap<S, Function<M, Object>>();
        this.addPaginationParameterExtractors(this.paginationParameterExtractorBySortOrder);
    }

    private void registerPaginationParameter(S sortOrder, Class<?> paginationParameterType) {
        this.paginationParameterTypeBySortOrder.put(sortOrder, paginationParameterType);
        this.paginationParameterTypeBySortOrder.put(sortOrder.toString(), paginationParameterType);
        this.defaultPageTokenBySortOrder.put(sortOrder, EzyBase64.encodeUtf((String)this.converter.serialize(new PaginationParameterWrapper<S>(sortOrder, this.converter.serializeToMap(EzyClasses.newInstance(paginationParameterType))))));
    }

    public void registerPaginationParameter(S sortOrder, Class<?> paginationParameterType, Function<M, Object> paginationParameterExtractor) {
        this.registerPaginationParameter(sortOrder, paginationParameterType);
        this.paginationParameterExtractorBySortOrder.put(sortOrder, paginationParameterExtractor);
    }

    public String serialize(S sortOrder, M model) {
        Function<Object, Object> extractor = this.paginationParameterExtractorBySortOrder.get(sortOrder);
        if (extractor == null) {
            extractor = Function.identity();
        }
        return this.converter.serialize(new PaginationParameterWrapper<S>(sortOrder, this.converter.serializeToMap(extractor.apply(model))));
    }

    public <T> T deserialize(String pageToken) {
        PaginationParameterWrapper wrapper = this.converter.deserialize(pageToken, PaginationParameterWrapper.class);
        Class<?> paginationParameterType = this.paginationParameterTypeBySortOrder.get(wrapper.sortOrder);
        if (paginationParameterType == null) {
            throw new IllegalArgumentException("there is no pagination parameter type map to sort order: " + wrapper.sortOrder);
        }
        return (T)this.converter.deserializeFromMap(wrapper.value, paginationParameterType);
    }

    public String getDefaultPageToken(S sortOrder) {
        return this.defaultPageTokenBySortOrder.get(sortOrder);
    }

    protected abstract void mapPaginationParametersToTypes(Map<S, Class<?>> var1);

    protected void addPaginationParameterExtractors(Map<S, Function<M, Object>> map) {
    }

    public static class PaginationParameterWrapper<S> {
        private S sortOrder;
        private Map<String, Object> value;

        @Generated
        public S getSortOrder() {
            return this.sortOrder;
        }

        @Generated
        public Map<String, Object> getValue() {
            return this.value;
        }

        @Generated
        public void setSortOrder(S sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Generated
        public void setValue(Map<String, Object> value) {
            this.value = value;
        }

        @Generated
        public PaginationParameterWrapper(S sortOrder, Map<String, Object> value) {
            this.sortOrder = sortOrder;
            this.value = value;
        }

        @Generated
        public PaginationParameterWrapper() {
        }
    }
}

