/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collection;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.UserKeyword;
import org.youngmonkeys.ezyplatform.model.AddUserKeywordModel;
import org.youngmonkeys.ezyplatform.repo.UserKeywordRepository;
import org.youngmonkeys.ezyplatform.service.UserKeywordService;

public class DefaultUserKeywordService
extends EzyLoggable
implements UserKeywordService {
    private final UserKeywordRepository userKeywordRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void addUserKeyword(AddUserKeywordModel model) {
        String keyword;
        long userId = model.getUserId();
        UserKeyword entity = this.userKeywordRepository.findByUserIdAndKeyword(userId, keyword = model.getKeyword());
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(model);
        } else {
            this.modelToEntityConverter.mergeToEntity(model, entity);
        }
        try {
            this.userKeywordRepository.save(entity);
        }
        catch (Exception e) {
            this.logger.info("save keyword: {} of useId: {} failed", (Object)keyword, (Object)userId);
        }
    }

    @Override
    public void addUserKeywords(Collection<AddUserKeywordModel> userKeywords) {
        for (AddUserKeywordModel model : userKeywords) {
            this.addUserKeyword(model);
        }
    }

    @Override
    public void deleteUserKeywordsByUserId(long userId) {
        this.userKeywordRepository.deleteByUserId(userId);
    }

    @Override
    public void deleteUserKeywordsByUserIds(Collection<Long> userIds) {
        if (!userIds.isEmpty()) {
            this.userKeywordRepository.deleteByUserIdIn(userIds);
        }
    }

    @Override
    public boolean containsUserKeyword(long userId, String keyword) {
        return this.userKeywordRepository.findByUserIdAndKeyword(userId, keyword) != null;
    }

    @Generated
    public DefaultUserKeywordService(UserKeywordRepository userKeywordRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.userKeywordRepository = userKeywordRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

