/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.model.AdminRoleNameModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminLetterService;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminAdminsValidator;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewName;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.constant.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.AdminStatus;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.LetterModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.rx.Reactive;

@Authenticated
@Controller
@EzyFeature(value="admin_management")
public class AdminAdminsController {
    private final AdminViewFactory viewFactory;
    private final AdminAdminService adminService;
    private final AdminUserService userService;
    private final AdminMediaService mediaService;
    private final AdminAdminRoleService adminRoleService;
    private final AdminLetterService letterService;
    private final AdminAdminsValidator adminsValidator;

    @DoGet(value="/admin-list")
    public Redirect adminListGet() {
        return Redirect.to((String)"/admins");
    }

    @DoGet(value="/admins")
    public View adminsGet(@org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles, @RequestParam(value="keyword") String keyword, @RequestParam(value="userStatus") AdminStatus adminStatus) {
        return this.viewFactory.newAdminsViewBuilder(AdminViewName.LIST).addVariable("enableAddNewButton", (Object)adminRoles.isAccessible("/admins/add")).addVariable("adminStatuses", (Object)AdminStatus.values()).addVariable("adminSearchKeyword", (Object)keyword).addVariable("adminSearchStatus", (Object)adminStatus).appendValuesToVariable("additionalMessageKeys", (Collection)EzyLists.newArrayList((Object[])AdminStatus.values(), it -> it.toString().toLowerCase())).build();
    }

    @DoGet(value="/admins/add")
    public View adminsAddGet(@AdminId long adminId) {
        return this.viewFactory.newAdminsViewBuilder(AdminViewName.ADD).addVariable("roles", this.adminRoleService.getVisibleAdminRoleNamesByAdminId(adminId)).addVariable("minRolePriority", (Object)this.adminRoleService.getMinAdminRolePriority(adminId)).build();
    }

    @DoGet(value="/admins/me")
    public View adminsMeGet(@AdminId long adminId, @org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles) {
        AdminModel admin = this.adminService.getAdminById(adminId);
        return this.newAdminProfileViewBuilder(admin).addVariable("enableEditButton", (Object)adminRoles.isAccessible("/admins/me/edit")).build();
    }

    @DoGet(value="/admins/{username}")
    public View adminsUsernameGet(@PathVariable String username, @org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles) {
        AdminModel admin = this.adminsValidator.validateAdminUsername(username);
        return this.newAdminProfileViewBuilder(admin).addVariable("enableEditButton", (Object)adminRoles.isAccessible("/admins/{username}/edit")).build();
    }

    public View.Builder newAdminProfileViewBuilder(AdminModel admin) {
        return (View.Builder)Reactive.multiple().register((Object)"adminAvatarImage", () -> this.mediaService.getMediaNameById(admin.getAvatarImageId())).register((Object)"adminCoverImage", () -> this.mediaService.getMediaNameById(admin.getCoverImageId())).register((Object)"adminRoleNames", () -> this.adminRoleService.getAdminRoleNamesByAdminId(admin.getId())).register((Object)"allowAccessAllMedia", () -> this.adminService.isAllowAccessAllMedia(admin.getId())).blockingGet(it -> this.viewFactory.newAdminsViewBuilder(AdminViewName.PROFILE).addVariable("selectedAdmin", (Object)admin).addVariable("httpMethods", Arrays.asList("DELETE", "POST", "PUT", "GET")).addVariables(it.valueMap()));
    }

    @DoGet(value="/admins/me/edit")
    public View adminsMeEditGet(@AdminId long adminId) {
        return this.adminsEditGet(adminId, this.adminService.getAdminById(adminId));
    }

    @DoGet(value="/admins/{username}/edit")
    public View adminsEditGet(@AdminId long adminId, @PathVariable String username) {
        AdminModel admin = this.adminsValidator.validateAdminUsername(username);
        return this.adminsEditGet(adminId, admin);
    }

    private View adminsEditGet(long byAdminId, AdminModel admin) {
        long adminId = admin.getId();
        return (View)Reactive.multiple().register((Object)"adminAvatarImage", () -> this.mediaService.getMediaNameById(admin.getAvatarImageId())).register((Object)"adminCoverImage", () -> this.mediaService.getMediaNameById(admin.getCoverImageId())).register((Object)"roles", () -> this.adminRoleService.getVisibleAdminRoleNamesByAdminId(byAdminId)).register((Object)"editAdminRoles", () -> this.adminRoleService.getAdminRoleNamesByAdminId(adminId)).register((Object)"minRolePriority", () -> this.adminRoleService.getMinAdminRolePriority(adminId)).blockingGet(it -> this.viewFactory.newAdminsViewBuilder(AdminViewName.EDIT).addVariables(it.valueMap()).addVariable("editAdmin", (Object)admin).build());
    }

    @DoGet(value="/admins/inbox")
    public View adminsInboxGet() {
        return this.viewFactory.newAdminsViewBuilder(AdminViewName.INBOX).build();
    }

    @DoGet(value="/admins/inbox/{letterId}")
    public View accountIndexMessageGet(@AdminId long adminId, @PathVariable long letterId) {
        this.letterService.updateAdminLetterByRead(adminId, letterId);
        LetterModel letter = this.letterService.getAdminLetter(adminId, letterId);
        AdminModel fromAdmin = null;
        long fromAdminId = letter.getFromAdminId();
        if (fromAdminId > 0L) {
            fromAdmin = this.adminService.getAdminById(fromAdminId);
        }
        UserModel fromUser = null;
        long fromUserId = letter.getFromUserId();
        if (fromUserId > 0L) {
            fromUser = this.userService.getUserById(fromUserId);
        }
        return this.viewFactory.newAdminsViewBuilder(AdminViewName.INBOX).template("admins/inbox-letter").addVariable("letter", (Object)letter).addVariable("fromAdmin", (Object)fromAdmin).addVariable("fromUser", (Object)fromUser).addVariable("currentParentTitle", (Object)"admins.inbox.title").addVariable("currentParentURL", (Object)"/admins/inbox").addVariable("currentPageTitle", (Object)"admins.inbox.letter.title").build();
    }

    @DoGet(value="/admins/roles")
    public View adminsRolesGet(@org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles) {
        return this.viewFactory.newAdminsViewBuilder(AdminViewName.ROLES).addVariable("enableAddNewButton", (Object)adminRoles.isAccessible("/api/v1/admin/role-names/add", "POST")).build();
    }

    @DoGet(value="/admins/roles/{roleName}")
    public View adminRolesRoleNameGet(@AdminId long adminId, @org.youngmonkeys.ezyplatform.annotation.AdminRoles AdminRolesProxy adminRoles, @PathVariable String roleName) {
        AdminRoleNameModel role = this.adminsValidator.validateAdminRolePriority(adminId, roleName);
        return this.viewFactory.newAdminsViewBuilder(AdminViewName.ROLE_DETAILS).addVariable("role", (Object)role).addVariable("enableEditButton", (Object)(!AdminRoles.UNMODIFIABLE_ROLE_NAMES.contains(roleName) && adminRoles.isAccessible("/api/v1/admin/role-names/{roleNameId}", "PUT") ? 1 : 0)).build();
    }

    @Generated
    public AdminAdminsController(AdminViewFactory viewFactory, AdminAdminService adminService, AdminUserService userService, AdminMediaService mediaService, AdminAdminRoleService adminRoleService, AdminLetterService letterService, AdminAdminsValidator adminsValidator) {
        this.viewFactory = viewFactory;
        this.adminService = adminService;
        this.userService = userService;
        this.mediaService = mediaService;
        this.adminRoleService = adminRoleService;
        this.letterService = letterService;
        this.adminsValidator = adminsValidator;
    }
}

