/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import org.youngmonkeys.ezyplatform.constant.ModuleAction;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.manager.MarketUrlManager;
import org.youngmonkeys.ezyplatform.util.Uris;

@EzySingleton
public class AdminMarketUrlManager
extends MarketUrlManager {
    public String getPlatformSsoUrl() {
        return this.resolveUrl("/sso");
    }

    public String getPlatformVersionNameUrl() {
        return this.resolveUrl("api/v1/platforms/latest-version");
    }

    public String getDownloadPlatformUrl(String version) {
        return this.resolveUrl("api/v1/platforms/" + version + "/download");
    }

    public String getDownloadProjectUrl(String platformVersion, String projectName, String version) {
        return this.resolveUrl("/api/v1/released-projects/" + projectName + "/" + version + "/download?platformVersion=" + platformVersion);
    }

    public String getMediaByNameUrl(String mediaName) {
        return this.resolveUrl("/api/v1/media/" + mediaName);
    }

    public String getReleasedProjectsUrl(String moduleType, String projectName, String keyword, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        StringBuilder uri = new StringBuilder();
        if (EzyStrings.isNotEmpty((CharSequence)moduleType)) {
            uri.append("moduleType=").append(moduleType).append("&");
        }
        if (EzyStrings.isNotEmpty((CharSequence)projectName)) {
            uri.append("projectName=").append(projectName).append("&");
        }
        if (EzyStrings.isNotEmpty((CharSequence)keyword)) {
            uri.append("keyword=").append(keyword).append("&");
        }
        if (EzyStrings.isNotEmpty((CharSequence)nextPageToken)) {
            uri.append("nextPageToken=").append(nextPageToken).append("&");
        }
        if (EzyStrings.isNotEmpty((CharSequence)prevPageToken)) {
            uri.append("prevPageToken=").append(prevPageToken).append("&");
        }
        uri.append("lastPage=").append(lastPage).append("&limit=").append(limit);
        return this.resolveUrl("/api/v1/released-projects?" + uri);
    }

    public String getReleasedProjectsByNameUrl(String projectName) {
        return this.resolveUrl("/api/v1/released-projects/" + projectName);
    }

    public String getReleasedProjectsSimpleDataUrl(String projectNames) {
        return this.resolveUrl("/api/v1/released-projects-simple-data?projectNames=" + projectNames);
    }

    public String getReleasedProjectsLatestVersionUrl(String projectNames) {
        return this.resolveUrl("/api/v1/released-projects-latest-version?projectNames=" + projectNames);
    }

    public String getReleasedProjectsProjectNameVersionNameExistingUrl(String projectName, String version) {
        return this.resolveUrl("/api/v1/released-projects/" + projectName + "/" + version + "/existing");
    }

    public String getSendProjectActionStatisticsUrl(String platformVersion, String projectName, String projectVersion, ModuleAction action) {
        return this.resolveUrl("/api/v1/platforms/" + platformVersion + "/projects/" + projectName + "/" + projectVersion + "/" + action.getName());
    }

    public String getSendTargetStopStatisticsUrl(String platformVersion, String targetType) {
        return this.resolveUrl("/api/v1/platforms/" + platformVersion + "/targets/" + targetType + "/stop");
    }

    public String getPlatformReleaseNotesUrl(String version, String languageCode) {
        return this.resolveUrl("/api/v1/platforms/" + version + "/release-notes?i18n_lang=" + languageCode);
    }

    private String resolveUrl(String path) {
        return Uris.resolveUrl((String)this.ezyplatformUrl, (String)path);
    }

    protected TargetType getTargetType() {
        return TargetType.ADMIN;
    }
}

