/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.socket;

import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.socket.EzyRequestQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketRequest;
import java.util.LinkedList;
import java.util.Queue;

public class EzyNonBlockingRequestQueue
extends EzyLoggable
implements EzyRequestQueue {
    private final int capacity;
    private final Queue<EzySocketRequest> queue;

    public EzyNonBlockingRequestQueue() {
        this(128);
    }

    public EzyNonBlockingRequestQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new LinkedList<EzySocketRequest>();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public EzySocketRequest take() {
        return this.queue.poll();
    }

    @Override
    public boolean isFull() {
        return this.queue.size() >= this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean add(EzySocketRequest packet) {
        if (this.isFull()) {
            return false;
        }
        return this.queue.offer(packet);
    }
}

