/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.entity;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.gamebox.entity.MMORoom;
import com.tvd12.gamebox.manager.RoomManager;
import com.tvd12.gamebox.manager.SynchronizedRoomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class MMORoomGroup
extends EzyLoggable {
    private volatile boolean active;
    private final long timeTickMillis;
    private final RoomManager<MMORoom> roomManager;
    private static final AtomicInteger COUNTER = new AtomicInteger();

    protected MMORoomGroup(Builder builder) {
        this.timeTickMillis = builder.timeTickMillis;
        this.roomManager = new SynchronizedRoomManager<MMORoom>();
        this.start();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void start() {
        Thread newThread = new Thread(this::loop);
        newThread.setName("game-box-mmo-room-group-" + COUNTER.incrementAndGet());
        newThread.start();
    }

    private void loop() {
        this.active = true;
        ArrayList<MMORoom> roomBuffer = new ArrayList<MMORoom>();
        while (this.active) {
            try {
                long start = System.currentTimeMillis();
                this.updateRooms(roomBuffer);
                long end = System.currentTimeMillis();
                long timeElapsed = end - start;
                if (timeElapsed >= this.timeTickMillis) continue;
                Thread.sleep(this.timeTickMillis - timeElapsed);
            }
            catch (Exception e) {
                this.logger.error("Room group loop error: ", (Throwable)e);
            }
        }
    }

    private void updateRooms(List<MMORoom> roomBuffer) {
        roomBuffer.clear();
        this.roomManager.getRoomList(roomBuffer);
        roomBuffer.forEach(room -> {
            try {
                room.update();
            }
            catch (Exception e) {
                this.logger.warn("Update room: {} error", room, (Object)e);
            }
        });
    }

    public void addRoom(MMORoom room) {
        this.roomManager.addRoom(room);
    }

    public void removeRoom(MMORoom room) {
        this.roomManager.removeRoom(room);
    }

    public MMORoom getRoom(long roomId) {
        return this.roomManager.getRoom(roomId);
    }

    public MMORoom getRoom(String roomName) {
        return this.roomManager.getRoom(roomName);
    }

    public int getRoomCount() {
        return this.roomManager.getRoomCount();
    }

    public void destroy() {
        this.active = false;
    }

    public static class Builder
    implements EzyBuilder<MMORoomGroup> {
        private long timeTickMillis;

        public Builder timeTickMillis(int timeTickMillis) {
            this.timeTickMillis = timeTickMillis;
            return this;
        }

        public MMORoomGroup build() {
            return new MMORoomGroup(this);
        }
    }
}

