/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.octree;

import com.tvd12.gamebox.entity.PositionAware;
import com.tvd12.gamebox.math.Bounds;
import com.tvd12.gamebox.math.Vec3;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class OcTreeNode<T extends PositionAware> {
    private OcTreeNode<T> parentNode = null;
    private final int maxItems;
    private final float minNodeSize;
    private final Bounds bounds;
    private final Set<T> items = new HashSet<T>();
    private final List<OcTreeNode<T>> children = new ArrayList<OcTreeNode<T>>();
    private static final int NUM_CHILDREN = 8;

    public OcTreeNode(Bounds bounds, int maxItems, float minNodeSize) {
        if (minNodeSize <= 0.0f) {
            throw new IllegalArgumentException("minNodeSize must > 0 to avoid StackOverflow");
        }
        this.bounds = bounds;
        this.maxItems = maxItems;
        this.minNodeSize = minNodeSize;
    }

    public OcTreeNode<T> insert(T newItem) {
        if (!this.bounds.containsPosition(newItem.getPosition())) {
            return null;
        }
        if (this.isLeaf()) {
            if (this.items.size() < this.maxItems || this.bounds.getMaxDimension() < 2.0f * this.minNodeSize) {
                this.items.add(newItem);
                return this;
            }
            this.createChildren();
            this.passItemsToChildren();
        }
        return this.insertItemToChildren(newItem);
    }

    private void createChildren() {
        for (int i = 0; i < 8; ++i) {
            Bounds bounds = this.bounds.getOctant(i);
            OcTreeNode<T> child = new OcTreeNode<T>(bounds, this.maxItems, this.minNodeSize);
            this.children.add(child);
            child.setParentNode(this);
        }
    }

    private void passItemsToChildren() {
        this.items.forEach(this::insertItemToChildren);
        this.items.clear();
    }

    private OcTreeNode<T> insertItemToChildren(T item) {
        for (OcTreeNode<T> child : this.children) {
            OcTreeNode<T> nodeContainingInsertedItem = child.insert(item);
            if (nodeContainingInsertedItem == null) continue;
            return nodeContainingInsertedItem;
        }
        return null;
    }

    public boolean remove(T item) {
        if (!this.bounds.containsPosition(item.getPosition())) {
            return false;
        }
        if (this.isLeaf()) {
            return this.removeItemFromThisLeaf(item);
        }
        return this.removeFromChildren(item);
    }

    private boolean removeItemFromThisLeaf(T item) {
        if (!this.items.contains(item)) {
            return false;
        }
        this.items.remove(item);
        this.tryMergingChildrenOfParentNode();
        return true;
    }

    private boolean removeFromChildren(T item) {
        for (OcTreeNode<T> child : this.children) {
            boolean isPlayerRemoved = child.remove(item);
            if (!isPlayerRemoved) continue;
            return true;
        }
        return false;
    }

    private void tryMergingChildrenOfParentNode() {
        if (this.parentNode != null && this.parentNode.countItems() <= this.maxItems) {
            super.mergeChildren();
        }
    }

    private void mergeChildren() {
        ArrayList itemsInChildren = new ArrayList();
        this.getItemsInChildren(itemsInChildren);
        this.items.addAll(itemsInChildren);
        this.children.clear();
        this.tryMergingChildrenOfParentNode();
    }

    private void getItemsInChildren(List<T> players) {
        if (this.isLeaf()) {
            players.addAll(this.items);
            this.items.clear();
            return;
        }
        for (OcTreeNode<T> child : this.children) {
            super.getItemsInChildren(players);
        }
    }

    public int countItems() {
        if (this.isLeaf()) {
            return this.items.size();
        }
        return this.countItemsFromChildren();
    }

    private int countItemsFromChildren() {
        int count = 0;
        for (OcTreeNode<T> child : this.children) {
            count += child.countItems();
        }
        return count;
    }

    public List<T> search(Bounds searchBounds, List<T> matches) {
        if (!this.bounds.doesOverlap(searchBounds)) {
            return matches;
        }
        if (this.isLeaf()) {
            return this.searchFromThisLeaf(searchBounds, matches);
        }
        return this.searchFromChildren(searchBounds, matches);
    }

    private List<T> searchFromThisLeaf(Bounds searchBounds, List<T> matches) {
        for (PositionAware item : this.items) {
            if (!searchBounds.containsPosition(item.getPosition())) continue;
            matches.add(item);
        }
        return matches;
    }

    private List<T> searchFromChildren(Bounds searchBounds, List<T> matches) {
        for (OcTreeNode<T> child : this.children) {
            child.search(searchBounds, matches);
        }
        return matches;
    }

    protected OcTreeNode<T> findNodeContainingPosition(Vec3 position) {
        if (!this.bounds.containsPosition(position)) {
            return null;
        }
        if (this.isLeaf()) {
            return this;
        }
        return this.findNodeContainingPositionFromChildren(position);
    }

    private OcTreeNode<T> findNodeContainingPositionFromChildren(Vec3 position) {
        for (OcTreeNode<T> child : this.children) {
            OcTreeNode<T> node = child.findNodeContainingPosition(position);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public String toString() {
        return "(bounds=" + this.bounds + ", items=" + this.items + ", children=" + this.children + ')';
    }

    public String toPrettyString(int level) {
        String spaces = level <= 0 ? "" : String.format("%" + level * 2 + 's', "");
        return spaces + "(\n" + spaces + "  bounds=" + this.bounds + ",\n" + spaces + "  items=" + this.items + ",\n" + spaces + (this.children.isEmpty() ? "  children=[]\n" : "  children=[\n" + this.children.stream().map(it -> it.toPrettyString(level + 1)).collect(Collectors.joining(",\n")) + '\n' + spaces + "  ]\n") + spaces + ')';
    }

    @Generated
    public void setParentNode(OcTreeNode<T> parentNode) {
        this.parentNode = parentNode;
    }
}

