/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket.data;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.constant.SocketUserType;

public class SocketUserData {
    private final long userId;
    private final long adminId;
    private final String userUuid;
    private final String adminUuid;
    private final String userAccessToken;
    private final String adminAccessToken;
    private final String socketUserType;

    protected SocketUserData(Builder builder) {
        this.userId = builder.userId;
        this.adminId = builder.adminId;
        this.userUuid = builder.userUuid;
        this.adminUuid = builder.adminUuid;
        this.userAccessToken = builder.userAccessToken;
        this.adminAccessToken = builder.adminAccessToken;
        this.socketUserType = builder.socketUserType;
    }

    public boolean isAdmin() {
        return SocketUserType.ADMIN.equalsValue(this.socketUserType);
    }

    public boolean isAnonymous() {
        return SocketUserType.ANONYMOUS.equalsValue(this.socketUserType);
    }

    public boolean isUser() {
        return SocketUserType.USER.equalsValue(this.socketUserType);
    }

    public long getSocketUserId() {
        return this.adminId > 0L ? this.adminId : this.userId;
    }

    public String getSocketUserUuid() {
        return EzyStrings.isNotBlank((String)this.adminUuid) ? this.adminUuid : this.userUuid;
    }

    public String getSocketUserUuidIncludeType() {
        return this.socketUserType + "#" + this.getSocketUserUuid();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public long getUserId() {
        return this.userId;
    }

    @Generated
    public long getAdminId() {
        return this.adminId;
    }

    @Generated
    public String getUserUuid() {
        return this.userUuid;
    }

    @Generated
    public String getAdminUuid() {
        return this.adminUuid;
    }

    @Generated
    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    @Generated
    public String getAdminAccessToken() {
        return this.adminAccessToken;
    }

    @Generated
    public String getSocketUserType() {
        return this.socketUserType;
    }

    public static class Builder
    implements EzyBuilder<SocketUserData> {
        protected long userId;
        protected long adminId;
        protected String userUuid;
        protected String adminUuid;
        protected String userAccessToken;
        protected String adminAccessToken;
        protected String socketUserType;

        public Builder userId(long userId) {
            this.userId = userId;
            return this;
        }

        public Builder adminId(long adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder userUuid(String userUuid) {
            this.userUuid = userUuid;
            return this;
        }

        public Builder adminUuid(String adminUuid) {
            this.adminUuid = adminUuid;
            return this;
        }

        public Builder userAccessToken(String userAccessToken) {
            this.userAccessToken = userAccessToken;
            return this;
        }

        public Builder adminAccessToken(String adminAccessToken) {
            this.adminAccessToken = adminAccessToken;
            return this;
        }

        public Builder socketUserType(String socketUserType) {
            this.socketUserType = socketUserType;
            return this;
        }

        public SocketUserData build() {
            return new SocketUserData(this);
        }
    }
}

