/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.annotation.EzyProperty;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.bean.annotation.EzyPostInit;
import com.tvd12.ezyfox.bean.exception.EzyMissingSetterException;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyPropertyAnnotations;
import com.tvd12.properties.file.annotation.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public abstract class EzySimpleObjectBuilder
extends EzyLoggable {
    protected final EzyClass clazz;
    protected final String beanName;
    protected final AtomicInteger variableCount;
    protected final List<EzyField> bindingFields;
    protected final List<EzySetterMethod> bindingMethods;
    protected final List<EzyField> propertyFields;
    protected final List<EzySetterMethod> propertyMethods;

    public EzySimpleObjectBuilder(String beanName, EzyClass clazz) {
        this.clazz = clazz;
        this.beanName = beanName;
        this.variableCount = new AtomicInteger(0);
        this.bindingFields = this.getBindingFields(clazz);
        this.bindingMethods = this.getBindingMethods(clazz);
        this.propertyFields = this.getPropertyFields(clazz);
        this.propertyMethods = this.getPropertyMethods(clazz);
        this.checkMissingSetterMethodFields(this.bindingFields, Collections.singletonList(EzyAutoBind.class));
        this.checkMissingSetterMethodFields(this.propertyFields, Arrays.asList(Property.class, EzyProperty.class));
    }

    protected Constructor getConstructor(EzyClass clazz) {
        List constructors = clazz.getDeclaredConstructors();
        for (Constructor con : constructors) {
            if (!con.isAnnotationPresent(EzyAutoBind.class)) continue;
            return con;
        }
        Constructor con = clazz.getNoArgsDeclaredConstructor();
        if (con == null) {
            con = clazz.getMaxArgsDeclaredConstructor();
        }
        return con;
    }

    protected abstract Class<?>[] getConstructorParameterTypes();

    protected final String[] getArgumentNames(Class<?>[] parameterTypes) {
        String[] names = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            names[i] = EzyClasses.getVariableName(parameterTypes[i]);
        }
        return names;
    }

    protected String[] getConstructorArgumentNames() {
        return this.getArgumentNames(this.getConstructorParameterTypes());
    }

    protected final String[] getConstructorArgumentNames(EzyAutoBind annotation) {
        Class<?>[] parameterTypes = this.getConstructorParameterTypes();
        String[] names = this.getArgumentNames(parameterTypes);
        if (annotation == null) {
            return names;
        }
        String[] fixNames = annotation.value();
        for (int i = 0; i < fixNames.length; ++i) {
            if (i >= names.length) continue;
            names[i] = fixNames[i];
        }
        return names;
    }

    protected final String[] getConstructorArgumentNames(Constructor<?> constructor) {
        return this.getConstructorArgumentNames(constructor.getAnnotation(EzyAutoBind.class));
    }

    protected final List<EzyField> getBindingFields(EzyClass clazz) {
        return this.getValidFields(clazz, Collections.singletonList(EzyAutoBind.class));
    }

    protected final List<EzySetterMethod> getBindingMethods(EzyClass clazz) {
        return this.getValidMethods(clazz, this::isBindingMethod);
    }

    protected final List<EzyField> getPropertyFields(EzyClass clazz) {
        return this.getValidFields(clazz, Arrays.asList(Property.class, EzyProperty.class));
    }

    protected final List<EzySetterMethod> getPropertyMethods(EzyClass clazz) {
        return this.getValidMethods(clazz, this::isPropertyMethod);
    }

    protected final List<EzyMethod> getPostInitMethods() {
        return this.clazz.getPublicMethods(m -> m.isAnnotated(EzyPostInit.class) && m.getParameterCount() == 0);
    }

    private boolean isBindingMethod(EzyMethod method) {
        return this.isValidMethod(method, Collections.singletonList(EzyAutoBind.class));
    }

    private boolean isPropertyMethod(EzyMethod method) {
        return this.isValidMethod(method, Arrays.asList(Property.class, EzyProperty.class));
    }

    private List<EzyField> getValidFields(EzyClass clazz, List<Class<? extends Annotation>> annotations) {
        return clazz.getFields(f -> f.isPublic() && this.isAnnotated((EzyField)f, annotations));
    }

    private List<EzySetterMethod> getValidMethods(EzyClass clazz, Predicate<EzyMethod> predicate) {
        List methods = clazz.getMethods();
        List valid0 = EzyLists.filter((Collection)methods, predicate);
        List valid = EzyMethods.filterOverriddenMethods((Collection)valid0);
        return EzyLists.newArrayList((Collection)valid, EzySetterMethod::new);
    }

    private boolean isValidMethod(EzyMethod method, List<Class<? extends Annotation>> annotations) {
        if (method.getParameterCount() != 1) {
            return false;
        }
        EzyField field = this.clazz.getField(method.getFieldName());
        boolean answer = field != null && !field.isPublic() && this.isAnnotated(field, annotations);
        return answer || this.isAnnotated(method, annotations);
    }

    private boolean isAnnotated(EzyField field, List<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> ann : annotations) {
            if (!field.isAnnotated(ann)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotated(EzyMethod method, List<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> ann : annotations) {
            if (!method.isAnnotated(ann)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isAbstractClass(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    protected final String getBeanName(EzyReflectElement element) {
        if (element instanceof EzyField) {
            return this.getBeanName((EzyField)element);
        }
        return this.getBeanName((EzyMethod)element);
    }

    private String getBeanName(EzyField field) {
        EzyAutoBind annotation = (EzyAutoBind)field.getAnnotation(EzyAutoBind.class);
        if (annotation == null) {
            return field.getName();
        }
        if (annotation.value().length > 0 && annotation.value()[0].length() > 0) {
            return annotation.value()[0];
        }
        return field.getName();
    }

    private String getBeanName(EzyMethod method) {
        EzyAutoBind annotation = (EzyAutoBind)method.getAnnotation(EzyAutoBind.class);
        if (annotation != null && annotation.value().length > 0) {
            return annotation.value()[0];
        }
        String fieldName = method.getFieldName();
        EzyField field = this.clazz.getField(fieldName);
        return field != null ? this.getBeanName(field) : fieldName;
    }

    protected final String getPropertyName(EzyReflectElement element) {
        return EzyPropertyAnnotations.getPropertyName((EzyClass)this.clazz, (EzyReflectElement)element);
    }

    private void checkMissingSetterMethodFields(List<EzyField> fields, List<Class<? extends Annotation>> annotationClasses) {
        List missingSetterFields = this.clazz.getFields(f -> {
            if (!this.isAnnotated((EzyField)f, annotationClasses)) {
                return false;
            }
            if (f.isPublic()) {
                return false;
            }
            EzyMethod setter = this.clazz.getSetterMethod(f.getSetterMethod());
            return setter == null;
        });
        boolean addMissingSetterFields = this.addMissingSetterFields();
        for (EzyField field : missingSetterFields) {
            if (addMissingSetterFields) {
                fields.add(field);
                continue;
            }
            this.logger.warn("field: {} maybe null", (Object)field.getName(), (Object)new EzyMissingSetterException(field));
        }
    }

    protected boolean addMissingSetterFields() {
        return true;
    }
}

