/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.bean.EzyPropertyFetcher;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.exception.EzyNewSingletonException;
import com.tvd12.ezyfox.bean.impl.EzyByConstructorSingletonLoader;
import com.tvd12.ezyfox.bean.impl.EzyByMethodSingletonLoader;
import com.tvd12.ezyfox.bean.impl.EzyKeyValueParser;
import com.tvd12.ezyfox.bean.impl.EzySimpleObjectBuilder;
import com.tvd12.ezyfox.bean.impl.EzySimpleSingletonFactory;
import com.tvd12.ezyfox.bean.impl.EzySingletonLoader;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class EzySimpleSingletonLoader
extends EzySimpleObjectBuilder
implements EzySingletonLoader {
    protected final Object configurator;
    protected final Map<Class<?>, EzyMethod> methodsByType;
    protected final List<Class<?>> stackCallClasses;

    protected EzySimpleSingletonLoader(String beanName, EzyClass clazz, List<Class<?>> stackCallClasses) {
        this(beanName, clazz, null, new HashMap(), stackCallClasses);
    }

    protected EzySimpleSingletonLoader(String beanName, EzyClass clazz, Object configurator, Map<Class<?>, EzyMethod> methodsByType, List<Class<?>> stackCallClasses) {
        super(beanName, clazz);
        this.configurator = configurator;
        this.methodsByType = methodsByType;
        this.stackCallClasses = stackCallClasses;
    }

    @Override
    public final Object load(EzyBeanContext context) {
        try {
            Object singleton = this.process(context);
            EzySimpleSingletonFactory singletonFactory = (EzySimpleSingletonFactory)context.getSingletonFactory();
            singletonFactory.addCompletedSingleton(singleton);
            return singleton;
        }
        catch (EzyNewSingletonException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("can not create singleton of class " + this.clazz, e);
        }
    }

    protected Class<?> getSingletonClass() {
        return this.clazz.getClazz();
    }

    private Object process(EzyBeanContext context) throws Exception {
        EzySingletonFactory factory = context.getSingletonFactory();
        Class[] parameterTypes = this.getConstructorParameterTypes();
        StringBuilder log = new StringBuilder().append(this.getSingletonClass());
        this.detectCircularDependency(parameterTypes, log);
        this.stackCallClasses.add(this.getSingletonClass());
        Object singleton = this.getOrCreateSingleton(context, this.beanName, parameterTypes);
        Map properties = this.getAnnotationProperties();
        Object answer = factory.addSingleton(this.beanName, singleton, properties);
        this.setPropertiesToFields(singleton, context);
        this.setPropertiesToMethods(singleton, context);
        this.setValueToBindingFields(answer, context);
        this.setValueToBindingMethods(answer, context);
        this.callPostInit(answer);
        return answer;
    }

    protected Object getOrCreateSingleton(EzyBeanContext context, String name, Class[] parameterTypes) throws Exception {
        EzySingletonFactory factory = context.getSingletonFactory();
        Object singleton = factory.getSingleton(name, this.getSingletonClass());
        if (singleton == null) {
            singleton = this.newSingletonByConstructor(context, parameterTypes);
            this.logger.debug("add singleton with name {} of {}, object = {}", new Object[]{name, singleton.getClass(), singleton});
        }
        return singleton;
    }

    private Object getOrCreateSingleton(Class type, String beanName, EzyBeanContext context) {
        EzySingletonFactory factory = context.getSingletonFactory();
        Object singleton = factory.getSingleton(beanName, type);
        if (singleton == null) {
            singleton = this.createNewSingleton(type, beanName, context);
        }
        return singleton;
    }

    protected Map getAnnotationProperties() {
        return EzyKeyValueParser.getSingletonProperties(this.getSingletonClass());
    }

    protected abstract Object newSingletonByConstructor(EzyBeanContext var1, Class[] var2) throws Exception;

    private void setPropertiesToFields(Object singleton, EzyPropertyFetcher fetcher) {
        for (EzyField field : this.propertyFields) {
            this.setValueToPropertyField(field, singleton, fetcher);
        }
    }

    private void setValueToPropertyField(EzyField field, Object singleton, EzyPropertyFetcher fetcher) {
        if (!field.isWritable()) {
            return;
        }
        String propertyName = this.getPropertyName((EzyReflectElement)field);
        Object propertyValue = fetcher.getProperty(propertyName, field.getType());
        if (propertyValue != null) {
            if (!field.isPublic()) {
                field.setAccessible(true);
            }
            field.set(singleton, propertyValue);
        }
    }

    private void setPropertiesToMethods(Object singleton, EzyPropertyFetcher fetcher) {
        for (EzySetterMethod method : this.propertyMethods) {
            this.setValueToPropertyMethod(method, singleton, fetcher);
        }
    }

    private void setValueToPropertyMethod(EzySetterMethod method, Object singleton, EzyPropertyFetcher fetcher) {
        String propertyName = this.getPropertyName((EzyReflectElement)method);
        Object propertyValue = fetcher.getProperty(propertyName, method.getType());
        if (propertyValue != null) {
            method.invoke(singleton, new Object[]{propertyValue});
        }
    }

    private void setValueToBindingFields(Object singleton, EzyBeanContext context) {
        for (EzyField field : this.bindingFields) {
            this.setValueToBindingField(field, singleton, context);
        }
    }

    private void setValueToBindingField(EzyField field, Object singleton, EzyBeanContext context) {
        if (!field.isWritable()) {
            return;
        }
        Object value = this.getOrCreateSingleton(field.getType(), this.getBeanName((EzyReflectElement)field), context);
        if (!field.isPublic()) {
            field.setAccessible(true);
        }
        field.set(singleton, value);
        this.logger.debug("{} set field: {} with value: {}", new Object[]{this.clazz, field.getName(), value});
    }

    private void setValueToBindingMethods(Object singleton, EzyBeanContext context) {
        for (EzySetterMethod method : this.bindingMethods) {
            this.setValueToBindingMethod(method, singleton, context);
        }
    }

    private void setValueToBindingMethod(EzySetterMethod method, Object singleton, EzyBeanContext context) {
        Object value = this.getOrCreateSingleton(method.getType(), this.getBeanName((EzyReflectElement)method), context);
        if (!method.isPublic()) {
            method.setAccessible(true);
        }
        method.invoke(singleton, new Object[]{value});
        this.logger.debug("{} invoke method: {} with value: {}", new Object[]{singleton, method.getName(), value});
    }

    private void callPostInit(Object singleton) {
        List<EzyMethod> methods = this.getPostInitMethods();
        methods.forEach(m -> m.invoke(singleton, new Object[0]));
    }

    protected final Object[] getArguments(Class[] parameterTypes, EzyBeanContext context) {
        Object[] arguments = new Object[parameterTypes.length];
        String[] argumentNames = this.getConstructorArgumentNames();
        for (int i = 0; i < parameterTypes.length; ++i) {
            arguments[i] = this.getOrCreateSingleton(parameterTypes[i], argumentNames[i], context);
        }
        return arguments;
    }

    private Object createNewSingleton(Class paramType, String beanName, EzyBeanContext context) {
        EzyMethod method = this.methodsByType.remove(paramType);
        if (method != null) {
            this.logger.debug("add singleton of {} with method {}", (Object)paramType, (Object)method);
            EzyByMethodSingletonLoader loader = new EzyByMethodSingletonLoader(beanName, method, this.configurator, this.methodsByType, this.stackCallClasses);
            return loader.load(context);
        }
        boolean cannotCreate = this.isAbstractClass(paramType);
        if (!cannotCreate) {
            EzySingletonFactory singletonFactory = context.getSingletonFactory();
            Set<Class> singletonClasses = singletonFactory.getSingletonClasses();
            boolean bl = cannotCreate = !singletonClasses.contains(paramType);
        }
        if (cannotCreate) {
            throw new EzyNewSingletonException(this.getSingletonClass(), paramType, beanName);
        }
        EzyByConstructorSingletonLoader loader = new EzyByConstructorSingletonLoader(beanName, new EzyClass(paramType), this.stackCallClasses);
        return loader.load(context);
    }

    protected void detectCircularDependency(Class[] parameterTypes, StringBuilder log) {
        for (Class paramType : parameterTypes) {
            log.append(" => ").append(paramType);
            if (paramType.equals(this.clazz.getClazz())) {
                throw new IllegalStateException("circular dependency detected, " + log);
            }
            this.detectCircularDependency(this.getConstructorParameterTypes(paramType), log);
        }
    }

    protected Class[] getConstructorParameterTypes(Class clazz) {
        try {
            Constructor constructor = this.getConstructor(new EzyClass(clazz));
            return constructor.getParameterTypes();
        }
        catch (Throwable e) {
            return new Class[0];
        }
    }
}

