/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyhttp.core.codec.SingletonStringDeserializer;
import com.tvd12.ezyhttp.core.util.FileSizes;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.youngmonkeys.ezyplatform.concurrent.Scheduler;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Setting;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.repo.SettingRepository;
import org.youngmonkeys.ezyplatform.service.MutableSettingService;
import org.youngmonkeys.ezyplatform.web.converter.WebModelToEntityConverter;
import org.youngmonkeys.ezyplatform.web.manager.WebFileSystemManager;
import org.youngmonkeys.ezyplatform.web.repo.WebSettingRepository;

@Service
public class WebSettingService
extends MutableSettingService {
    private final WebSettingRepository settingRepository;

    public WebSettingService(Scheduler scheduler, ObjectMapper objectMapper, WebFileSystemManager fileSystemManager, WebSettingRepository settingRepository, WebModelToEntityConverter modelToEntityConverter) {
        super(scheduler, objectMapper, (FileSystemManager)fileSystemManager, (SettingRepository)settingRepository, (DefaultModelToEntityConverter)modelToEntityConverter);
        this.settingRepository = settingRepository;
        this.addValueConverter("web_accepted_media_mime_types", it -> (Set)SingletonStringDeserializer.getInstance().deserialize(it, Set.class, String.class));
        this.scheduleCacheValue("web_accepted_media_mime_types", 15);
        this.addValueConverter("web_auto_pass_management_uris", it -> {
            HashSet uris = new HashSet();
            uris.addAll(CommonConstants.DEFAULT_AUTO_PASS_URIS);
            uris.addAll((Collection)SingletonStringDeserializer.getInstance().deserialize(it, Set.class, String.class));
            return uris;
        });
        this.scheduleCacheValue("web_auto_pass_management_uris", 15);
        this.watchLastUpdatedTime("web_datetime_format", 15, () -> {
            this.cacheValueIfNotNull("web_date_format", this.getTextValue("web_date_format"));
            this.cacheValueIfNotNull("web_time_format", this.getTextValue("web_time_format"));
            this.cacheValueIfNotNull("web_datetime_format", this.getTextValue("web_datetime_format"));
            this.cacheValueIfNotNull("web_date_minute_format", this.getTextValue("web_date_minute_format"));
        });
        this.scheduleCacheValue("ezyplatform_media_up_down_loader_name", 15);
    }

    public long getMaxUploadFileSize() {
        String value = this.getTextValue("web_max_upload_file_size", "5MB");
        try {
            return FileSizes.toByteSize((String)value);
        }
        catch (Exception e) {
            return FileSizes.toByteSize((String)"5MB");
        }
    }

    public Set<String> getAcceptedMediaMimeTypes() {
        return (Set)this.getCachedValue("web_accepted_media_mime_types", CommonConstants.DEFAULT_ACCEPTED_IMAGE_TYPES);
    }

    public Set<String> getAutoPassManagementUris() {
        return (Set)this.getCachedValue("web_auto_pass_management_uris", CommonConstants.DEFAULT_AUTO_PASS_URIS);
    }

    public int getUserMaxLoginFailures() {
        return this.getIntValue("user_max_login_failures");
    }

    protected Setting getChangedSetting(String name, LocalDateTime lastUpdatedTime) {
        return this.settingRepository.findByNameAndUpdatedAtGt(name, lastUpdatedTime);
    }

    public String getWebDateFormat() {
        return (String)this.getCachedValue("web_date_format", "YYYY-MM-DD");
    }

    public String getWebTimeFormat() {
        return (String)this.getCachedValue("web_time_format", "HH:mm:ss");
    }

    public String getWebDateTimeFormat() {
        return (String)this.getCachedValue("web_datetime_format", "YYYY-MM-DD HH:mm:ss");
    }

    public String getWebDateMinuteFormat() {
        return (String)this.getCachedValue("web_date_minute_format", "YYYY-MM-DD HH:mm");
    }

    public boolean isAllowSearchUserByLikeOperator() {
        return this.getBooleanValue("web_allow_search_user_by_like_operator", true);
    }

    public String getMediaUpDownloaderName() {
        return (String)this.getCachedValue("ezyplatform_media_up_down_loader_name");
    }
}

