/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.service;

import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.util.Optional;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.model.LoginFailuresModel;
import org.youngmonkeys.ezyplatform.util.Durations;
import org.youngmonkeys.ezyplatform.util.Numbers;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;
import org.youngmonkeys.ezyplatform.web.service.WebUserMetaService;

@Service
public class WebUserLoginService {
    private final WebSettingService settingService;
    private final WebUserMetaService userMetaService;

    public int getBlockingLoginDurationInMinutes(long adminId) {
        return Durations.calculateDurationInMinute((long)System.currentTimeMillis(), (long)this.getLoginBlockUtil(adminId));
    }

    public LoginFailuresModel increaseLoginFailures(long userId) {
        int maxLoginFailures = this.settingService.getUserMaxLoginFailures();
        if (maxLoginFailures <= 0) {
            return LoginFailuresModel.builder().build();
        }
        long blockUtil = this.getLoginBlockUtil(userId);
        long now = System.currentTimeMillis();
        int newLoginFailures = maxLoginFailures;
        int blockDuration = 0;
        if (now > blockUtil) {
            int loginFailures = this.getLoginFailures(userId);
            newLoginFailures = loginFailures >= maxLoginFailures ? 1 : loginFailures + 1;
            this.userMetaService.saveUserMetaUniqueKey(userId, "login_failures", newLoginFailures);
            if (newLoginFailures >= maxLoginFailures) {
                int blockDurationInMinute = this.settingService.getIntValue("user_login_failure_block_durations");
                long newBlockUtil = now + (long)(blockDurationInMinute * 60) * 1000L;
                this.userMetaService.saveUserMetaUniqueKey(userId, "login_blocked_util", newBlockUtil);
                blockDuration = Durations.calculateDurationInMinute((long)now, (long)newBlockUtil);
            }
        }
        return LoginFailuresModel.builder().loginFailures(newLoginFailures).blockDuration(blockDuration).maxLoginFailures(maxLoginFailures).build();
    }

    public void cleanLoginFailures(long adminId) {
        this.userMetaService.saveUserMetaUniqueKey(adminId, "login_failures", 0);
        this.userMetaService.saveUserMetaUniqueKey(adminId, "login_blocked_util", 0L);
    }

    public int getLoginFailures(long userId) {
        return Optional.ofNullable(this.userMetaService.getLatestMetaValueByUserIdAndMetaKey(userId, "login_failures")).map(Numbers::toIntOrZero).orElse(0);
    }

    public long getLoginBlockUtil(long adminId) {
        return Optional.ofNullable(this.userMetaService.getLatestMetaValueByUserIdAndMetaKey(adminId, "login_blocked_util")).map(Numbers::toLongOrZero).orElse(0L);
    }

    @Generated
    public WebUserLoginService(WebSettingService settingService, WebUserMetaService userMetaService) {
        this.settingService = settingService;
        this.userMetaService = userMetaService;
    }
}

