/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.concurrent;

import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.youngmonkeys.ezyplatform.concurrent.DefaultThreadFactory;

public class Scheduler
extends EzyLoggable {
    private final boolean stoppable;
    private final Set<Task> runningTasks;
    private final Map<Runnable, Task> tasks;
    private final ExecutorService executorService;
    private final ScheduledExecutorService inspector;
    private final Map<Object, ScheduledExecutorService> executorServiceByName;
    private static final int DEFAULT_PERIOD_IN_MILLIS = 5;

    public Scheduler() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public Scheduler(int maxExecutionThread) {
        this(maxExecutionThread, false);
    }

    public Scheduler(int maxExecutionThread, boolean stoppable) {
        this(maxExecutionThread, 5, stoppable);
    }

    public Scheduler(int maxExecutionThread, int periodInMillis, boolean stoppable) {
        this.stoppable = stoppable;
        this.tasks = new ConcurrentHashMap<Runnable, Task>();
        this.runningTasks = ConcurrentHashMap.newKeySet();
        this.executorServiceByName = new ConcurrentHashMap<Object, ScheduledExecutorService>();
        this.inspector = EzyExecutors.newSingleThreadScheduledExecutor((ThreadFactory)((Object)DefaultThreadFactory.create("scheduler")));
        this.executorService = Executors.newFixedThreadPool(maxExecutionThread, (ThreadFactory)((Object)DefaultThreadFactory.create("scheduler-executor")));
        ArrayList taskBuffer = new ArrayList();
        this.inspector.scheduleAtFixedRate(() -> this.run(taskBuffer), periodInMillis, periodInMillis, TimeUnit.MILLISECONDS);
    }

    private void run(List<Task> taskBuffer) {
        taskBuffer.addAll(this.tasks.values());
        for (Task task : taskBuffer) {
            if (this.runningTasks.contains(task)) continue;
            this.doRunTask(task);
        }
        taskBuffer.clear();
    }

    private void doRunTask(Task task) {
        try {
            long currentTime = System.currentTimeMillis();
            if (currentTime >= task.nexRunTime.get()) {
                task.calculateNextRunTime();
                this.runningTasks.add(task);
                this.executorService.execute(() -> {
                    this.runTask(task);
                    if (!task.runForever) {
                        this.tasks.remove(task.command);
                    }
                });
            }
        }
        catch (Throwable e) {
            this.logger.warn("run task: {} error", (Object)task, (Object)e);
        }
    }

    public void scheduleOneTime(Runnable command, long delayTime, TimeUnit unit) {
        this.scheduleAtFixRate(command, false, delayTime, 0L, unit);
    }

    public void scheduleAtFixRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.scheduleAtFixRate(command, true, initialDelay, period, unit);
    }

    private void scheduleAtFixRate(Runnable command, boolean runForever, long initialDelay, long period, TimeUnit unit) {
        if (initialDelay < 0L) {
            throw new IllegalArgumentException("delay time must be >= 0");
        }
        Task task = new Task(command, runForever, initialDelay, period, unit);
        this.tasks.put(task.command, task);
    }

    public void cancelSchedule(Runnable command) {
        this.tasks.remove(command);
    }

    public void stop() {
        if (!this.stoppable) {
            throw new IllegalStateException("can not stop unstoppable scheduler");
        }
        this.inspector.shutdown();
        this.executorService.shutdown();
    }

    private void runTask(Task task) {
        try {
            task.command.run();
        }
        catch (Throwable e) {
            this.logger.warn("scheduler run task error", e);
        }
        finally {
            this.runningTasks.remove(task);
        }
    }

    public ScheduledExecutorService getOrCreateSingleThreadScheduledExecutor(String name) {
        return this.executorServiceByName.computeIfAbsent(name, k -> EzyExecutors.newSingleThreadScheduledExecutor((ThreadFactory)((Object)DefaultThreadFactory.create(name))));
    }

    public void removeAndShutdownScheduledExecutorService(String name) {
        ScheduledExecutorService service = this.executorServiceByName.remove(name);
        if (service != null) {
            service.shutdown();
        }
    }

    private static class Task {
        final Runnable command;
        final boolean runForever;
        final long periodMillis;
        final AtomicLong nexRunTime = new AtomicLong();

        Task(Runnable command, boolean runForever, long initialDelay, long period, TimeUnit unit) {
            this.command = command;
            this.runForever = runForever;
            this.periodMillis = unit.toMillis(period);
            this.nexRunTime.set(System.currentTimeMillis() + unit.toMillis(initialDelay));
        }

        void calculateNextRunTime() {
            this.nexRunTime.addAndGet(this.periodMillis);
        }
    }
}

