/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataI18n;
import org.youngmonkeys.ezyplatform.entity.DataI18nId;
import org.youngmonkeys.ezyplatform.model.DataI18nFieldModel;
import org.youngmonkeys.ezyplatform.model.DataI18nModel;
import org.youngmonkeys.ezyplatform.repo.DataI18nRepository;
import org.youngmonkeys.ezyplatform.service.Data18nService;

public class DefaultData18nService
implements Data18nService {
    private final DataI18nRepository dataI18nRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void saveData(DataI18nModel model) {
        this.dataI18nRepository.save(this.modelToEntityConverter.toEntity(model));
    }

    @Override
    public void saveDataList(String dataType, long dataId, String language, Collection<DataI18nFieldModel> fields) {
        this.dataI18nRepository.save(fields.stream().map(it -> {
            DataI18n entity = new DataI18n();
            entity.setDataType(dataType);
            entity.setDataId(dataId);
            entity.setLanguage(language);
            entity.setFieldName(it.getName());
            entity.setFieldValue(it.getValue());
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataId(String dataType, long dataId) {
        this.dataI18nRepository.deleteByDataTypeAndDataId(dataType, dataId);
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataIds(String dataType, Collection<Long> dataIds) {
        if (!dataIds.isEmpty()) {
            this.dataI18nRepository.deleteByDataTypeAndDataIdIn(dataType, dataIds);
        }
    }

    @Override
    public String getDataI18nValueByTypeAndIdAndLanguageFieldName(String dataType, long dataId, String language, String fieldName) {
        DataI18n entity = (DataI18n)this.dataI18nRepository.findById(new DataI18nId(dataType, dataId, language, fieldName));
        return entity != null ? entity.getFieldValue() : null;
    }

    @Override
    public Map<String, String> getDataI18nFieldsByTypeAndIdAndLanguage(String dataType, long dataId, String language) {
        return this.dataI18nRepository.findByDataTypeAndDataIdAndLanguage(dataType, dataId, language).stream().collect(Collectors.toMap(DataI18n::getFieldName, DataI18n::getFieldValue, (o, n) -> n));
    }

    @Override
    public Map<Long, String> getDataI18nValueMapByTypeAndIdsAndLanguageAndFieldName(String dataType, Collection<Long> dataIds, String language, String fieldName) {
        return this.dataI18nRepository.findByDataTypeAndDataIdInAndLanguageAndFieldName(dataType, dataIds, language, fieldName).stream().collect(Collectors.toMap(DataI18n::getDataId, DataI18n::getFieldValue));
    }

    @Override
    public Map<Long, Map<String, String>> getDataI18nFieldsMapByTypeAndIdsAndLanguage(String dataType, Collection<Long> dataIds, String language) {
        return this.dataI18nRepository.findByDataTypeAndDataIdInAndLanguage(dataType, dataIds, language).stream().collect(Collectors.groupingBy(DataI18n::getDataId, Collectors.mapping(it -> it, Collectors.toMap(DataI18n::getFieldName, DataI18n::getFieldValue, (o, n) -> n))));
    }

    @Generated
    public DefaultData18nService(DataI18nRepository dataI18nRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.dataI18nRepository = dataI18nRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

