/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collection;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataIndex;
import org.youngmonkeys.ezyplatform.model.SaveDataKeywordModel;
import org.youngmonkeys.ezyplatform.repo.DataIndexRepository;
import org.youngmonkeys.ezyplatform.service.DataIndexService;

public class DefaultDataIndexService
extends EzyLoggable
implements DataIndexService {
    private final DataIndexRepository dataIndexRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void saveKeyword(String dataType, SaveDataKeywordModel model) {
        String keyword;
        long dataId = model.getDataId();
        DataIndex entity = this.dataIndexRepository.findByDataTypeAndDataIdAndKeyword(dataType, dataId, keyword = model.getKeyword());
        if (entity == null) {
            entity = this.modelToEntityConverter.toEntity(dataType, model);
        } else {
            this.modelToEntityConverter.mergeToEntity(model, entity);
        }
        try {
            this.dataIndexRepository.save(entity);
        }
        catch (Exception e) {
            this.logger.info("save keyword: {} of data type: {} and id: {} failed", new Object[]{keyword, dataType, dataId});
        }
    }

    @Override
    public void saveKeywords(String dataType, Collection<SaveDataKeywordModel> dataKeywords) {
        for (SaveDataKeywordModel model : dataKeywords) {
            this.saveKeyword(dataType, model);
        }
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataId(String dataType, long dataId) {
        this.dataIndexRepository.deleteByDataTypeAndDataId(dataType, dataId);
    }

    @Override
    public void deleteKeywordsByDataTypeAndDataIds(String dataType, Collection<Long> dataIds) {
        if (!dataIds.isEmpty()) {
            this.dataIndexRepository.deleteByDataTypeAndDataIdIn(dataType, dataIds);
        }
    }

    @Override
    public boolean containsDataIndex(String dataType, long dataId, String keyword) {
        return this.dataIndexRepository.findByDataTypeAndDataIdAndKeyword(dataType, dataId, keyword) != null;
    }

    @Generated
    public DefaultDataIndexService(DataIndexRepository dataIndexRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.dataIndexRepository = dataIndexRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

