/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.jpa.loader;

import com.tvd12.ezydata.database.util.EzyDatabasePropertiesKeeper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.mapping.PropertiesMapper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.function.Function;
import javax.sql.DataSource;

public class EzyJpaDataSourceLoader
extends EzyDatabasePropertiesKeeper<EzyJpaDataSourceLoader> {
    public DataSource load() {
        return this.load(props -> new HikariDataSource(this.newConfig((Properties)props)));
    }

    public DataSource load(Function<Properties, DataSource> supplier) {
        return supplier.apply(this.properties);
    }

    private HikariConfig newConfig(Properties properties) {
        Properties newProps = new Properties();
        for (String name : properties.stringPropertyNames()) {
            String camelCaseName = EzyStrings.underscoreToCamelCase((String)name);
            newProps.put(camelCaseName, properties.get(name));
        }
        return (HikariConfig)new PropertiesMapper().data(newProps).map(HikariConfig.class);
    }
}

