/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.controller.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.concurrent.EzyLazyInitializer;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.stream.EzyInputStreamLoader;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyReturner;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.data.DownloadFileResult;
import com.tvd12.ezyhttp.core.exception.HttpNotAcceptableException;
import com.tvd12.ezyhttp.core.resources.ResourceDownloadManager;
import com.tvd12.ezyhttp.server.core.handler.ResourceRequestHandler;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.resources.FileUploader;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.youngmonkeys.ezyplatform.converter.HttpModelToResponseConverter;
import org.youngmonkeys.ezyplatform.converter.HttpRequestToModelConverter;
import org.youngmonkeys.ezyplatform.data.FileMetadata;
import org.youngmonkeys.ezyplatform.data.ImageSize;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadAction;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.event.EventHandlerManager;
import org.youngmonkeys.ezyplatform.event.GetMediaFilePathEvent;
import org.youngmonkeys.ezyplatform.event.MediaAddedEvent;
import org.youngmonkeys.ezyplatform.event.MediaDownloadEvent;
import org.youngmonkeys.ezyplatform.event.MediaRemovedEvent;
import org.youngmonkeys.ezyplatform.event.MediaUpdatedEvent;
import org.youngmonkeys.ezyplatform.event.MediaUploadEvent;
import org.youngmonkeys.ezyplatform.event.MediaUploadedEvent;
import org.youngmonkeys.ezyplatform.exception.MediaNotFoundException;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.media.MediaDownloadArguments;
import org.youngmonkeys.ezyplatform.media.MediaUpDownloader;
import org.youngmonkeys.ezyplatform.media.MediaUpDownloaderManager;
import org.youngmonkeys.ezyplatform.media.MediaUploadArguments;
import org.youngmonkeys.ezyplatform.model.AddMediaModel;
import org.youngmonkeys.ezyplatform.model.MediaDetailsModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.ReplaceMediaModel;
import org.youngmonkeys.ezyplatform.model.SaveMediaFileFromUrlModel;
import org.youngmonkeys.ezyplatform.model.UpdateMediaModel;
import org.youngmonkeys.ezyplatform.pagination.ComplexPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.pagination.PaginationModelFetchers;
import org.youngmonkeys.ezyplatform.request.AddMediaFromUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaIncludeUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.service.MediaService;
import org.youngmonkeys.ezyplatform.service.PaginationMediaService;
import org.youngmonkeys.ezyplatform.service.PaginationService;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.util.Strings;
import org.youngmonkeys.ezyplatform.util.Uris;
import org.youngmonkeys.ezyplatform.validator.CommonValidator;
import org.youngmonkeys.ezyplatform.validator.MediaValidator;

public class MediaControllerService
extends EzyLoggable {
    private final HttpClient httpClient;
    private final EventHandlerManager eventHandlerManager;
    private final FileSystemManager fileSystemManager;
    private final EzyInputStreamLoader inputStreamLoader;
    private final MediaUpDownloaderManager mediaUpDownloaderManager;
    private final ObjectMapper objectMapper;
    private final ResourceDownloadManager resourceDownloadManager;
    private final MediaService mediaService;
    private final PaginationMediaService paginationMediaService;
    private final SettingService settingService;
    private final CommonValidator commonValidator;
    private final MediaValidator mediaValidator;
    private final MediaPaginationParameterConverter mediaPaginationParameterConverter;
    private final HttpModelToResponseConverter modelToResponseConverter;
    private final HttpRequestToModelConverter requestToModelConverter;
    private final EzyLazyInitializer<FileUploader> fileUploaderWrapper;
    private final EzyLazyInitializer<TikaConfig> tika = new EzyLazyInitializer(() -> (TikaConfig)EzyReturner.returnWithException(TikaConfig::new));

    public MediaControllerService(HttpClient httpClient, EventHandlerManager eventHandlerManager, FileSystemManager fileSystemManager, EzyInputStreamLoader inputStreamLoader, MediaUpDownloaderManager mediaUpDownloaderManager, ObjectMapper objectMapper, ResourceDownloadManager resourceDownloadManager, EzySingletonFactory singletonFactory, MediaService mediaService, PaginationMediaService paginationMediaService, SettingService settingService, CommonValidator commonValidator, MediaValidator mediaValidator, MediaPaginationParameterConverter mediaPaginationParameterConverter, HttpModelToResponseConverter modelToResponseConverter, HttpRequestToModelConverter requestToModelConverter) {
        this.httpClient = httpClient;
        this.mediaService = mediaService;
        this.paginationMediaService = paginationMediaService;
        this.settingService = settingService;
        this.objectMapper = objectMapper;
        this.inputStreamLoader = inputStreamLoader;
        this.commonValidator = commonValidator;
        this.mediaValidator = mediaValidator;
        this.eventHandlerManager = eventHandlerManager;
        this.fileSystemManager = fileSystemManager;
        this.mediaUpDownloaderManager = mediaUpDownloaderManager;
        this.resourceDownloadManager = resourceDownloadManager;
        this.mediaPaginationParameterConverter = mediaPaginationParameterConverter;
        this.modelToResponseConverter = modelToResponseConverter;
        this.requestToModelConverter = requestToModelConverter;
        this.fileUploaderWrapper = new EzyLazyInitializer(() -> (FileUploader)singletonFactory.getSingletonCast(FileUploader.class));
    }

    public void addMedia(HttpServletRequest request, HttpServletResponse response, String uploadFrom, long ownerAdminId, long ownerUserId, boolean avatar, boolean notPublic) throws Exception {
        this.addMedia(request, response, uploadFrom, ownerAdminId, ownerUserId, avatar, notPublic, this.settingService.getMaxUploadFileSize());
    }

    public void addMedia(HttpServletRequest request, HttpServletResponse response, String uploadFrom, long ownerAdminId, long ownerUserId, boolean avatar, boolean notPublic, long maxFileSize) throws Exception {
        Collection parts;
        String mediaUploaderName = this.settingService.getMediaUpDownloaderName();
        MediaUpDownloader mediaUpDownloader = this.mediaUpDownloaderManager.getMediaUpDownloaderByName(mediaUploaderName);
        FileUploader fileUploader = (FileUploader)this.fileUploaderWrapper.get();
        if (mediaUpDownloader != null) {
            mediaUpDownloader.upload(MediaUploadArguments.builder().tika((TikaConfig)this.tika.get()).fileUploader(fileUploader).request(request).response(response).uploadFrom(uploadFrom).action(UploadAction.ADD).ownerAdminId(ownerAdminId).ownerUserId(ownerUserId).avatar(avatar).notPublic(notPublic).build());
            return;
        }
        if (fileUploader == null) {
            throw new HttpNotAcceptableException(Collections.singletonMap("fileUpload", "disabled"));
        }
        Part filePart = request.getPart("file");
        if (filePart == null && !(parts = request.getParts()).isEmpty()) {
            filePart = (Part)parts.iterator().next();
        }
        FileMetadata fileMetadata = this.mediaValidator.validateFilePart(filePart, avatar);
        this.eventHandlerManager.handleEvent((Object)MediaUploadEvent.builder().uploadFrom(uploadFrom).ownerAdminId(ownerAdminId).ownerUserId(ownerUserId).fileMetadata(fileMetadata).build());
        String submittedFileName = filePart.getSubmittedFileName();
        String fileExtension = fileMetadata.getExtension();
        String containerFolder = fileMetadata.getMediaType().getFolder();
        String newFileName = this.mediaService.generateMediaFileName(submittedFileName, fileExtension);
        AsyncContext asyncContext = request.getAsyncContext();
        File mediaFilePath = this.fileSystemManager.getMediaFilePath(containerFolder, newFileName);
        fileUploader.accept(asyncContext, filePart, mediaFilePath, maxFileSize, () -> {
            MediaModel model = this.saveMediaInformation(uploadFrom, ownerAdminId, ownerUserId, submittedFileName, newFileName, fileMetadata, mediaFilePath.length(), notPublic);
            this.eventHandlerManager.handleEvent((Object)new MediaUploadedEvent(model, mediaFilePath));
            byte[] responseBytes = this.objectMapper.writeValueAsString((Object)model).getBytes();
            response.getOutputStream().write(responseBytes);
        });
    }

    public MediaModel addMedia(String uploadFrom, long ownerAdminId, long ownerUserId, AddMediaFromUrlRequest request, boolean notPublic) {
        this.mediaValidator.validate(request);
        String mediaName = this.mediaService.generateMediaFileName(request.getUrl(), request.getType().toString().toLowerCase());
        AddMediaModel model = this.requestToModelConverter.toModel(ownerAdminId, ownerUserId, mediaName, request, notPublic);
        MediaModel media = this.mediaService.addMedia(uploadFrom, model);
        this.eventHandlerManager.handleEvent((Object)new MediaAddedEvent(media.getId()));
        return media;
    }

    private MediaModel saveMediaInformation(String uploadFrom, long ownerAdminId, long ownerUserId, String submittedFileName, String fileName, FileMetadata fileMetadata, long fileSize, boolean notPublic) {
        return this.mediaService.addMedia(uploadFrom, AddMediaModel.builder().ownerAdminId(ownerAdminId).ownerUserId(ownerUserId).fileName(fileName).originalFileName(submittedFileName).mediaType(fileMetadata.getMediaType().toString()).mimeType(fileMetadata.getMimeType()).fileSize(fileSize).notPublic(notPublic).build());
    }

    public void replaceMedia(HttpServletRequest request, HttpServletResponse response, long mediaId, Predicate<MediaModel> validMediaCondition) throws Exception {
        Collection parts;
        boolean avatar;
        MediaModel media = this.mediaService.getMediaById(mediaId);
        if (media == null || !validMediaCondition.test(media)) {
            throw new ResourceNotFoundException("media");
        }
        String mediaUploaderName = this.settingService.getMediaUpDownloaderName();
        MediaUpDownloader mediaUpDownloader = this.mediaUpDownloaderManager.getMediaUpDownloaderByName(mediaUploaderName);
        FileUploader fileUploader = (FileUploader)this.fileUploaderWrapper.get();
        String uploadFrom = media.getUploadFrom();
        long ownerAdminId = media.getOwnerAdminId();
        long ownerUserId = media.getOwnerUserId();
        boolean bl = avatar = media.getType() == MediaType.AVATAR;
        if (mediaUpDownloader != null) {
            mediaUpDownloader.upload(MediaUploadArguments.builder().tika((TikaConfig)this.tika.get()).fileUploader(fileUploader).request(request).response(response).uploadFrom(uploadFrom).action(UploadAction.REPLACE).mediaId(mediaId).ownerAdminId(ownerAdminId).ownerUserId(ownerUserId).avatar(avatar).notPublic(!media.isPublicMedia()).build());
            return;
        }
        if (fileUploader == null) {
            throw new HttpNotAcceptableException(Collections.singletonMap("fileUpload", "disabled"));
        }
        Part filePart = request.getPart("file");
        if (filePart == null && !(parts = request.getParts()).isEmpty()) {
            filePart = (Part)parts.iterator().next();
        }
        FileMetadata fileMetadata = this.mediaValidator.validateFilePart(filePart, avatar);
        this.eventHandlerManager.handleEvent((Object)MediaUploadEvent.builder().uploadFrom(uploadFrom).ownerAdminId(ownerAdminId).ownerUserId(ownerUserId).media(media).fileMetadata(fileMetadata).build());
        String submittedFileName = filePart.getSubmittedFileName();
        String containerFolder = fileMetadata.getMediaType().getFolder();
        String fileName = media.getName();
        AsyncContext asyncContext = request.getAsyncContext();
        File mediaFilePath = this.fileSystemManager.getMediaFilePath(containerFolder, fileName);
        fileUploader.accept(asyncContext, filePart, mediaFilePath, this.settingService.getMaxUploadFileSize(), () -> {
            MediaModel model = this.replaceMediaInformation(mediaId, submittedFileName, fileMetadata, mediaFilePath.length());
            this.eventHandlerManager.handleEvent((Object)new MediaUploadedEvent(model, mediaFilePath));
            byte[] responseBytes = this.objectMapper.writeValueAsString((Object)model).getBytes();
            response.getOutputStream().write(responseBytes);
        });
    }

    private MediaModel replaceMediaInformation(long mediaId, String submittedFileName, FileMetadata fileMetadata, long fileSize) {
        return this.mediaService.replaceMedia(ReplaceMediaModel.builder().mediaId(mediaId).originalFileName(submittedFileName).mediaType(Strings.from((Object)fileMetadata.getMediaType())).mimeType(fileMetadata.getMimeType()).fileSize(fileSize).build());
    }

    public long saveMediaFile(MediaType mediaType, String mediaUrl, UploadFrom uploadFrom, long ownerAdminId, long ownerUserId) {
        return this.saveMediaFileFromUrl(uploadFrom.toString(), ownerAdminId, ownerUserId, SaveMediaFileFromUrlModel.builder().mediaType(mediaType.toString()).mediaUrl(mediaUrl).build());
    }

    public long saveMediaFileFromUrl(String uploadFrom, long ownerAdminId, long ownerUserId, SaveMediaFileFromUrlModel model) {
        String mediaUrl = model.getMediaUrl();
        if (EzyStrings.isBlank((String)mediaUrl)) {
            return 0L;
        }
        String mediaTypeText = model.getMediaType();
        try {
            org.apache.tika.mime.MediaType tikaMediaType;
            File outFolder = this.fileSystemManager.getMediaFolderPath(MediaType.ofName((String)mediaTypeText));
            String fileName = this.mediaService.generateMediaFileName(mediaUrl, Uris.getFileExtensionInUrl((String)mediaUrl));
            DownloadFileResult result = this.httpClient.download(mediaUrl, outFolder, fileName);
            try (InputStream inputStream = Files.newInputStream(outFolder.toPath().resolve(result.getNewFileName()), new OpenOption[0]);){
                tikaMediaType = ((TikaConfig)this.tika.get()).getDetector().detect((InputStream)TikaInputStream.get((InputStream)inputStream), new Metadata());
            }
            MediaModel media = this.mediaService.addMedia(uploadFrom, AddMediaModel.builder().fileName(result.getNewFileName()).originalFileName(result.getOriginalFileName()).mediaType(mediaTypeText).mimeType(tikaMediaType.toString()).ownerAdminId(ownerAdminId).ownerUserId(ownerUserId).build());
            return media.getId();
        }
        catch (Exception e) {
            this.logger.info("can not download media from url: {}", (Object)mediaUrl, (Object)e);
            return 0L;
        }
    }

    public void updateMedia(long mediaId, UpdateMediaRequest request, Predicate<MediaModel> validMediaCondition) {
        this.mediaValidator.validate(request);
        MediaModel media = this.mediaValidator.validateMediaId(mediaId);
        if (!validMediaCondition.test(media)) {
            throw new MediaNotFoundException(mediaId);
        }
        request.setFileSize(this.getMediaFileSize(media));
        UpdateMediaModel model = this.requestToModelConverter.toModel(mediaId, request);
        MediaModel updatedMedia = this.mediaService.updateMedia(model);
        this.eventHandlerManager.handleEvent((Object)new MediaUpdatedEvent(updatedMedia));
    }

    public void updateMedia(long mediaId, UpdateMediaIncludeUrlRequest request, Predicate<MediaModel> validMediaCondition) {
        this.mediaValidator.validate(request);
        MediaModel media = this.mediaValidator.validateMediaId(mediaId);
        if (!validMediaCondition.test(media)) {
            throw new MediaNotFoundException(mediaId);
        }
        request.setFileSize(this.getMediaFileSize(media));
        UpdateMediaModel model = this.requestToModelConverter.toModel(mediaId, request);
        MediaModel updatedMedia = this.mediaService.updateMedia(model);
        this.eventHandlerManager.handleEvent((Object)new MediaUpdatedEvent(updatedMedia));
    }

    public void updateMedia(String mediaName, UpdateMediaRequest request, Predicate<MediaModel> validMediaCondition) {
        this.mediaValidator.validate(request);
        MediaModel media = this.mediaValidator.validateMediaNameAndGet(mediaName);
        if (!validMediaCondition.test(media)) {
            throw new MediaNotFoundException(mediaName);
        }
        request.setFileSize(this.getMediaFileSize(media));
        UpdateMediaModel model = this.requestToModelConverter.toModel(mediaName, request);
        MediaModel updatedMedia = this.mediaService.updateMedia(model);
        this.eventHandlerManager.handleEvent((Object)new MediaUpdatedEvent(updatedMedia));
    }

    public void updateMediaStatus(long mediaId, String status) {
        MediaModel media = this.mediaService.updateMediaStatus(mediaId, status);
        this.eventHandlerManager.handleEvent((Object)new MediaUpdatedEvent(media));
    }

    public long getMediaFileSize(MediaModel media) {
        String containerFolder = media.getType().getFolder();
        String fileName = media.getName();
        File mediaFilePath = this.fileSystemManager.getMediaFilePath(containerFolder, fileName);
        return mediaFilePath.length();
    }

    public void removeMediaById(long mediaId, boolean deleteFile) {
        MediaModel media = this.mediaService.removeMedia(mediaId);
        if (deleteFile && "DELETED".equals(media.getStatus())) {
            File file = this.fileSystemManager.getMediaFilePath(media.getType().getFolder(), media.getName());
            FolderProxy.deleteFile((File)file);
        }
        this.eventHandlerManager.handleEvent((Object)new MediaRemovedEvent(media));
    }

    public void removeMediaByName(String mediaName, boolean deleteFile) {
        MediaModel media = this.mediaService.removeMedia(mediaName);
        if (deleteFile && "DELETED".equals(media.getStatus())) {
            String containerFolder = media.getType().getFolder();
            File filePath = this.fileSystemManager.getMediaFilePath(containerFolder, media.getName());
            FolderProxy.deleteFile((File)filePath);
        }
        this.eventHandlerManager.handleEvent((Object)new MediaRemovedEvent(media));
    }

    public void getMediaByName(RequestArguments requestArguments, String name, boolean exposePrivateMedia, Predicate<MediaModel> validMediaCondition) throws Exception {
        String mediaUploaderName = this.settingService.getMediaUpDownloaderName();
        MediaUpDownloader mediaUpDownloader = this.mediaUpDownloaderManager.getMediaUpDownloaderByName(mediaUploaderName);
        if (mediaUpDownloader != null) {
            mediaUpDownloader.download(MediaDownloadArguments.builder().requestArguments(requestArguments).name(name).exposePrivateMedia(exposePrivateMedia).validMediaCondition(validMediaCondition).build());
            return;
        }
        this.mediaValidator.validateMediaName(name);
        MediaModel media = this.mediaService.getMediaByName(name);
        if (media == null || !media.isPublicMedia() && !exposePrivateMedia && !validMediaCondition.test(media)) {
            throw new MediaNotFoundException(name);
        }
        this.eventHandlerManager.handleEvent((Object)new MediaDownloadEvent(media));
        MediaType mediaType = media.getType();
        String mediaName = media.getName();
        File resourcePath = this.fileSystemManager.getMediaFilePath(mediaType.getFolder(), mediaName);
        if (!resourcePath.exists()) {
            throw new MediaNotFoundException(mediaName);
        }
        String extension = FolderProxy.getFileExtension((String)mediaName);
        ResourceRequestHandler handler = new ResourceRequestHandler(resourcePath.toString(), resourcePath.toString(), extension, this.inputStreamLoader, this.resourceDownloadManager);
        handler.handle(requestArguments);
    }

    public MediaDetailsModel getMediaDetailsById(long mediaId, Predicate<MediaModel> validMediaCondition) {
        MediaModel media = this.mediaService.getMediaById(mediaId);
        if (media == null || !validMediaCondition.test(media)) {
            throw new MediaNotFoundException(mediaId);
        }
        return this.getMediaDetails(media);
    }

    public MediaDetailsModel getMediaDetailsByName(String mediaName, Predicate<MediaModel> validMediaCondition) {
        MediaModel media = this.mediaService.getMediaByName(mediaName);
        if (media == null || !validMediaCondition.test(media)) {
            throw new MediaNotFoundException(mediaName);
        }
        return this.getMediaDetails(media);
    }

    public MediaDetailsModel getMediaDetails(MediaModel media) {
        long size;
        int width = 0;
        int height = 0;
        MediaType mediaType = media.getType();
        if (mediaType == MediaType.IMAGE || mediaType == MediaType.AVATAR) {
            File mediaFilePath;
            ImageSize imageSize = this.mediaService.getMediaImageSizeOrNull(media.getName(), media.getType());
            if (imageSize == null && (mediaFilePath = (File)this.eventHandlerManager.handleEvent((Object)new GetMediaFilePathEvent(media))) != null) {
                imageSize = this.mediaService.getMediaImageSizeOrDefault(mediaFilePath);
            }
            if (imageSize == null) {
                imageSize = ImageSize.ZERO;
            }
            width = imageSize.getWidth();
            height = imageSize.getHeight();
            size = imageSize.getSize();
        } else {
            File mediaFilePath;
            size = this.mediaService.getMediaFileLengthOrNegative(mediaType, media.getName());
            if (size < 0L && (mediaFilePath = (File)this.eventHandlerManager.handleEvent((Object)new GetMediaFilePathEvent(media))) != null) {
                size = this.mediaService.getMediaFileLengthOrZero(mediaFilePath);
            }
        }
        if (size < 0L) {
            size = 0L;
        }
        return MediaDetailsModel.fromMediaModel((MediaModel)media).width((long)width).height((long)height).size(size).build();
    }

    public PaginationModel<MediaResponse> getMediaList(MediaFilter filter, String sortOrder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        this.commonValidator.validatePageSize(limit);
        PaginationModel pagination = PaginationModelFetchers.getPaginationModelBySortOrder((PaginationService)this.paginationMediaService, (ComplexPaginationParameterConverter)this.mediaPaginationParameterConverter, (Object)filter, (String)sortOrder, (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
        return pagination.map(this.modelToResponseConverter::toResponse);
    }
}

