/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.annotation.EzyPackagesToScan;
import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.bean.EzyBeanContextBuilder;
import com.tvd12.ezyfox.bean.EzyPackagesToScanProvider;
import com.tvd12.ezyfox.bean.EzyPropertiesMap;
import com.tvd12.ezyfox.bean.EzyPropertyFetcher;
import com.tvd12.ezyfox.bean.impl.EzyBeanKey;
import com.tvd12.ezyfox.bean.impl.EzyBeanNameParser;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyPackages;
import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyhttp.core.annotation.BodyConvert;
import com.tvd12.ezyhttp.core.annotation.Interceptor;
import com.tvd12.ezyhttp.core.annotation.StringConvert;
import com.tvd12.ezyhttp.core.codec.DataConverters;
import com.tvd12.ezyhttp.core.constant.Constants;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.resources.ResourceDownloadManager;
import com.tvd12.ezyhttp.server.core.ApplicationContext;
import com.tvd12.ezyhttp.server.core.SimpleApplicationContext;
import com.tvd12.ezyhttp.server.core.annotation.ApplicationBootstrap;
import com.tvd12.ezyhttp.server.core.annotation.ComponentClasses;
import com.tvd12.ezyhttp.server.core.annotation.ComponentsScan;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.ExceptionHandler;
import com.tvd12.ezyhttp.server.core.annotation.EzyConfigurationAfterApplicationReady;
import com.tvd12.ezyhttp.server.core.annotation.PropertiesSources;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import com.tvd12.ezyhttp.server.core.asm.ExceptionHandlersImplementer;
import com.tvd12.ezyhttp.server.core.asm.RequestHandlersImplementer;
import com.tvd12.ezyhttp.server.core.handler.IRequestController;
import com.tvd12.ezyhttp.server.core.handler.RequestHandler;
import com.tvd12.ezyhttp.server.core.handler.RequestResponseWatcher;
import com.tvd12.ezyhttp.server.core.handler.RequestURIDecorator;
import com.tvd12.ezyhttp.server.core.handler.ResourceRequestHandler;
import com.tvd12.ezyhttp.server.core.handler.UncaughtExceptionHandler;
import com.tvd12.ezyhttp.server.core.handler.UnhandledErrorHandler;
import com.tvd12.ezyhttp.server.core.manager.ComponentManager;
import com.tvd12.ezyhttp.server.core.manager.ControllerManager;
import com.tvd12.ezyhttp.server.core.manager.ExceptionHandlerManager;
import com.tvd12.ezyhttp.server.core.manager.InterceptorManager;
import com.tvd12.ezyhttp.server.core.manager.RequestHandlerManager;
import com.tvd12.ezyhttp.server.core.request.RequestURI;
import com.tvd12.ezyhttp.server.core.resources.Resource;
import com.tvd12.ezyhttp.server.core.resources.ResourceResolver;
import com.tvd12.ezyhttp.server.core.resources.ResourceResolvers;
import com.tvd12.ezyhttp.server.core.util.InterceptorAnnotations;
import com.tvd12.ezyhttp.server.core.util.ServiceAnnotations;
import com.tvd12.ezyhttp.server.core.view.AbsentMessageResolver;
import com.tvd12.ezyhttp.server.core.view.MessageProvider;
import com.tvd12.ezyhttp.server.core.view.TemplateResolver;
import com.tvd12.ezyhttp.server.core.view.ViewContext;
import com.tvd12.ezyhttp.server.core.view.ViewContextBuilder;
import com.tvd12.ezyhttp.server.core.view.ViewDecorator;
import com.tvd12.ezyhttp.server.core.view.ViewDialect;
import com.tvd12.ezyhttp.server.core.view.ViewTemplateInputStreamLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ApplicationContextBuilder
implements EzyBuilder<ApplicationContext> {
    protected final Properties properties = this.defaultProperties();
    protected final Set<String> packageToScans = new HashSet<String>();
    protected final Set<Class> componentClasses = new HashSet<Class>();
    protected final Set<String> propertiesSources = new HashSet<String>();
    protected final ObjectMapper objectMapper;
    protected final DataConverters dataConverters;
    protected final ComponentManager componentManager;
    protected final ControllerManager controllerManager;
    protected final InterceptorManager interceptorManager;
    protected final RequestHandlerManager requestHandlerManager;
    protected final ExceptionHandlerManager exceptionHandlerManager;
    protected final Map<String, Object> singletonByName;
    protected final Map<EzyBeanKey, Object> singletonByKey = new HashMap<EzyBeanKey, Object>();

    public ApplicationContextBuilder() {
        this.singletonByName = new HashMap<String, Object>();
        this.componentManager = ComponentManager.getInstance();
        this.objectMapper = this.componentManager.getObjectMapper();
        this.dataConverters = this.componentManager.getDataConverters();
        this.controllerManager = this.componentManager.getControllerManager();
        this.interceptorManager = this.componentManager.getInterceptorManager();
        this.requestHandlerManager = this.componentManager.getRequestHandlerManager();
        this.exceptionHandlerManager = this.componentManager.getExceptionHandlerManager();
    }

    public Properties defaultProperties() {
        Properties props = new Properties();
        props.put("server.port", (Object)8080);
        return props;
    }

    public ApplicationContextBuilder scan(String packageName) {
        this.packageToScans.add(packageName);
        return this;
    }

    public ApplicationContextBuilder scan(String ... packageNames) {
        for (String packageName : packageNames) {
            this.scan(packageName);
        }
        return this;
    }

    public ApplicationContextBuilder scan(Iterable<String> packageNames) {
        for (String packageName : packageNames) {
            this.scan(packageName);
        }
        return this;
    }

    public ApplicationContextBuilder addComponentClass(Class<?> componentClass) {
        PropertiesSources propertiesSources;
        ComponentClasses componentClasses;
        EzyPackagesToScan packagesToScan;
        ComponentsScan componentsScan = componentClass.getAnnotation(ComponentsScan.class);
        if (componentsScan != null) {
            String[] stringArray;
            if (componentsScan.value().length != 0) {
                stringArray = componentsScan.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = componentClass.getPackage().getName();
            }
            this.scan(stringArray);
        }
        if ((packagesToScan = componentClass.getAnnotation(EzyPackagesToScan.class)) != null) {
            String[] stringArray;
            if (packagesToScan.value().length != 0) {
                stringArray = packagesToScan.value();
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = componentClass.getPackage().getName();
            }
            this.scan(stringArray);
        }
        if ((componentClasses = componentClass.getAnnotation(ComponentClasses.class)) != null) {
            this.addComponentClasses(componentClasses.value());
        }
        if ((propertiesSources = componentClass.getAnnotation(PropertiesSources.class)) != null) {
            this.addPropertiesSources(propertiesSources.value());
        }
        this.componentClasses.add(componentClass);
        return this;
    }

    public ApplicationContextBuilder addComponentClasses(Class<?> ... componentClasses) {
        for (Class<?> clazz : componentClasses) {
            this.addComponentClass(clazz);
        }
        return this;
    }

    public ApplicationContextBuilder addComponentClasses(Iterable<Class<?>> componentClasses) {
        for (Class<?> clazz : componentClasses) {
            this.addComponentClass(clazz);
        }
        return this;
    }

    public ApplicationContextBuilder addPropertiesSource(String source) {
        this.propertiesSources.add(source);
        return this;
    }

    public ApplicationContextBuilder addPropertiesSources(String ... sources) {
        for (String source : sources) {
            this.addPropertiesSource(source);
        }
        return this;
    }

    public ApplicationContextBuilder addPropertiesSources(Iterable<String> sources) {
        for (String source : sources) {
            this.addPropertiesSource(source);
        }
        return this;
    }

    public ApplicationContextBuilder addProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public ApplicationContextBuilder addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public ApplicationContextBuilder addProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public ApplicationContextBuilder addSingleton(Object singleton) {
        return this.addSingleton(EzyBeanNameParser.getSingletonName(singleton.getClass()), singleton);
    }

    public ApplicationContextBuilder addSingleton(String name, Object singleton) {
        this.singletonByName.put(name, singleton);
        return this;
    }

    public ApplicationContextBuilder addSingleton(Map<String, Object> singletons) {
        this.singletonByName.putAll(singletons);
        return this;
    }

    public ApplicationContextBuilder beanContext(EzyBeanContext beanContext) {
        this.singletonByKey.putAll(beanContext.getSingletonMapByKey());
        return this;
    }

    public ApplicationContext build() {
        EzyBeanContext beanContext = this.createBeanContext();
        SimpleApplicationContext context = new SimpleApplicationContext();
        context.setBeanContext(beanContext);
        return context;
    }

    protected EzyBeanContext createBeanContext() {
        if (this.packageToScans.isEmpty()) {
            throw new IllegalStateException("must scan at least one package");
        }
        HashSet<String> allPackageToScans = new HashSet<String>();
        allPackageToScans.add("com.tvd12.ezyhttp.server");
        allPackageToScans.addAll(this.packageToScans);
        EzyReflection reflection = EzyPackages.scanPackages(allPackageToScans);
        this.addComponentClassesFromReflection(reflection);
        allPackageToScans.addAll(this.packageToScans);
        allPackageToScans.addAll(this.getPackagesToScanFromProviders(reflection));
        reflection = EzyPackages.scanPackages(allPackageToScans);
        Set controllerClasses = reflection.getAnnotatedClasses(Controller.class);
        Set interceptorClasses = reflection.getAnnotatedClasses(Interceptor.class);
        Set exceptionHandlerClasses = reflection.getAnnotatedClasses(ExceptionHandler.class);
        Set bodyConverterClasses = reflection.getAnnotatedClasses(BodyConvert.class);
        Set stringConverterClasses = reflection.getAnnotatedClasses(StringConvert.class);
        Set bootstrapClasses = reflection.getAnnotatedClasses(ApplicationBootstrap.class);
        Set configurationAfterApplicationReadyClasses = reflection.getAnnotatedClasses(EzyConfigurationAfterApplicationReady.class);
        Map<String, Class> serviceClasses = this.getServiceClasses(reflection);
        EzyPropertiesMap propertiesMap = this.getPropertiesMap(reflection);
        EzyBeanContext beanContext = (EzyBeanContext)this.newBeanContextBuilder().scan(allPackageToScans).addSingletonClasses(this.componentClasses).addSingletonClasses(serviceClasses).addSingletonClasses((Iterable)controllerClasses).addSingletonClasses((Iterable)interceptorClasses).addSingletonClasses((Iterable)exceptionHandlerClasses).addSingletonClasses((Iterable)bodyConverterClasses).addSingletonClasses((Iterable)stringConverterClasses).addSingletonClasses((Iterable)bootstrapClasses).addSingletonClasses((Iterable)configurationAfterApplicationReadyClasses).propertiesMap(propertiesMap).addSingleton("systemObjectMapper", (Object)this.objectMapper).addSingleton("componentManager", (Object)this.componentManager).addSingleton("requestHandlerManager", (Object)this.requestHandlerManager).addSingleton("featureURIManager", (Object)this.requestHandlerManager.getFeatureURIManager()).addSingleton("requestURIManager", (Object)this.requestHandlerManager.getRequestURIManager()).addAllClasses((Object)EzyPackages.scanPackage((String)"com.tvd12.ezyhttp.server")).build();
        this.setComponentProperties(beanContext);
        this.registerComponents(beanContext);
        this.addRequestHandlers(beanContext);
        this.addResourceRequestHandlers(beanContext);
        this.addExceptionHandlers();
        return beanContext;
    }

    private Set<String> getPackagesToScanFromProviders(EzyReflection reflection) {
        HashSet<String> answer = new HashSet<String>();
        Set providerClasses = reflection.getExtendsClasses(EzyPackagesToScanProvider.class);
        for (Class clazz : providerClasses) {
            EzyPackagesToScanProvider provider = (EzyPackagesToScanProvider)EzyClasses.newInstance((Class)clazz);
            answer.addAll(provider.provide());
        }
        return answer;
    }

    protected void addComponentClassesFromReflection(EzyReflection reflection) {
        HashSet classes = new HashSet();
        classes.addAll(reflection.getAnnotatedClasses(ComponentsScan.class));
        classes.addAll(reflection.getAnnotatedClasses(ComponentClasses.class));
        classes.addAll(reflection.getAnnotatedClasses(PropertiesSources.class));
        classes.addAll(reflection.getAnnotatedClasses(EzyPackagesToScan.class));
        for (Class clazz : classes) {
            this.addComponentClass(clazz);
        }
    }

    protected EzyBeanContextBuilder newBeanContextBuilder() {
        EzyBeanContextBuilder beanContextBuilder = EzyBeanContext.builder();
        beanContextBuilder.addProperties((Map)this.properties).addSingletons(this.singletonByName).addSingletonsByKey(this.singletonByKey);
        ArrayList<String> propertiesFiles = new ArrayList<String>();
        propertiesFiles.addAll(Arrays.asList(Constants.DEFAULT_PROPERTIES_FILES));
        propertiesFiles.addAll(this.propertiesSources);
        for (String propertiesFile : propertiesFiles) {
            beanContextBuilder.addProperties(propertiesFile);
        }
        return beanContextBuilder;
    }

    protected EzyPropertiesMap getPropertiesMap(EzyReflection reflection) {
        Class propertiesMapClass = reflection.getExtendsClass(EzyPropertiesMap.class);
        if (propertiesMapClass == null) {
            return null;
        }
        return (EzyPropertiesMap)EzyClasses.newInstance((Class)propertiesMapClass);
    }

    protected Map<String, Class> getServiceClasses(EzyReflection reflection) {
        Set classes = reflection.getAnnotatedClasses(Service.class);
        HashMap<String, Class> answer = new HashMap<String, Class>();
        for (Class clazz : classes) {
            String serviceName = ServiceAnnotations.getServiceName(clazz);
            if (answer.containsKey(serviceName)) {
                serviceName = clazz.getName();
            }
            answer.put(serviceName, clazz);
        }
        return answer;
    }

    protected void setComponentProperties(EzyBeanContext beanContext) {
        this.componentManager.setDebug((Boolean)beanContext.getProperty((Object)"server.debug", Boolean.TYPE, (Object)false));
        this.requestHandlerManager.setAllowOverrideURI((Boolean)beanContext.getProperty((Object)"server.allow_override_uri", Boolean.TYPE, (Object)false));
    }

    protected void registerComponents(EzyBeanContext beanContext) {
        HashSet controllers = new HashSet();
        controllers.addAll(beanContext.getSingletons(Controller.class));
        controllers.addAll(beanContext.getSingletonsOf(IRequestController.class));
        this.controllerManager.addControllers(controllers);
        List exceptionHandlers = beanContext.getSingletons(ExceptionHandler.class);
        this.exceptionHandlerManager.addExceptionHandlers(exceptionHandlers);
        List requestInterceptors = beanContext.getSingletons(Interceptor.class);
        requestInterceptors.sort(InterceptorAnnotations.comparator());
        this.interceptorManager.addRequestInterceptors(requestInterceptors);
        List bodyConverters = beanContext.getSingletons(BodyConvert.class);
        this.dataConverters.addBodyConverters(bodyConverters);
        List stringConverters = beanContext.getSingletons(StringConvert.class);
        List uncaughtErrorHandlers = beanContext.getSingletonsOf(UnhandledErrorHandler.class);
        List requestResponseWathcers = beanContext.getSingletonsOf(RequestResponseWatcher.class);
        this.dataConverters.setStringConverters(stringConverters);
        this.componentManager.setViewContext(this.buildViewContext(beanContext));
        this.componentManager.setServerPort(this.getServerPort(beanContext));
        this.componentManager.setExposeManagementURIs(this.isExposeManagementURIs(beanContext));
        this.componentManager.setManagementPort(this.getManagementPort(beanContext));
        this.componentManager.setAsyncDefaultTimeout(this.getAsyncDefaultTimeout(beanContext));
        this.componentManager.setUnhandledErrorHandler(uncaughtErrorHandlers);
        this.componentManager.addRequestResponseWatchers(requestResponseWathcers);
    }

    private int getServerPort(EzyBeanContext beanContext) {
        return (Integer)beanContext.getProperty((Object)"server.port", Integer.TYPE, (Object)0);
    }

    private boolean isExposeManagementURIs(EzyBeanContext beanContext) {
        return (Boolean)beanContext.getProperty((Object)"management.uris_expose", Boolean.TYPE, (Object)false);
    }

    private int getManagementPort(EzyBeanContext beanContext) {
        boolean managementEnable = (Boolean)beanContext.getProperty((Object)"management.enable", Boolean.TYPE, (Object)false);
        return managementEnable ? (Integer)beanContext.getProperty((Object)"management.port", Integer.TYPE, (Object)18080) : 0;
    }

    private int getAsyncDefaultTimeout(EzyBeanContext beanContext) {
        return (Integer)beanContext.getProperty((Object)"async.default_timeout", Integer.TYPE, (Object)0);
    }

    protected ViewContext buildViewContext(EzyBeanContext beanContext) {
        ViewContextBuilder viewContextBuilder;
        ViewContext viewContext = (ViewContext)beanContext.getSingleton(ViewContext.class);
        if (viewContext == null && (viewContextBuilder = (ViewContextBuilder)beanContext.getSingleton(ViewContextBuilder.class)) != null) {
            TemplateResolver templateResolver = (TemplateResolver)beanContext.getSingleton(TemplateResolver.class);
            if (templateResolver == null) {
                templateResolver = TemplateResolver.of((EzyPropertyFetcher)beanContext);
            }
            viewContext = (ViewContext)viewContextBuilder.templateResolver(templateResolver).viewDialects(beanContext.getSingletonsOf(ViewDialect.class)).viewDecorators(beanContext.getSingletonsOf(ViewDecorator.class)).messageProviders(beanContext.getSingletonsOf(MessageProvider.class)).absentMessageResolver((AbsentMessageResolver)beanContext.getSingleton(AbsentMessageResolver.class)).templateInputStreamLoaders(beanContext.getSingletonsOf(ViewTemplateInputStreamLoader.class)).build();
        }
        if (viewContext != null) {
            beanContext.getSingletonFactory().addSingleton((Object)viewContext);
        }
        return viewContext;
    }

    protected void addRequestHandlers(EzyBeanContext beanContext) {
        List<Object> controllerList = this.controllerManager.getControllers();
        RequestHandlersImplementer implementer = this.newRequestHandlersImplementer();
        implementer.setRequestURIDecorator((RequestURIDecorator)beanContext.getSingleton(RequestURIDecorator.class));
        Map<RequestURI, List<RequestHandler>> requestHandlers = implementer.implement(controllerList);
        this.requestHandlerManager.addHandlers(requestHandlers);
    }

    protected void addResourceRequestHandlers(EzyBeanContext beanContext) {
        ResourceResolver resourceResolver = this.getResourceResolver(beanContext);
        if (resourceResolver == null) {
            return;
        }
        ResourceDownloadManager downloadManager = (ResourceDownloadManager)beanContext.getSingleton(ResourceDownloadManager.class);
        Map<String, Resource> resources = resourceResolver.getResources();
        for (String resourceURI : resources.keySet()) {
            Resource resource = resources.get(resourceURI);
            RequestURI requestURI = new RequestURI(HttpMethod.GET, resourceURI, false, true, true, resource.getFullPath());
            ResourceRequestHandler requestHandler = new ResourceRequestHandler(resource.getPath(), resource.getUri(), resource.getExtension(), downloadManager);
            this.requestHandlerManager.addHandler(requestURI, requestHandler);
        }
    }

    protected ResourceResolver getResourceResolver(EzyBeanContext beanContext) {
        ResourceResolver resourceResolver = (ResourceResolver)beanContext.getSingleton(ResourceResolver.class);
        if (resourceResolver == null && (resourceResolver = ResourceResolvers.createResourceResolver((EzyPropertyFetcher)beanContext)) != null) {
            beanContext.getSingletonFactory().addSingleton((Object)resourceResolver);
        }
        return resourceResolver;
    }

    protected void addExceptionHandlers() {
        List<Object> exceptionHandlerList = this.exceptionHandlerManager.getExceptionHandlerList();
        ExceptionHandlersImplementer implementer = this.newExceptionHandlersImplementer();
        Map<Class<?>, UncaughtExceptionHandler> exceptionHandlers = implementer.implement(exceptionHandlerList);
        this.exceptionHandlerManager.addUncaughtExceptionHandlers(exceptionHandlers);
    }

    protected RequestHandlersImplementer newRequestHandlersImplementer() {
        return new RequestHandlersImplementer();
    }

    protected ExceptionHandlersImplementer newExceptionHandlersImplementer() {
        return new ExceptionHandlersImplementer();
    }
}

