/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminMediaControllerService;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminMediaValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.MediaStatus;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultMediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.request.AddMediaFromUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaIncludeUrlRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@Api
@Authenticated
@EzyFeature(value="media_management")
@Controller(value="/api/v1")
public class AdminApiMediaController {
    private final AdminAdminService adminService;
    private final AdminMediaControllerService mediaControllerService;
    private final AdminSettingService settingService;
    private final AdminMediaValidator mediaValidator;

    @Async
    @DoPost(value="/media/add")
    public void mediaAddPost(HttpServletRequest request, HttpServletResponse response, @AdminId long adminId, @RequestParam(value="avatar") boolean avatar, @RequestParam(value="notPublic") boolean notPublic) throws Exception {
        this.mediaControllerService.addMedia(request, response, UploadFrom.ADMIN.toString(), adminId, 0L, avatar, notPublic);
    }

    @Async
    @DoPost(value="/media/{id}/replace")
    public void mediaIdReplacePost(HttpServletRequest request, HttpServletResponse response, @AdminRoles AdminRolesProxy adminRoles, @AdminId long adminId, @PathVariable long mediaId) throws Exception {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        this.mediaControllerService.replaceMedia(request, response, mediaId, media -> allowAccessAllMedia || media.getOwnerAdminId() == adminId);
    }

    @DoPost(value="/media/add-from-url")
    public MediaModel mediaAddFromUrlPost(@AdminId long adminId, @RequestBody AddMediaFromUrlRequest request, @RequestParam(value="notPublic") boolean notPublic) {
        return this.mediaControllerService.addMedia(UploadFrom.ADMIN.toString(), adminId, 0L, request, notPublic);
    }

    @DoPut(value="/media/{id}")
    public ResponseEntity mediaIdPut(@AdminRoles AdminRolesProxy adminRoles, @AdminId long adminId, @PathVariable long mediaId, @RequestBody UpdateMediaIncludeUrlRequest request) {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        this.mediaControllerService.updateMedia(mediaId, request, media -> allowAccessAllMedia || media.getOwnerAdminId() == adminId);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/media/{id}")
    public ResponseEntity mediaMediaIdDelete(@AdminRoles AdminRolesProxy adminRoles, @AdminId long adminId, @PathVariable long mediaId) {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        if (!allowAccessAllMedia) {
            this.mediaValidator.validateOwnerAdminMedia(adminId, mediaId);
        }
        this.mediaControllerService.removeMediaById(mediaId, Boolean.TRUE);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/media/{id}/restore")
    public ResponseEntity mediaIdStatusPut(@AdminRoles AdminRolesProxy adminRoles, @AdminId long adminId, @PathVariable long mediaId) {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        if (!allowAccessAllMedia) {
            this.mediaValidator.validateOwnerAdminMedia(adminId, mediaId);
        }
        this.mediaControllerService.updateMediaStatus(mediaId, MediaStatus.ADDED.toString());
        return ResponseEntity.noContent();
    }

    @Async
    @DoGet(value="/media/{name}")
    public void mediaNameGet(RequestArguments requestArguments, @AdminRoles AdminRolesProxy adminRoles, @AdminId long adminId, @PathVariable String mediaName) throws Exception {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        this.mediaControllerService.getMediaByName(requestArguments, mediaName, Boolean.TRUE, media -> allowAccessAllMedia || media.getOwnerAdminId() == adminId);
    }

    @DoGet(value="/media/{id}/details")
    public AdminMediaDetailsResponse mediaIdDetailsGet(@AdminRoles AdminRolesProxy adminRoles, @AdminId long adminId, @PathVariable long mediaId) {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        return this.mediaControllerService.getAdminMediaDetailsById(mediaId, media -> allowAccessAllMedia || media.getOwnerAdminId() == adminId);
    }

    @DoGet(value="/media/list")
    public PaginationModel<MediaResponse> mediaListGet(@AdminId long adminId, @AdminRoles AdminRolesProxy adminRoles, @RequestParam(value="type") String type, @RequestParam(value="status") String status, @RequestParam(value="keyword") String keyword, @RequestParam(value="sortOrder") String sortOrder, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        boolean allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId, adminRoles);
        String trimedStatus = StringConverters.trimOrNull((String)status);
        String trimmedKeyword = StringConverters.trimOrNull((String)keyword);
        DefaultMediaFilter.Builder filterBuilder = DefaultMediaFilter.builder().type(StringConverters.trimOrNull((String)type)).status(trimedStatus).exclusiveStatus(trimedStatus == null ? MediaStatus.REMOVED.toString() : CommonConstants.NULL_STRING).allowSearchByLikeOperator(this.settingService.isAllowSearchMediaByLikeOperator()).prefixKeyword(trimmedKeyword).likeKeyword(trimmedKeyword);
        if (!allowAccessAllMedia) {
            filterBuilder.ownerAdminId(Long.valueOf(adminId));
        }
        return this.mediaControllerService.getMediaList((MediaFilter)filterBuilder.build(), sortOrder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @Generated
    public AdminApiMediaController(AdminAdminService adminService, AdminMediaControllerService mediaControllerService, AdminSettingService settingService, AdminMediaValidator mediaValidator) {
        this.adminService = adminService;
        this.mediaControllerService = mediaControllerService;
        this.settingService = settingService;
        this.mediaValidator = mediaValidator;
    }
}

