/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyAesCrypt;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminRequestToModelConverter;
import org.youngmonkeys.ezyplatform.admin.io.AdminPropertiesFileReader;
import org.youngmonkeys.ezyplatform.admin.io.AdminPropertiesFileWriter;
import org.youngmonkeys.ezyplatform.admin.io.AdminVmOptionsInteractor;
import org.youngmonkeys.ezyplatform.admin.mail.AdminNewPlatformMailScheduler;
import org.youngmonkeys.ezyplatform.admin.manager.AdminDataAppenderManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.model.SettingModel;
import org.youngmonkeys.ezyplatform.admin.pagination.AdminSettingFilter;
import org.youngmonkeys.ezyplatform.admin.request.AddSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddWebLanguageRequest;
import org.youngmonkeys.ezyplatform.admin.request.ChangeAccessTokenEncryptionKeyRequest;
import org.youngmonkeys.ezyplatform.admin.request.ChangeEncryptionKeyRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAccessTokenExpirationTimeRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAccessTokenHttpOnlyRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAdminLoginSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveAllowReloadDataAppenderSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveDateTimeFormatSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRegularSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveWebRegularSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveWebsiteSettingsRequest;
import org.youngmonkeys.ezyplatform.admin.request.SettingsDecryptionRequest;
import org.youngmonkeys.ezyplatform.admin.request.SettingsEncryptionRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAdminUrlRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdatePropertiesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateSettingRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateVmOptionsRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebLanguageRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebUrlsRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateWebsocketUrlRequest;
import org.youngmonkeys.ezyplatform.admin.response.AdminDataAppenderResponse;
import org.youngmonkeys.ezyplatform.admin.response.EncryptionKeyResponse;
import org.youngmonkeys.ezyplatform.admin.response.SettingResponse;
import org.youngmonkeys.ezyplatform.admin.response.SettingsDecryptionResponse;
import org.youngmonkeys.ezyplatform.admin.response.SettingsEncryptionResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminLanguageService;
import org.youngmonkeys.ezyplatform.admin.service.AdminPaginationSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminWebLanguageService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.admin.validator.AdminSettingsValidator;
import org.youngmonkeys.ezyplatform.entity.DataType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.WebLanguageModel;
import org.youngmonkeys.ezyplatform.pagination.PaginationModelFetchers;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.service.PaginationService;
import org.youngmonkeys.ezyplatform.util.StringConverters;
import org.youngmonkeys.ezyplatform.util.Strings;

@Api
@Authenticated
@EzyFeature(value="settings_management")
@Controller(value="/api/v1")
public class AdminApiSettingsController {
    private final AdminDataAppenderManager dataAppenderManager;
    private final AdminFileSystemManager fileSystemManager;
    private final AdminNewPlatformMailScheduler newPlatformMailScheduler;
    private final AdminPropertiesFileReader propertiesFileReader;
    private final AdminPropertiesFileWriter propertiesFileWriter;
    private final AdminVmOptionsInteractor vmOptionsInteractor;
    private final AdminLanguageService adminLanguageService;
    private final AdminSettingService settingService;
    private final AdminWebLanguageService webLanguageService;
    private final AdminPaginationSettingService paginationSettingService;
    private final AdminCommonValidator commonValidator;
    private final AdminSettingsValidator settingsValidator;
    private final AdminRequestToModelConverter requestToModelConverter;
    private final AdminModelToResponseConverter modelToResponseConverter;

    @DoGet(value="/settings")
    public PaginationModel<SettingResponse> settingsGet(@RequestParam(value="dataType") String dataType, @RequestParam(value="keyword") String keyword, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        AdminSettingFilter filter = ((AdminSettingFilter.Builder)((AdminSettingFilter.Builder)AdminSettingFilter.builder().dataType(StringConverters.trimOrNull((String)dataType))).likeKeyword(StringConverters.trimOrNull((String)keyword))).build();
        PaginationModel pagination = PaginationModelFetchers.getPaginationModel((PaginationService)this.paginationSettingService, (Object)((Object)filter), (String)nextPageToken, (String)prevPageToken, (boolean)lastPage, (int)limit);
        return pagination.map(this.modelToResponseConverter::toResponse);
    }

    @DoPost(value="/settings/add")
    public SettingResponse settingsAddPost(@RequestBody AddSettingRequest request) {
        this.settingsValidator.validate(request);
        SettingModel settingModel = this.settingService.addNewSetting(this.requestToModelConverter.toModel(request));
        if (request.isChangeLastUpdateTime()) {
            this.settingService.setLastUpdateTime(request.getName());
        }
        return this.modelToResponseConverter.toResponse(settingModel);
    }

    @DoPut(value="/settings/{id}")
    public ResponseEntity settingsIdUpdatePut(@PathVariable long settingId, @RequestBody UpdateSettingRequest request) {
        this.settingsValidator.validate(request);
        if (!DataType.PASSWORD.equalsValue(request.getDataType()) || EzyStrings.isBlank((String)request.getValue()) || !request.getValue().matches("[*]+")) {
            this.settingService.saveSetting(this.requestToModelConverter.toModel(settingId, request));
            if (request.isChangeLastUpdateTime()) {
                this.settingService.setLastUpdateTime(request.getName());
            }
        }
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/settings/{id}")
    public ResponseEntity settingsIdDelete(@PathVariable long settingId) {
        this.commonValidator.validateId("setting", settingId);
        this.settingService.removeSetting(settingId);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/settings/names/{name}")
    public ResponseEntity settingsNamesNameDelete(@PathVariable String settingName) {
        this.settingService.removeSetting(settingName);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/regular")
    public ResponseEntity settingsRegularPut(@RequestBody SaveRegularSettingsRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setNodeName(request.getEzyplatformNodeName());
        this.adminLanguageService.setDefaultLanguageCode(request.getDefaultAdminLanguage());
        this.settingService.setAdminAllowSearchUserByLikeOperator(request.isAllowSearchUserByLikeOperator());
        this.settingService.setAdminAllowSearchMediaByLikeOperator(request.isAllowSearchMediaByLikeOperator());
        this.settingService.saveRegularSettings(this.requestToModelConverter.toModel(request));
        this.settingService.setNumberOfMediaPerPage(request.getNumberOfMediaPerPage());
        this.settingService.setPaginationCountLimit(request.getPaginationCountLimit());
        this.newPlatformMailScheduler.setScheduleType(request.getNewPlatformMailScheduleType());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/admin-login")
    public ResponseEntity settingsAdminLoginPut(@RequestBody SaveAdminLoginSettingsRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.saveAdminLoginSettings(this.requestToModelConverter.toModel(request));
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/admin-access-token-expiration-time")
    public ResponseEntity settingsAdminAccessTokenExpirationTimePut(@RequestBody SaveAccessTokenExpirationTimeRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setLongValue("admin_token_expired_in_day", request.getTokenExpiredTimeInDay());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/admin-access-token-http-only")
    public ResponseEntity settingsAdminAccessTokenHttpOnlyPut(@RequestBody SaveAccessTokenHttpOnlyRequest request) {
        this.settingService.setBooleanValue("admin_access_token_http_only", request.isHttpOnly());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/user-access-token-expiration-time")
    public ResponseEntity settingsUserAccessTokenExpirationTimePut(@RequestBody SaveAccessTokenExpirationTimeRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setLongValue("user_token_expired_in_day", request.getTokenExpiredTimeInDay());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/user-access-token-http-only")
    public ResponseEntity settingsUserAccessTokenHttpOnlyPut(@RequestBody SaveAccessTokenHttpOnlyRequest request) {
        this.settingService.setBooleanValue("user_access_token_http_only", request.isHttpOnly());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/admin-datetime-formats")
    public ResponseEntity settingsAdminDateTimeFormatsPut(@RequestBody SaveDateTimeFormatSettingsRequest request) {
        this.settingService.setAdminDateFormat(request.getDateFormat());
        this.settingService.setAdminTimeFormat(request.getTimeFormat());
        this.settingService.setAdminDateTimeFormat(request.getDateTimeFormat());
        this.settingService.setAdminDateMinuteFormat(request.getDateMinuteFormat());
        this.settingService.setLastUpdateTime("admin_datetime_format");
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/allow-reload-data-appender")
    public ResponseEntity settingsAllowReloadAppenders(@RequestBody SaveAllowReloadDataAppenderSettingRequest request) {
        this.settingService.setAllowReloadDataAppender(request.isAllowReloadDataAppender());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/website")
    public ResponseEntity settingsWebsitePut(@RequestBody SaveWebsiteSettingsRequest request) {
        this.settingsValidator.validate(request);
        Reactive.multiple().registerOperation(() -> this.settingService.setTextValue("web_site_name", request.getWebsiteName())).registerOperation(() -> this.settingService.setTextValue("web_site_title", request.getWebsiteTitle())).registerOperation(() -> this.settingService.setTextValue("web_page_title_separator", request.getPageTitleSeparator())).registerOperation(() -> this.settingService.setTextValue("web_site_tagline", request.getWebsiteTagLine())).blockingExecute();
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/website/regular")
    public ResponseEntity settingsWebsiteRegularPut(@RequestBody SaveWebRegularSettingsRequest request) {
        this.settingService.setWebAllowSearchUserByLikeOperator(request.isAllowSearchUserByLikeOperator());
        this.settingService.setWebAllowSearchMediaByLikeOperator(request.isAllowSearchMediaByLikeOperator());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/web-datetime-formats")
    public ResponseEntity settingsWebDateTimeFormatsPut(@RequestBody SaveDateTimeFormatSettingsRequest request) {
        this.settingService.setWebDateFormat(request.getDateFormat());
        this.settingService.setWebTimeFormat(request.getTimeFormat());
        this.settingService.setWebDateTimeFormat(request.getDateTimeFormat());
        this.settingService.setWebDateMinuteFormat(request.getDateMinuteFormat());
        this.settingService.setLastUpdateTime("web_datetime_format");
        return ResponseEntity.noContent();
    }

    @DoPost(value="/web-languages/add")
    public ResponseEntity webLanguagesAddPost(@RequestBody AddWebLanguageRequest request) {
        Map languageModelMap = this.webLanguageService.getLanguageMap();
        this.settingsValidator.validate(languageModelMap, request);
        ArrayList<WebLanguageModel> languages = new ArrayList<WebLanguageModel>(languageModelMap.values());
        languages.add(this.requestToModelConverter.toModel(request));
        Collections.sort(languages);
        this.webLanguageService.saveWebLanguages(languages);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/web-languages/{code}")
    public ResponseEntity webLanguagesCodePut(@PathVariable String code, @RequestBody UpdateWebLanguageRequest request) {
        String defaultCode;
        Map languageModelMap = this.webLanguageService.getLanguageMap();
        this.settingsValidator.validate(languageModelMap, code, request);
        if (!request.isEditWebLanguageActive() && code.equals(defaultCode = this.webLanguageService.getDefaultLanguageCode())) {
            this.webLanguageService.resetDefaultLanguageCode();
        }
        ArrayList<WebLanguageModel> languages = new ArrayList<WebLanguageModel>();
        for (String languageCode : languageModelMap.keySet()) {
            WebLanguageModel language = languageCode.equals(code) ? this.requestToModelConverter.toModel(code, request) : (WebLanguageModel)languageModelMap.get(languageCode);
            languages.add(language);
        }
        Collections.sort(languages);
        this.webLanguageService.saveWebLanguages(languages);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/web-languages/{code}")
    public ResponseEntity webLanguagesCodePut(@PathVariable String code) {
        Map languageModelMap = this.webLanguageService.getLanguageMap();
        if (!languageModelMap.containsKey(code)) {
            throw new HttpNotFoundException(Collections.singletonMap("webLanguage", "notFound"));
        }
        String defaultCode = this.webLanguageService.getDefaultLanguageCode();
        if (code.equals(defaultCode)) {
            this.webLanguageService.resetDefaultLanguageCode();
        }
        List languages = EzyLists.filter(languageModelMap.values(), it -> !it.getCode().equals(code));
        Collections.sort(languages);
        this.webLanguageService.saveWebLanguages(languages);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/web-languages/{code}/set-as-default")
    public ResponseEntity webLanguagesCodeSetAsDefaultPut(@PathVariable String code) {
        WebLanguageModel language = this.webLanguageService.getLanguageByCode(code);
        if (language == null) {
            throw new HttpNotFoundException(Collections.singletonMap("webLanguage", "notFound"));
        }
        if (!language.isActive()) {
            throw new HttpBadRequestException(Collections.singletonMap("webLanguage", "inactive"));
        }
        this.webLanguageService.setDefaultLanguageCode(code);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-admin-url")
    public ResponseEntity settingsSetAdminUrlPut(@RequestBody UpdateAdminUrlRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setAdminUrl(request.getAdminUrl());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-admin-properties")
    public ResponseEntity settingsSetAdminPropertiesPut(@RequestBody UpdatePropertiesRequest request) {
        this.settingsValidator.validate(request, false);
        this.propertiesFileWriter.writeAdminConfigToFile(request.getProperties());
        return ResponseEntity.noContent();
    }

    @DoGet(value="/settings/socket-properties")
    public ResponseEntity settingsSetSocketPropertiesGet() {
        return ResponseEntity.builder().contentType("text/plain").body((Object)this.propertiesFileReader.readSocketConfigContent()).build();
    }

    @DoPut(value="/settings/set-socket-properties")
    public ResponseEntity settingsSetSocketPropertiesPut(@RequestBody UpdatePropertiesRequest request) {
        this.settingsValidator.validate(request, true);
        this.propertiesFileWriter.writeSocketConfigToFile(request.getProperties());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-websocket-url")
    public ResponseEntity settingsSetWebsocketUrlPut(@RequestBody UpdateWebsocketUrlRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setWebSocketUrl(request.getWebsocketUrl());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-socket-ssl-configuration")
    public ResponseEntity settingsSocketSslConfigurationPut(HttpServletRequest request, @RequestParam(value="enableWebsocketSsl", defaultValue="false") boolean enableWebsocketSsl, @RequestParam(value="allowSslToReloadAutomatically", defaultValue="true") boolean allowSslToReloadAutomatically, @RequestParam(value="sslCertificatePassword", defaultValue="") String sslCertificatePassword, @RequestParam(value="sslKeystorePassword", defaultValue="") String sslKeystorePassword) throws Exception {
        Part part;
        this.propertiesFileWriter.setSocketConfigToFile(EzyMapBuilder.mapBuilder().put((Object)"websocket.ssl.enable", (Object)enableWebsocketSsl).toMap());
        this.settingService.setBooleanValue("socket_auto_reload_ssl_enable", allowSslToReloadAutomatically);
        Path sslFolderPath = this.fileSystemManager.concatWithEzyHome(Paths.get(TargetType.SOCKET.getName(), "settings", "ssl")).toPath();
        if (!sslCertificatePassword.matches("[*]+")) {
            Path sslCertificatePasswordFilePath = sslFolderPath.resolve("ssl-certificate-password.txt");
            FolderProxy.createNewFile((File)sslCertificatePasswordFilePath.toFile());
            Files.write(sslCertificatePasswordFilePath, sslCertificatePassword.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        if (!sslKeystorePassword.matches("[*]+")) {
            Path sslKeystorePasswordFilePath = sslFolderPath.resolve("ssl-keystore-password.txt");
            FolderProxy.createNewFile((File)sslKeystorePasswordFilePath.toFile());
            Files.write(sslKeystorePasswordFilePath, sslKeystorePassword.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        if ((part = request.getPart("sslKeystoreFile")) != null && part.getSize() > 0L) {
            Path sslKeystoreFilePath = sslFolderPath.resolve("ssl-keystore.txt");
            FolderProxy.createNewFile((File)sslKeystoreFilePath.toFile());
            Files.copy(part.getInputStream(), sslKeystoreFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-web-urls")
    public ResponseEntity settingsSetWebUrlsPut(@RequestBody UpdateWebUrlsRequest request) {
        this.settingsValidator.validate(request);
        Reactive.multiple().registerOperation((Object)"webUrl", () -> this.settingService.setWebUrl(request.getWebUrl())).registerOperation((Object)"webManagementUrl", () -> this.settingService.setWebManagementUrl(request.getWebManagementUrl())).blockingExecute();
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-web-properties")
    public ResponseEntity settingsSetWebPropertiesPut(@RequestBody UpdatePropertiesRequest request) {
        this.settingsValidator.validate(request, false);
        this.propertiesFileWriter.writeWebConfigToFile(request.getProperties());
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/set-admin-vm-options")
    public ResponseEntity settingsSetAdminVmOptionsPut(@RequestBody UpdateVmOptionsRequest request) throws IOException {
        return this.setTargetVmOptions(TargetType.ADMIN, request);
    }

    @DoPut(value="/settings/set-socket-vm-options")
    public ResponseEntity settingsSetSocketVmOptionsPut(@RequestBody UpdateVmOptionsRequest request) throws IOException {
        return this.setTargetVmOptions(TargetType.SOCKET, request);
    }

    @DoPut(value="/settings/set-web-vm-options")
    public ResponseEntity settingsSetWebVmOptionsPut(@RequestBody UpdateVmOptionsRequest request) throws IOException {
        return this.setTargetVmOptions(TargetType.WEB, request);
    }

    private ResponseEntity setTargetVmOptions(TargetType targetType, UpdateVmOptionsRequest request) throws IOException {
        this.vmOptionsInteractor.saveVmOptions(targetType, Strings.emptyIfNull((String)request.getVmOptions()).trim());
        return ResponseEntity.noContent();
    }

    @DoGet(value="/settings/encryption-key")
    public EncryptionKeyResponse settingsEncryptionKeyGet() {
        return new EncryptionKeyResponse(this.settingService.getEncryptionKey());
    }

    @DoPut(value="/settings/change-encryption-key")
    public ResponseEntity settingsChangeEncryptionKeyPut(@RequestBody ChangeEncryptionKeyRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.changeEncryptionKey(request.getNewEncryptionKey(), request.isReEncryptAllPasswords());
        return ResponseEntity.noContent();
    }

    @DoPost(value="/settings/encrypt")
    public SettingsEncryptionResponse settingsEncryptPost(@RequestBody SettingsEncryptionRequest request) {
        this.settingsValidator.validate(request);
        return new SettingsEncryptionResponse(this.settingService.encryptValue(request.getEncryptionClearText()));
    }

    @DoPost(value="/settings/decrypt")
    public SettingsDecryptionResponse settingsDecryptPost(@RequestBody SettingsDecryptionRequest request) {
        this.settingsValidator.validate(request);
        return new SettingsDecryptionResponse(this.settingService.decryptValue(request.getDecryptionEncryptedText()));
    }

    @DoPost(value="/settings/random-aes-key")
    public EncryptionKeyResponse settingsRandomAesKeyPost() throws Exception {
        return new EncryptionKeyResponse(EzyBase64.encode2utf((byte[])EzyAesCrypt.randomKey()));
    }

    @DoGet(value="/settings/admin-access-token-encryption-key")
    public EncryptionKeyResponse settingsAdminAccessTokenEncryptionKeyGet() {
        return new EncryptionKeyResponse(this.settingService.getPasswordValue("admin_access_token_encryption_key"));
    }

    @DoPut(value="/settings/admin-access-token-encryption-key")
    public ResponseEntity settingsAdminAccessTokenEncryptionKeyPut(@RequestBody ChangeAccessTokenEncryptionKeyRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setPasswordValue("admin_access_token_encryption_key", request.getNewEncryptionKey());
        this.settingService.setLastUpdateTime("admin_access_token_encryption_key");
        return ResponseEntity.noContent();
    }

    @DoGet(value="/settings/user-access-token-encryption-key")
    public EncryptionKeyResponse settingsUserAccessTokenEncryptionKeyGet() {
        return new EncryptionKeyResponse(this.settingService.getPasswordValue("user_access_token_encryption_key"));
    }

    @DoPut(value="/settings/user-access-token-encryption-key")
    public ResponseEntity settingsUserAccessTokenEncryptionKeyPut(@RequestBody ChangeAccessTokenEncryptionKeyRequest request) {
        this.settingsValidator.validate(request);
        this.settingService.setPasswordValue("user_access_token_encryption_key", request.getNewEncryptionKey());
        this.settingService.setLastUpdateTime("user_access_token_encryption_key");
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/admin-sso-allowed-origins")
    public ResponseEntity settingsAdminSsoAllowedOriginsPut(@RequestBody Map<String, String> origins) {
        this.settingService.setAdminSsoAllowedOrigins(origins);
        return ResponseEntity.noContent();
    }

    @DoGet(value="/settings/data-appenders")
    public List<AdminDataAppenderResponse> settingsDataAppendersGet() {
        return this.dataAppenderManager.getSortedDataAppenderNames().stream().map(this.dataAppenderManager::getDataAppenderByName).map(it -> AdminDataAppenderResponse.builder().name(it.getName()).started(it.isStarted()).runnable(it.isRunnable()).build()).collect(Collectors.toList());
    }

    @DoPut(value="/settings/data-appenders/{name}/start")
    public ResponseEntity settingsDataAppendersNameStartPut(@PathVariable String dataAppenderName) {
        this.dataAppenderManager.startDataAppender(dataAppenderName);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/data-appenders/{name}/stop")
    public ResponseEntity settingsDataAppendersNameStopPut(@PathVariable String dataAppenderName) {
        this.dataAppenderManager.stopDataAppender(dataAppenderName);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/data-appenders/{name}/restart")
    public ResponseEntity settingsDataAppendersNameRestartPut(@PathVariable String dataAppenderName) {
        this.dataAppenderManager.restartDataAppender(dataAppenderName);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/settings/data-appenders/{name}/reload")
    public ResponseEntity settingsDataAppenderNameReloadPost(@PathVariable String dataAppenderName) {
        if (this.settingService.isAllowReloadDataAppender()) {
            this.dataAppenderManager.reloadDataAppender(dataAppenderName);
        }
        return ResponseEntity.noContent();
    }

    @Generated
    public AdminApiSettingsController(AdminDataAppenderManager dataAppenderManager, AdminFileSystemManager fileSystemManager, AdminNewPlatformMailScheduler newPlatformMailScheduler, AdminPropertiesFileReader propertiesFileReader, AdminPropertiesFileWriter propertiesFileWriter, AdminVmOptionsInteractor vmOptionsInteractor, AdminLanguageService adminLanguageService, AdminSettingService settingService, AdminWebLanguageService webLanguageService, AdminPaginationSettingService paginationSettingService, AdminCommonValidator commonValidator, AdminSettingsValidator settingsValidator, AdminRequestToModelConverter requestToModelConverter, AdminModelToResponseConverter modelToResponseConverter) {
        this.dataAppenderManager = dataAppenderManager;
        this.fileSystemManager = fileSystemManager;
        this.newPlatformMailScheduler = newPlatformMailScheduler;
        this.propertiesFileReader = propertiesFileReader;
        this.propertiesFileWriter = propertiesFileWriter;
        this.vmOptionsInteractor = vmOptionsInteractor;
        this.adminLanguageService = adminLanguageService;
        this.settingService = settingService;
        this.webLanguageService = webLanguageService;
        this.paginationSettingService = paginationSettingService;
        this.commonValidator = commonValidator;
        this.settingsValidator = settingsValidator;
        this.requestToModelConverter = requestToModelConverter;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

