/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.RequestCookie;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.annotation.TryCatch;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import com.tvd12.ezyhttp.server.core.view.View;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.decorator.AdminLoginResponseDecorators;
import org.youngmonkeys.ezyplatform.admin.exception.AdminAuthenticationException;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminAuthenticationValidator;
import org.youngmonkeys.ezyplatform.admin.view.AdminViews;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.entity.AccessTokenStatus;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.util.HttpRequests;

@Controller
public class AdminAuthenticationController
extends EzyLoggable {
    private final AdminAdminService adminService;
    private final AdminSettingService settingService;
    private final AdminAuthenticationValidator authenticationValidator;

    @DoGet(value="/sso-web")
    public Redirect ssoWebGet(@RequestParam(value="callbackUrl") String callbackUrl) {
        String webUrl;
        String webCallbackUrl = webUrl = this.settingService.getWebUrl();
        if (EzyStrings.isNotBlank((String)webUrl)) {
            webCallbackUrl = webUrl + callbackUrl;
        }
        return Redirect.builder().uri("/sso-login").addAttribute("ssoCallbackUrl", (Object)webCallbackUrl).build();
    }

    @DoGet(value="/sso-login")
    public Object ssoLoginGet(HttpServletRequest request, RequestArguments arguments) {
        String callbackUrl = (String)arguments.getRedirectionAttribute("ssoCallbackUrl", (Object)"");
        String accessToken = arguments.getCookieValue("adminAccessToken");
        if (EzyStrings.isBlank((String)accessToken)) {
            accessToken = arguments.getCookieValue("sharedAdminAccessToken");
        }
        if (EzyStrings.isBlank((String)accessToken)) {
            return this.doLoginGet(request, arguments, callbackUrl);
        }
        try {
            AdminAccessTokenModel accessTokenModel = this.adminService.getAdminAccessTokenOrThrowByAccessToken(accessToken);
            return this.toRedirect(request, accessTokenModel, callbackUrl);
        }
        catch (Exception e) {
            this.logger.info("sso login validate access token failed", (Throwable)e);
            return this.doLoginGet(request, arguments, callbackUrl);
        }
    }

    @DoGet(value="/login")
    public View loginGet(HttpServletRequest request, RequestArguments arguments) {
        String callbackUri = (String)arguments.getRedirectionAttribute("callbackUri", (Object)"");
        return this.doLoginGet(request, arguments, callbackUri);
    }

    protected View doLoginGet(HttpServletRequest request, RequestArguments arguments, String ssoCallbackUrl) {
        String lang = HttpRequests.getLanguage((HttpServletRequest)request);
        Map errors = (Map)arguments.getRedirectionAttribute("errors");
        boolean istNotFoundUri = Objects.equals(ssoCallbackUrl, "/not-found");
        String actualCallbackUrl = istNotFoundUri ? "/" : ssoCallbackUrl;
        Cookie callbackUrlCookie = new Cookie("adminSSOCallbackUrl", actualCallbackUrl);
        callbackUrlCookie.setPath("/");
        callbackUrlCookie.setMaxAge(300);
        return View.builder().template("authen/login").addVariable("errors", (Object)errors).addVariable("ezyLang", (Object)lang).addVariable("fillUsername", (Object)arguments.getParameter("fillUsername")).addVariable("fillPassword", (Object)arguments.getParameter("fillPassword")).addCookie(callbackUrlCookie).build();
    }

    @DoPost(value="/login")
    public Redirect doPost(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestCookie(value="adminSSOCallbackUrl") String ssoCallbackUrl) throws Exception {
        AdminModel admin = this.authenticationValidator.validate(username, password);
        AdminAccessTokenModel accessToken = this.adminService.getOrCreateAccessTokenByAdminId(admin.getId());
        return this.toRedirect(request, accessToken, ssoCallbackUrl);
    }

    @Authenticated
    @DoPost(value="/logout")
    public Redirect logoutPost(HttpServletRequest request, @AdminId long adminId) {
        this.adminService.removeAdminAccessToken(adminId);
        return AdminViews.redirectToLogin((HttpServletRequest)request, (boolean)Boolean.FALSE);
    }

    private Redirect toRedirect(HttpServletRequest request, AdminAccessTokenModel accessToken, String ssoCallbackUrl) throws Exception {
        String uri;
        Cookie tokenCookie = null;
        Cookie tokenCookieExpiredAt = null;
        if (EzyStrings.isBlank((String)ssoCallbackUrl)) {
            String tokenStatus = accessToken.getStatus();
            String uriPrefix = AccessTokenStatus.WAITING_2FA.equalsValue(tokenStatus) ? "/2fa" : "/";
            uri = HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)uriPrefix);
        } else if (ssoCallbackUrl.startsWith("http://") || ssoCallbackUrl.startsWith("https://")) {
            String cookieDomain = this.getCookieDomain(ssoCallbackUrl);
            tokenCookie = AdminLoginResponseDecorators.newAccessTokenCookie("sharedAdminAccessToken", accessToken);
            tokenCookieExpiredAt = AdminLoginResponseDecorators.newAccessTokenExpiredAtCookie("sharedAdminAccessTokenExpiredAt", accessToken);
            tokenCookie.setDomain(cookieDomain);
            tokenCookieExpiredAt.setDomain(cookieDomain);
            uri = ssoCallbackUrl;
        } else {
            uri = ssoCallbackUrl;
        }
        if (tokenCookie == null) {
            tokenCookie = AdminLoginResponseDecorators.newAccessTokenCookie("adminAccessToken", accessToken);
        }
        if (tokenCookieExpiredAt == null) {
            tokenCookieExpiredAt = AdminLoginResponseDecorators.newAccessTokenExpiredAtCookie("adminAccessTokenExpiredAt", accessToken);
        }
        boolean httpOnly = this.settingService.isAdminAccessTokenHttpOnly();
        tokenCookie.setHttpOnly(httpOnly);
        tokenCookieExpiredAt.setHttpOnly(httpOnly);
        return Redirect.builder().uri(uri).addCookie(tokenCookie).addCookie(tokenCookieExpiredAt).build();
    }

    private String getCookieDomain(String ssoCallbackUrl) throws MalformedURLException {
        URL callbackUrl = new URL(ssoCallbackUrl);
        String callbackHost = callbackUrl.getHost();
        Map<String, String> originByCookieDomain = this.settingService.getAdminSsoAllowedOrigins();
        String cookieDomain = originByCookieDomain.get(callbackHost);
        if (EzyStrings.isBlank((String)cookieDomain)) {
            throw new HttpForbiddenException(Collections.singletonMap("origin", "nowAllowed"));
        }
        return cookieDomain;
    }

    @TryCatch(value={AdminAuthenticationException.class})
    public Redirect handle(HttpServletRequest request, AdminAuthenticationException exception) {
        this.logger.info("{}", (Object)exception.getMessage());
        return Redirect.builder().uri(HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/login")).addAttribute("errors", exception.getErrors()).build();
    }

    @Generated
    public AdminAuthenticationController(AdminAdminService adminService, AdminSettingService settingService, AdminAuthenticationValidator authenticationValidator) {
        this.adminService = adminService;
        this.settingService = settingService;
        this.authenticationValidator = authenticationValidator;
    }
}

