/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.Next;
import com.tvd12.ezyhttp.server.core.annotation.Service;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.converter.AdminEntityToModelConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.repo.AdminNotificationReceiverRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminNotificationRepository;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.Notification;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.entity.NotificationStatus;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.model.NotificationModel;
import org.youngmonkeys.ezyplatform.repo.NotificationReceiverRepository;
import org.youngmonkeys.ezyplatform.repo.NotificationRepository;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.service.DefaultNotificationService;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

@Service
public class AdminNotificationService
extends DefaultNotificationService {
    private final ClockProxy clock;
    private final AdminNotificationRepository notificationRepository;
    private final AdminNotificationReceiverRepository notificationReceiverRepository;
    private final AdminEntityToModelConverter entityToModelConverter;

    public AdminNotificationService(ClockProxy clock, AdminNotificationRepository notificationRepository, AdminNotificationReceiverRepository notificationReceiverRepository, AdminEntityToModelConverter entityToModelConverter, AdminModelToEntityConverter modelToEntityConverter) {
        super((NotificationRepository)notificationRepository, (NotificationReceiverRepository)notificationReceiverRepository, (DefaultEntityToModelConverter)entityToModelConverter, (DefaultModelToEntityConverter)modelToEntityConverter);
        this.clock = clock;
        this.notificationRepository = notificationRepository;
        this.notificationReceiverRepository = notificationReceiverRepository;
        this.entityToModelConverter = entityToModelConverter;
    }

    public void updateAdminNotificationByReceive(long adminId, long notificationId) {
        this.updateAdminNotificationByReceive(adminId, notificationId, Boolean.TRUE);
    }

    public void updateAdminNotificationByReceive(long adminId, long notificationId, boolean throwExceptionIfNotExists) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToAdminId(notificationId, adminId);
        if (notificationReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("notification");
            }
            return;
        }
        if (notificationReceiver.getReceivedAt() == null) {
            notificationReceiver.setReceivedAt(this.clock.nowDateTime());
            notificationReceiver.setStatus(NotificationStatus.RECEIVED.toString());
            this.notificationReceiverRepository.save(notificationReceiver);
        }
    }

    public void updateAdminNotificationsByReceive(long adminId, Collection<Long> notificationIds) {
        Reactive.multiple().registerConsumers(notificationIds, it -> this.updateAdminNotificationByRead(adminId, (long)it, Boolean.FALSE)).blockingExecute();
    }

    public void updateAdminNotificationByRead(long adminId, long notificationId) {
        this.updateAdminNotificationByRead(adminId, notificationId, Boolean.TRUE);
    }

    public void updateAdminNotificationByRead(long adminId, long notificationId, boolean throwExceptionIfNotExists) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToAdminId(notificationId, adminId);
        if (notificationReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("notification");
            }
            return;
        }
        this.doUpdateAdminNotificationByRead(notificationReceiver);
    }

    public void updateAdminNotificationsByRead(long adminId, Collection<Long> notificationIds) {
        Reactive.multiple().registerConsumers(notificationIds, it -> this.updateAdminNotificationByRead(adminId, (long)it, Boolean.FALSE)).blockingExecute();
    }

    public void updateAllAdminNotificationsByRead(long adminId) {
        long limit = 100L;
        long notificationIdExclusive = Long.MAX_VALUE;
        while (true) {
            List<NotificationReceiver> entities = this.notificationReceiverRepository.findUnreadNotificationsByToAdminId(adminId, notificationIdExclusive, Next.limit((long)limit));
            Reactive.multiple().registerConsumers(entities, this::doUpdateAdminNotificationByRead).blockingExecute();
            if ((long)entities.size() < limit) break;
            notificationIdExclusive = ((NotificationReceiver)EzyLists.last(entities)).getNotificationId();
        }
    }

    public void deleteAdminNotification(long adminId, long notificationId) {
        this.deleteAdminNotification(adminId, notificationId, Boolean.TRUE);
    }

    public void deleteAdminNotification(long adminId, long notificationId, boolean throwExceptionIfNotExists) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToAdminId(notificationId, adminId);
        if (notificationReceiver == null) {
            if (throwExceptionIfNotExists) {
                throw new ResourceNotFoundException("notification");
            }
            return;
        }
        this.notificationReceiverRepository.delete(notificationReceiver.getId());
    }

    public void deleteAdminNotifications(long adminId, Collection<Long> notificationIds) {
        Reactive.multiple().registerConsumers(notificationIds, it -> this.deleteAdminNotification(adminId, (long)it, Boolean.FALSE)).blockingExecute();
    }

    public NotificationModel getAdminNotification(long adminId, long notificationId) {
        NotificationReceiver notificationReceiver = this.notificationReceiverRepository.findByNotificationIdAndToAdminId(notificationId, adminId);
        if (notificationReceiver == null) {
            return null;
        }
        Notification notification = (Notification)this.notificationRepository.findById(notificationId);
        if (notification == null) {
            return null;
        }
        return this.entityToModelConverter.toModel(notification, notificationReceiver, Boolean.TRUE);
    }

    public long countAdminUnreadNotifications(long adminId) {
        return this.notificationReceiverRepository.countUnreadNotificationsByToAdminId(adminId);
    }

    private void doUpdateAdminNotificationByRead(NotificationReceiver notificationReceiver) {
        if (notificationReceiver.getReadAt() == null) {
            LocalDateTime now = this.clock.nowDateTime();
            if (notificationReceiver.getReceivedAt() == null) {
                notificationReceiver.setReceivedAt(now);
            }
            notificationReceiver.setReadAt(now);
            notificationReceiver.setStatus(NotificationStatus.READ.toString());
            this.notificationReceiverRepository.save(notificationReceiver);
        }
    }
}

