/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.wrapper;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.pattern.EzyObjectProvider;
import com.tvd12.ezyfox.util.EzyTimes;
import com.tvd12.ezyfoxserver.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.entity.EzyAbstractSession;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.exception.EzyMaxSessionException;
import com.tvd12.ezyfoxserver.service.EzySessionTokenGenerator;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EzySimpleSessionManager<S extends EzySession>
extends EzyObjectProvider<S>
implements EzySessionManager<S> {
    protected final int maxSessions;
    protected final EzySessionTokenGenerator tokenGenerator;
    protected final ConcurrentHashMap<Long, S> loggedInSession = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Long, S> sessionsById = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Object, S> sessionsByConnection = new ConcurrentHashMap();
    protected static final AtomicInteger COUNTER = new AtomicInteger(0);

    protected EzySimpleSessionManager(Builder<S> builder) {
        super(builder);
        this.maxSessions = builder.maxSessions;
        this.tokenGenerator = builder.tokenGenerator;
    }

    @Override
    public void addLoggedInSession(S session) {
        this.loggedInSession.put(session.getId(), session);
    }

    @Override
    public boolean containsSession(long id) {
        return this.sessionsById.containsKey(id);
    }

    @Override
    public void removeSession(S session, EzyConstant reason) {
        this.checkToRemoveSession(session, reason);
    }

    @Override
    public void clearSession(S session) {
        if (session != null) {
            this.unmapSession(session);
            this.logger.info(this.getRemoveSessionMessage(session));
        }
    }

    private String getRemoveSessionMessage(S session) {
        return "remove session: " + session.getName() + ", remain sessions = " + this.providedObjects.size() + ", login sessions = " + this.loggedInSession.size() + ", sessions by id = " + this.sessionsById.size() + ", sessions by connection = " + this.sessionsByConnection.size();
    }

    protected void checkToRemoveSession(S session, EzyConstant reason) {
        if (this.shouldRemoveSession(session)) {
            session.disconnect(reason);
        }
    }

    protected boolean shouldRemoveSession(S session) {
        if (session == null) {
            return false;
        }
        return this.containsSession(session.getId());
    }

    protected void unmapSession(S session) {
        this.providedObjects.remove(session);
        this.sessionsById.remove(session.getId());
        this.loggedInSession.remove(session.getId());
        EzyChannel channel = session.getChannel();
        Object connection = channel.getConnection();
        this.sessionsByConnection.remove(connection);
    }

    @Override
    public S provideSession(EzyChannel channel) {
        S ss = this.provideSession(channel.getConnectionType());
        ss.setChannel(channel);
        this.sessionsByConnection.put(channel.getConnection(), ss);
        this.logger.info("provide session: {}, sessions size = {}", (Object)ss.getName(), (Object)this.providedObjects.size());
        return ss;
    }

    protected S provideSession(EzyConstant connectionType) {
        this.checkMaxSessions();
        EzyAbstractSession session = (EzyAbstractSession)this.provideObject();
        session.setLoggedIn(false);
        session.setName("Session#" + COUNTER.incrementAndGet());
        session.setConnectionType(connectionType);
        session.setToken(this.newSessionToken());
        session.setCreationTime(System.currentTimeMillis());
        session.setCreationTime(System.currentTimeMillis());
        session.setLastActivityTime(System.currentTimeMillis());
        session.setLastReadTime(System.currentTimeMillis());
        session.setLastWriteTime(System.currentTimeMillis());
        EzyAbstractSession complete = session;
        this.sessionsById.put(complete.getId(), complete);
        return (S)complete;
    }

    protected void checkMaxSessions() {
        int current = this.providedObjects.size();
        if (current >= this.maxSessions) {
            throw new EzyMaxSessionException(current, this.maxSessions);
        }
    }

    @Override
    public EzySession getSession(long id) {
        return (EzySession)this.sessionsById.get(id);
    }

    @Override
    public S getSession(Object connection) {
        return (S)((EzySession)this.sessionsByConnection.get(connection));
    }

    @Override
    public List<S> getAllSessions() {
        return this.getProvidedObjects();
    }

    @Override
    public List<S> getAliveSessions() {
        return new ArrayList<S>(this.sessionsById.values());
    }

    @Override
    public List<S> getLoggedInSessions() {
        return new ArrayList<S>(this.loggedInSession.values());
    }

    @Override
    public int getAllSessionCount() {
        return this.providedObjects.size();
    }

    @Override
    public int getAliveSessionCount() {
        return this.sessionsById.size();
    }

    @Override
    public int getLoggedInSessionCount() {
        return this.loggedInSession.size();
    }

    public void start() throws Exception {
        super.start();
        this.logger.debug("start session manager");
    }

    protected void removeStaleObjects(List<S> buffer) {
        this.checkAndRemoveSessions(buffer);
    }

    protected void checkAndRemoveSessions(List<S> sessions) {
        ArrayList<EzySession> idleSessions = new ArrayList<EzySession>();
        ArrayList<EzySession> unloggedInSessions = new ArrayList<EzySession>();
        for (EzySession session : sessions) {
            boolean unloggedIn = this.isUnloggedInSession(session);
            if (unloggedIn) {
                unloggedInSessions.add(session);
                continue;
            }
            boolean idle = this.isIdleSession(session);
            if (!idle) continue;
            idleSessions.add(session);
        }
        for (EzySession session : idleSessions) {
            this.removeSession(session, EzyDisconnectReason.IDLE);
        }
        for (EzySession session : unloggedInSessions) {
            this.removeSession(session, EzyDisconnectReason.NOT_LOGGED_IN);
        }
    }

    protected boolean isIdleSession(S session) {
        return session.isIdle();
    }

    protected boolean isUnloggedInSession(EzySession session) {
        if (session.isLoggedIn()) {
            return false;
        }
        if (!session.isActivated()) {
            return false;
        }
        long remainTime = this.getSessionRemainWaitingTime(session);
        return remainTime <= 0L;
    }

    protected long getSessionRemainWaitingTime(EzySession session) {
        long maxWaitingTime = session.getMaxWaitingTime();
        long creationTime = session.getCreationTime();
        return EzyTimes.getRemainTime((long)maxWaitingTime, (long)creationTime);
    }

    protected String newSessionToken() {
        return this.tokenGenerator.generate();
    }

    public void destroy() {
        super.destroy();
        this.loggedInSession.clear();
        this.sessionsById.clear();
    }

    public static abstract class Builder<S extends EzySession>
    extends EzyObjectProvider.Builder<S, Builder<S>> {
        protected int maxSessions = 999999;
        protected EzySessionTokenGenerator tokenGenerator;

        protected String getValidationThreadPoolName() {
            return "session-manager";
        }

        public Builder<S> maxSessions(int maxSessions) {
            this.maxSessions = maxSessions;
            return this;
        }

        public Builder<S> tokenGenerator(EzySessionTokenGenerator generator) {
            this.tokenGenerator = generator;
            return this;
        }

        public abstract EzySimpleSessionManager<S> build();
    }
}

