/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.io;

import com.tvd12.ezyhttp.core.data.BytesRange;
import com.tvd12.ezyhttp.core.io.AnywayFileLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import lombok.Generated;

public class BytesRangeFileInputStream
extends InputStream {
    private final long from;
    private final long to;
    private final long fileLength;
    private long readBytes;
    private final long targetReadBytes;
    private final FileChannel fileChannel;
    public static final int MAX_CHUNK_LENGTH = 0x200000;

    public BytesRangeFileInputStream(String filePath, String range) throws Exception {
        this(filePath, new BytesRange(range));
    }

    public BytesRangeFileInputStream(String filePath, BytesRange range) throws Exception {
        this(filePath, range.getFrom(), range.getTo());
    }

    public BytesRangeFileInputStream(String filePath, long rangeFrom, long rangeTo) throws Exception {
        long actualTo;
        this.from = rangeFrom;
        AnywayFileLoader fileLoader = AnywayFileLoader.getDefault();
        File file = fileLoader.load(filePath);
        if (file == null) {
            throw new FileNotFoundException(filePath + " not found");
        }
        this.fileLength = file.length();
        long l = actualTo = rangeTo == 0L ? this.from + 0x200000L : rangeTo + 1L;
        if (actualTo > this.fileLength) {
            actualTo = this.fileLength;
        }
        this.to = actualTo;
        this.targetReadBytes = actualTo - this.from;
        this.fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public int read(byte[] b) throws IOException {
        long position;
        if (this.readBytes >= this.targetReadBytes) {
            return -1;
        }
        long remaining = this.targetReadBytes - this.readBytes;
        int actualLength = (int)Math.min((long)b.length, remaining);
        ByteBuffer dst = ByteBuffer.wrap(b, 0, actualLength);
        int rb = this.fileChannel.read(dst, position = this.from + this.readBytes);
        if (rb > 0) {
            this.readBytes += (long)rb;
        }
        return rb;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("unsupport");
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    public String getBytesContentRangeString() {
        return "bytes " + this.from + '-' + (this.from < this.to ? this.to - 1L : this.to) + '/' + this.fileLength;
    }

    @Generated
    public long getFrom() {
        return this.from;
    }

    @Generated
    public long getTo() {
        return this.to;
    }

    @Generated
    public long getFileLength() {
        return this.fileLength;
    }

    @Generated
    public long getReadBytes() {
        return this.readBytes;
    }

    @Generated
    public long getTargetReadBytes() {
        return this.targetReadBytes;
    }
}

