/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataAppender;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataCountIncrementer;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToEntityConverter;
import org.youngmonkeys.ezyplatform.admin.repo.AdminDataRecordCountRepository;
import org.youngmonkeys.ezyplatform.admin.repo.AdminDataRecordCountTransactionalRepository;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.entity.DataRecordCount;
import org.youngmonkeys.ezyplatform.model.IncreaseDataRecordCountModel;
import org.youngmonkeys.ezyplatform.result.IdResult;
import org.youngmonkeys.ezyplatform.time.ClockProxy;

@EzySingleton
public class AdminDataCountAppender
extends AdminDataAppender<DataRecordCount, DataRecordCount, Void> {
    private final ClockProxy clock;
    private final EzySingletonFactory singletonFactory;
    private final AdminDataRecordCountRepository dataRecordCountRepository;
    private final AdminDataRecordCountTransactionalRepository dataRecordCountTransactionalRepository;
    private final AdminModelToEntityConverter modelToEntityConverter;
    private final Map<String, Boolean> existedRecordCountByDataType;
    private List<AdminDataCountIncrementer> dataCountIncrementers;

    public AdminDataCountAppender(ClockProxy clock, EzySingletonFactory singletonFactory, ObjectMapper objectMapper, AdminSettingService settingService, AdminDataRecordCountRepository dataRecordCountRepository, AdminDataRecordCountTransactionalRepository dataRecordCountTransactionalRepository, AdminModelToEntityConverter modelToEntityConverter) {
        super(objectMapper, settingService);
        this.clock = clock;
        this.singletonFactory = singletonFactory;
        this.dataRecordCountRepository = dataRecordCountRepository;
        this.modelToEntityConverter = modelToEntityConverter;
        this.dataRecordCountTransactionalRepository = dataRecordCountTransactionalRepository;
        this.existedRecordCountByDataType = new HashMap<String, Boolean>();
    }

    @Override
    protected boolean defaultStarted() {
        return true;
    }

    protected void initDataCountIncrementers() {
        if (this.dataCountIncrementers == null) {
            this.dataCountIncrementers = this.singletonFactory.getSingletonsOf(AdminDataCountIncrementer.class);
        }
    }

    @Override
    protected void doAppend() {
        this.initDataCountIncrementers();
        LocalDateTime now = this.clock.nowDateTime();
        for (AdminDataCountIncrementer incrementer : this.dataCountIncrementers) {
            IdResult lastRecordIdResult;
            long lastRecordId;
            IncreaseDataRecordCountModel model;
            long value;
            String dataType = incrementer.getDataType();
            if (!this.existedRecordCountByDataType.containsKey(dataType)) {
                DataRecordCount entity = (DataRecordCount)this.dataRecordCountRepository.findById(dataType);
                if (entity == null) {
                    this.dataRecordCountRepository.save(this.modelToEntityConverter.toNewDataRecordCount(dataType));
                    this.logger.info("create data count record for: {}", (Object)dataType);
                }
                this.existedRecordCountByDataType.put(dataType, true);
            }
            if ((value = (model = incrementer.incrementDataRecordCount(lastRecordId = (lastRecordIdResult = this.dataRecordCountRepository.findLastRecordIdByDataType(dataType)) != null ? lastRecordIdResult.getId() : 0L)).getValue()) <= 0L) continue;
            long newLastRecordId = model.getLastRecordId();
            this.dataRecordCountTransactionalRepository.incrementRecordCount(dataType, value, newLastRecordId, now);
            this.logger.info("increase data count records: {} for: {}, newLastRecordId: {}", new Object[]{value, dataType, newLastRecordId});
        }
    }

    @Override
    protected List<DataRecordCount> getValueList(Void unused) {
        throw new UnsupportedOperationException("unused");
    }

    @Override
    protected Void extractNewLastPageToken(List<DataRecordCount> list, Void unused) {
        throw new UnsupportedOperationException("unused");
    }

    @Override
    public void reload() {
        this.initDataCountIncrementers();
        for (AdminDataCountIncrementer incrementer : this.dataCountIncrementers) {
            incrementer.reload();
        }
        super.reload();
    }

    @Override
    protected String getAppenderNamePrefix() {
        return "data_record_counts";
    }

    @Override
    public String getAppenderStartedSettingName() {
        return "admin_data_count_appender_started";
    }

    @Override
    protected Void defaultPageToken() {
        throw new UnsupportedOperationException("unused");
    }

    @Override
    protected Class<Void> pageTokenType() {
        return Void.class;
    }
}

