/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminUserControllerService;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.converter.AdminRequestToModelConverter;
import org.youngmonkeys.ezyplatform.admin.event.AdminEventHandlerManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminWebFeatureUriManager;
import org.youngmonkeys.ezyplatform.admin.model.AddUserModel;
import org.youngmonkeys.ezyplatform.admin.pagination.AdminUserFilter;
import org.youngmonkeys.ezyplatform.admin.request.AddUserRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddUserRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddUserRoleRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddUsersRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRoleFeaturesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateAvatarRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateCoverImageRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdatePasswordRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateUserRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateUserRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.response.AddUserResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminRoleFeatureService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.admin.validator.AdminCommonValidator;
import org.youngmonkeys.ezyplatform.admin.validator.AdminUsersValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminAccessToken;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserNameModel;
import org.youngmonkeys.ezyplatform.model.UserRoleNameModel;
import org.youngmonkeys.ezyplatform.util.CollectionFunctions;
import org.youngmonkeys.ezyplatform.util.Keywords;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@Api
@Authenticated
@EzyFeature(value="user_management")
@Controller(value="/api/v1")
public class AdminApiUsersController
extends EzyLoggable {
    private final AdminEventHandlerManager eventHandlerManager;
    private final AdminWebFeatureUriManager webFeatureUriManager;
    private final AdminRoleFeatureService roleFeatureService;
    private final AdminSettingService settingService;
    private final AdminUserService userService;
    private final AdminUserRoleService userRoleService;
    private final AdminUserControllerService userControllerService;
    private final AdminCommonValidator commonValidator;
    private final AdminUsersValidator usersValidator;
    private final AdminModelToResponseConverter modelToResponseConverter;
    private final AdminRequestToModelConverter requestToModelConverter;

    @DoGet(value="/users")
    public PaginationModel<UserResponse> usersGet(@RequestParam(value="roleIds") Set<Long> roleIds, @RequestParam(value="roleNames") Set<String> roleNames, @RequestParam(value="keyword") String keyword, @RequestParam(value="userStatus") String userStatus, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        this.commonValidator.validatePageSize(limit);
        this.usersValidator.validateUserRoleIds(roleIds);
        this.usersValidator.validateUserRoleNames(roleNames);
        AdminUserFilter.Builder filterBuilder = (AdminUserFilter.Builder)((AdminUserFilter.Builder)((AdminUserFilter.Builder)AdminUserFilter.builder().status(StringConverters.trimOrNull((String)userStatus))).roleIds(CollectionFunctions.toNullIfEmpty(roleIds))).roleNames(CollectionFunctions.toNullIfEmpty(roleNames));
        return this.userControllerService.getUserResponsePagination(keyword, filterBuilder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @DoGet(value="/users/simple-search")
    public List<UserNameModel> usersSimpleSearchGet(@RequestParam(value="roleIds") Set<Long> roleIds, @RequestParam(value="roleNames") Set<String> roleNames, @RequestParam(name="keyword") String keyword, @RequestParam(name="limit", defaultValue="25") int limit) {
        this.commonValidator.validatePageSize(limit);
        this.commonValidator.validateSearchKeyword(keyword);
        if (this.settingService.isAllowSearchUserByLikeOperator()) {
            if (!roleIds.isEmpty()) {
                return this.userService.simpleSearchWithRoleIds(roleIds, keyword, limit);
            }
            if (!roleNames.isEmpty()) {
                return this.userService.simpleSearchWithRoleNames(roleNames, keyword, limit);
            }
            return this.userService.simpleSearch(keyword, limit);
        }
        if (!roleIds.isEmpty()) {
            return this.userService.simpleSearchWithRoleIds(roleIds, Keywords.toKeywords((String)keyword), limit);
        }
        if (!roleNames.isEmpty()) {
            return this.userService.simpleSearchWithRoleNames(roleNames, Keywords.toKeywords((String)keyword), limit);
        }
        return this.userService.simpleSearch(Keywords.toKeywords((String)keyword), limit);
    }

    @DoGet(value="/users-by-ids")
    public List<UserResponse> usersByIdsGet(@RequestParam(value="ids") List<Long> userIds) {
        this.commonValidator.validateCollectionSize("userIds", userIds);
        return this.userControllerService.getUserListByIds(userIds);
    }

    @DoPost(value="/users/add")
    public AddUserResponse usersAddPost(@RequestBody AddUserRequest request) {
        this.usersValidator.validate(request);
        AddUserModel addUserModel = this.requestToModelConverter.toModel(request);
        UserModel userModel = this.userService.addUser(addUserModel);
        return this.modelToResponseConverter.toAddResponse(userModel);
    }

    @DoPost(value="/users/add-many")
    public ResponseEntity usersManyAddPost(@RequestBody AddUsersRequest request) {
        this.usersValidator.validate(request);
        int successCount = 0;
        List<AddUserRequest> users = request.getUsers();
        int totalUsers = users.size();
        for (AddUserRequest user : users) {
            try {
                this.doAddUserFromRequest(user);
                this.logger.info("added {} / {}", (Object)(++successCount), (Object)totalUsers);
            }
            catch (Throwable e) {
                this.logger.info("add user error", e);
            }
        }
        return ResponseEntity.noContent();
    }

    private void doAddUserFromRequest(AddUserRequest user) {
        Set roleIds;
        String password;
        String phone = user.getPhone();
        if (EzyStrings.isNotBlank((String)phone) && (phone = phone.trim()).startsWith("'")) {
            user.setPhone(phone.length() <= 1 ? null : phone.substring(1));
        }
        if (EzyStrings.isBlank((String)(password = user.getPassword()))) {
            user.setPassword(UUID.randomUUID().toString());
        }
        if (EzyCollections.isEmpty(roleIds = user.getRoleIds())) {
            roleIds = this.userRoleService.getRoleIdsByNames(user.getRoleNames());
        }
        user.setRoleIds(roleIds);
        long userId = this.userService.addUserIfNotExists(this.requestToModelConverter.toModel(user)).getId();
        String address = user.getAddress();
        if (EzyStrings.isNotBlank((String)address)) {
            this.eventHandlerManager.handleEvent("SET_USER_ADDRESS", EzyMapBuilder.mapBuilder().put((Object)"userId", (Object)userId).put((Object)"address", (Object)address).toMap());
        }
    }

    @DoPut(value="/users/{username}")
    public ResponseEntity usersUsernamePut(@PathVariable String username, @RequestBody UpdateUserRequest request) {
        this.usersValidator.validate(username, request);
        this.userService.updateUser(this.requestToModelConverter.toModel(username, request));
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/{username}/update-password")
    public ResponseEntity usersUsernameUpdatePasswordPut(@PathVariable String username, @AdminRoles AdminRolesProxy adminRoles, @RequestBody UpdatePasswordRequest request) {
        boolean hasPermission = adminRoles.isAccessible("/api/v1/users/{username}/generate-forgot-password-uri", HttpMethod.POST);
        if (hasPermission) {
            request.setOldPassword("************");
        }
        this.commonValidator.validate(request);
        if (hasPermission) {
            this.userService.updatePassword(username, request.getNewPassword());
        } else {
            this.userService.updatePassword(username, request.getOldPassword(), request.getNewPassword());
        }
        return ResponseEntity.noContent();
    }

    @DoPost(value="/users/{username}/generate-forgot-password-uri")
    public ResponseEntity usersUsernameGenerateForgotPasswordUriPost(@PathVariable String username) {
        UserModel user = this.usersValidator.validate(username);
        String token = this.userService.generateForgotPasswordToken(user.getId(), username);
        return ResponseEntity.builder().contentType("text/plain").body((Object)("/account/reset-password?uuid=" + user.getUuid() + "&token=" + token)).build();
    }

    @DoPut(value="/users/{username}/update-avatar")
    public ResponseEntity usersUsernameUpdateAvatarPut(@PathVariable String username, @RequestBody UpdateAvatarRequest request) {
        long avatarId = request.getAvatarId();
        this.commonValidator.validateId("avatarId", avatarId);
        this.userService.updateAvatar(username, avatarId);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/{username}/update-cover-image")
    public ResponseEntity usersUsernameUpdateCoverImagePut(@PathVariable String username, @RequestBody UpdateCoverImageRequest request) {
        long coverImageId = request.getCoverImageId();
        this.commonValidator.validateId("coverImageId", coverImageId);
        this.userService.updateCoverImage(username, coverImageId);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/{username}/archive")
    public ResponseEntity usersUsernameArchivePut(@PathVariable String username) {
        this.userService.archiveUser(username);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/{username}/block")
    public ResponseEntity usersUsernameBlockPut(@PathVariable String username) {
        this.userService.blockUser(username);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/{username}/activate")
    public ResponseEntity usersUsernameActivatePut(@PathVariable String username) {
        this.userService.activateUser(username);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/users/{username}")
    public ResponseEntity usersUsernameDelete(@PathVariable String username) {
        this.userService.removeUser(username);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/users/{username}/erase")
    public ResponseEntity usersUsernameEraseDelete(@PathVariable String username) {
        this.userService.eraseUser(username);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/archive")
    public ResponseEntity usersArchivePut(@RequestParam(value="ids") Set<Long> userIds) {
        this.commonValidator.validateCollectionSize("userIds", userIds);
        this.userService.archiveUsers(userIds);
        return ResponseEntity.noContent();
    }

    @DoPut(value="/users/activate")
    public ResponseEntity usersActivatePut(@RequestParam(value="ids") Set<Long> userIds) {
        this.commonValidator.validateCollectionSize("userIds", userIds);
        this.userService.activateUsers(userIds);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/users")
    public ResponseEntity usersDelete(@RequestParam(value="ids") Set<Long> userIds) {
        this.commonValidator.validateCollectionSize("userIds", userIds);
        this.userService.removeUsers(userIds);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/users/erase")
    public ResponseEntity usersEraseDelete(@RequestParam(value="ids") Set<Long> userIds) {
        this.commonValidator.validateCollectionSize("userIds", userIds);
        this.userService.eraseUsers(userIds);
        return ResponseEntity.noContent();
    }

    @DoGet(value="/user/role-names")
    public List<UserRoleNameModel> userRoleNamesGet() {
        return this.userRoleService.getUserRoles();
    }

    @DoPost(value="/user/role-names/add")
    public UserRoleNameModel userRoleNamesAddPost(@RequestBody AddUserRoleNameRequest request) {
        this.usersValidator.validate(request);
        return this.userRoleService.saveUserRoleName(this.requestToModelConverter.toModel(request));
    }

    @DoPut(value="/user/role-names/{roleNameId}")
    public ResponseEntity userRoleNamesRoleNamePost(@PathVariable long roleNameId, @RequestBody UpdateUserRoleNameRequest request) {
        this.usersValidator.validate(roleNameId, request);
        this.userRoleService.saveUserRoleName(this.requestToModelConverter.toModel(roleNameId, request));
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/user/role-names/{roleName}")
    public ResponseEntity userRolesRoleNameDelete(@PathVariable String roleName) {
        this.usersValidator.validateUserRoleName(roleName);
        UserRoleNameModel role = this.getRoleNameMode(roleName);
        this.userRoleService.deleteUserRoleNameById(role.getId());
        return ResponseEntity.noContent();
    }

    @DoGet(value="/user/roles")
    public List<UserRoleResponse> userRolesGet() {
        List<UserRoleNameModel> roleNames = this.userRoleService.getUserRoleNames();
        return this.modelToResponseConverter.toUserRoleResponses(roleNames);
    }

    @DoGet(value="/user/roles/{roleName}/members")
    public PaginationModel<UserRoleMemberResponse> userRolesRoleNameMembersGet(@PathVariable String roleName, @RequestParam(value="keyword") String keyword, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        this.usersValidator.validateUserRoleName(roleName);
        UserRoleNameModel role = this.userRoleService.getUserRoleNameByName(roleName);
        AdminUserFilter.Builder filterBuilder = (AdminUserFilter.Builder)AdminUserFilter.builder().roleId(role.getId());
        return this.userControllerService.getUserRoleMemberPagination(role.getId(), keyword, filterBuilder, nextPageToken, prevPageToken, lastPage, limit);
    }

    @DoPost(value="/user/roles/add")
    public ResponseEntity userRolesAddPost(@RequestBody AddUserRoleRequest request) {
        this.usersValidator.validate(request);
        this.userRoleService.saveUserRole(this.requestToModelConverter.toModel(request));
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/user/roles/{roleId}/{userId}")
    public ResponseEntity userRolesRoleIdUserId(@PathVariable long roleId, @PathVariable long userId) {
        this.usersValidator.validateDeleteRoleIdUserId(roleId, userId);
        this.userRoleService.deleteUserRole(roleId, userId);
        return ResponseEntity.noContent();
    }

    @DoPost(value="/user/roles/{roleId}/features/save")
    public ResponseEntity userRolesRoleIdFeaturesSavePost(@PathVariable long roleId, @RequestBody SaveRoleFeaturesRequest request) {
        this.usersValidator.validate(roleId, request);
        this.roleFeatureService.saveRoleFeatures(roleId, TargetType.WEB, request.getMethodsUriMapByFeature());
        return ResponseEntity.noContent();
    }

    @DoGet(value="/user/roles/{roleId}/features")
    public Map<String, Map<String, List<HttpMethod>>> userRolesRoleIdFeaturesGet(@PathVariable long roleId) {
        return this.roleFeatureService.getMethodsUriMapOfFeatureByRoleId(TargetType.WEB, roleId);
    }

    @DoGet(value="/user/features")
    public Map<String, Map<String, List<HttpMethod>>> userFeaturesGet(@AdminAccessToken String adminAccessToken) {
        return this.webFeatureUriManager.getURIsByFeatureMap(adminAccessToken);
    }

    private UserRoleNameModel getRoleNameMode(String roleName) {
        UserRoleNameModel model = this.userRoleService.getUserRoleNameByName(roleName);
        if (model == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        return model;
    }

    @Generated
    public AdminApiUsersController(AdminEventHandlerManager eventHandlerManager, AdminWebFeatureUriManager webFeatureUriManager, AdminRoleFeatureService roleFeatureService, AdminSettingService settingService, AdminUserService userService, AdminUserRoleService userRoleService, AdminUserControllerService userControllerService, AdminCommonValidator commonValidator, AdminUsersValidator usersValidator, AdminModelToResponseConverter modelToResponseConverter, AdminRequestToModelConverter requestToModelConverter) {
        this.eventHandlerManager = eventHandlerManager;
        this.webFeatureUriManager = webFeatureUriManager;
        this.roleFeatureService = roleFeatureService;
        this.settingService = settingService;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.userControllerService = userControllerService;
        this.commonValidator = commonValidator;
        this.usersValidator = usersValidator;
        this.modelToResponseConverter = modelToResponseConverter;
        this.requestToModelConverter = requestToModelConverter;
    }
}

