/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpConflictException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.youngmonkeys.ezyplatform.admin.manager.AdminWebFeatureUriManager;
import org.youngmonkeys.ezyplatform.admin.request.AddUserRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddUserRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddUserRoleRequest;
import org.youngmonkeys.ezyplatform.admin.request.AddUsersRequest;
import org.youngmonkeys.ezyplatform.admin.request.SaveRoleFeaturesRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateUserRequest;
import org.youngmonkeys.ezyplatform.admin.request.UpdateUserRoleNameRequest;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserService;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserRoleNameModel;
import org.youngmonkeys.ezyplatform.service.UserService;
import org.youngmonkeys.ezyplatform.validator.DefaultValidator;
import org.youngmonkeys.ezyplatform.validator.UserValidator;

@EzySingleton
public class AdminUsersValidator
extends UserValidator {
    private final AdminWebFeatureUriManager webFeatureUriManager;
    private final AdminUserService userService;
    private final AdminUserRoleService userRoleService;

    public AdminUsersValidator(AdminWebFeatureUriManager webFeatureUriManager, AdminUserService userService, AdminUserRoleService userRoleService) {
        super((UserService)userService);
        this.webFeatureUriManager = webFeatureUriManager;
        this.userService = userService;
        this.userRoleService = userRoleService;
    }

    public UserModel validate(String username) {
        return this.validateUsername(username);
    }

    public void validate(AddUserRequest request) {
        String password;
        String displayName;
        String website;
        HashMap<String, String> errors = new HashMap<String, String>();
        String username = request.getUsername();
        if (EzyStrings.isEmpty((CharSequence)username)) {
            errors.put("username", "required");
        } else if (!DefaultValidator.isValidUsername((String)username)) {
            errors.put("username", "invalid");
        } else if (this.userService.getUserByUsername(username) != null) {
            errors.put("username", "duplicated");
        }
        String email = request.getEmail();
        if (EzyStrings.isEmpty((CharSequence)email)) {
            errors.put("email", "required");
        } else if (!DefaultValidator.isValidEmail((String)email)) {
            errors.put("email", "invalid");
        } else if (this.userService.getUserByEmail(email) != null) {
            errors.put("email", "duplicated");
        }
        String phone = request.getPhone();
        if (EzyStrings.isNotBlank((String)phone)) {
            if (!DefaultValidator.isValidPhone((String)phone)) {
                errors.put("phone", "invalid");
            } else if (this.userService.getUserByPhone(phone) != null) {
                errors.put("phone", "duplicated");
            }
        }
        if (EzyStrings.isNotBlank((String)(website = request.getWebsite())) && !DefaultValidator.isValidHttpUrl((String)website)) {
            errors.put("website", "invalid");
        }
        if (EzyStrings.isNotBlank((String)(displayName = request.getDisplayName())) && DefaultValidator.containsSqlComment((String)displayName)) {
            errors.put("displayName", "invalid");
        }
        if (EzyStrings.isEmpty((CharSequence)(password = request.getPassword()))) {
            errors.put("password", "required");
        } else if (password.length() < 6) {
            errors.put("password", "tooShort");
        } else if (!DefaultValidator.isValidPassword((String)password)) {
            errors.put("password", "invalid");
        }
        Set<Long> roleIds = request.getRoleIds();
        if (!EzyCollections.isEmpty(roleIds) && !this.userRoleService.containsAllUserRoleIds(roleIds)) {
            errors.put("roleIds", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(AddUsersRequest request) {
        List<AddUserRequest> users = request.getUsers();
        HashMap<String, String> errors = new HashMap<String, String>();
        if (EzyCollections.isEmpty(users)) {
            errors.put("users", "required");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(String username, UpdateUserRequest request) {
        String displayName;
        String website;
        HashMap<String, String> errors = new HashMap<String, String>();
        String email = request.getEmail();
        if (EzyStrings.isEmpty((CharSequence)email)) {
            errors.put("email", "required");
        } else if (!DefaultValidator.isValidEmail((String)email)) {
            errors.put("email", "invalid");
        } else {
            UserModel userModel = this.userService.getUserByEmail(email);
            if (userModel != null && !userModel.getUsername().equals(username)) {
                errors.put("email", "duplicated");
            }
        }
        String phone = request.getPhone();
        if (EzyStrings.isNotBlank((String)phone)) {
            if (!DefaultValidator.isValidPhone((String)phone)) {
                errors.put("phone", "invalid");
            } else {
                UserModel userModel = this.userService.getUserByPhone(phone.trim());
                if (userModel != null && !userModel.getUsername().equals(username)) {
                    errors.put("phone", "duplicated");
                }
            }
        }
        if (EzyStrings.isNotBlank((String)(website = request.getWebsite())) && !DefaultValidator.isValidHttpUrl((String)website)) {
            errors.put("website", "invalid");
        }
        if (EzyStrings.isNotBlank((String)(displayName = request.getDisplayName())) && DefaultValidator.containsSqlComment((String)displayName)) {
            errors.put("displayName", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(AddUserRoleNameRequest request) {
        UserRoleNameModel existing;
        String displayName;
        HashMap<String, String> errors = new HashMap<String, String>();
        String name = request.getName();
        if (EzyStrings.isNoContent((String)name)) {
            errors.put("name", "invalid");
        }
        if (EzyStrings.isNoContent((String)(displayName = request.getDisplayName()))) {
            errors.put("displayName", "invalid");
        }
        if ((existing = this.userRoleService.getUserRoleNameByNameOrDisplayName(name, displayName)) != null) {
            if (existing.getName().equals(name)) {
                errors.put("name", "duplicated");
            }
            if (existing.getDisplayName().equals(displayName)) {
                errors.put("displayName", "duplicated");
            }
            throw new HttpBadRequestException(errors);
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long roleNameId, UpdateUserRoleNameRequest request) {
        UserRoleNameModel existing;
        String displayName;
        UserRoleNameModel role = this.userRoleService.getUserRoleNameById(roleNameId);
        if (role == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        String name = request.getName();
        if (EzyStrings.isNoContent((String)name)) {
            errors.put("name", "invalid");
        }
        if (EzyStrings.isNoContent((String)(displayName = request.getDisplayName()))) {
            errors.put("displayName", "invalid");
        }
        if ((existing = this.userRoleService.getUserRoleNameByNameOrDisplayName(name, displayName)) != null && existing.getId() != roleNameId) {
            if (existing.getName().equals(name)) {
                errors.put("name", "duplicated");
            }
            if (existing.getDisplayName().equals(displayName)) {
                errors.put("displayName", "duplicated");
            }
            throw new HttpBadRequestException(errors);
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(AddUserRoleRequest request) {
        long roleId;
        long userId = request.getUserId();
        if (this.userRoleService.containsUserRole(userId, roleId = request.getRoleId())) {
            throw new HttpConflictException(Collections.singletonMap("userRole", "granted"));
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        if (!this.userRoleService.containsUserRoleName(roleId)) {
            errors.put("roleId", "notFound");
        }
        if (!this.userService.containsUserById(userId)) {
            errors.put("user", "notFound");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validate(long roleId, SaveRoleFeaturesRequest request) {
        UserRoleNameModel roleName = this.userRoleService.getUserRoleNameById(roleId);
        if (roleName == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "noFound"));
        }
        Map<String, Map<String, List<String>>> methodsUriMapByFeature = request.getMethodsUriMapByFeature();
        HashMap<String, String> errors = new HashMap<String, String>();
        if (methodsUriMapByFeature.size() > 3000) {
            errors.put("features", "tooMany");
        }
        if (errors.isEmpty()) {
            Map<String, Map<String, List<HttpMethod>>> urisByFeatureMap = this.webFeatureUriManager.getCachedURIsByFeatureMap();
            block2: for (String feature : methodsUriMapByFeature.keySet()) {
                if (!urisByFeatureMap.containsKey(feature)) {
                    errors.put("features", "invalid");
                    break;
                }
                Map methodsUriMap = urisByFeatureMap.getOrDefault(feature, Collections.emptyMap());
                Map requestMethodsUriMap = methodsUriMapByFeature.getOrDefault(feature, Collections.emptyMap());
                for (String uri : requestMethodsUriMap.keySet()) {
                    if (!methodsUriMap.containsKey(uri)) {
                        errors.put("features", "invalid");
                        break block2;
                    }
                    List methods = methodsUriMap.getOrDefault(uri, Collections.emptyList());
                    List requestMethods = requestMethodsUriMap.getOrDefault(uri, Collections.emptyList());
                    for (String requestMethod : requestMethods) {
                        try {
                            if (methods.contains(HttpMethod.valueOf((String)requestMethod))) continue;
                            errors.put("features", "invalid");
                        }
                        catch (Exception ignored) {
                            errors.put("features", "invalid");
                        }
                        break block2;
                    }
                }
            }
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateDeleteRoleIdUserId(long roleId, long userId) {
        UserRoleNameModel roleName = this.userRoleService.getUserRoleNameById(roleId);
        if (roleName == null) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
        if (!this.userService.containsUserById(userId)) {
            throw new HttpNotFoundException(Collections.singletonMap("role", "notFound"));
        }
    }

    public void validateUserRoleIds(Collection<Long> roleIds) {
        if (EzyCollections.isEmpty(roleIds)) {
            return;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Long roleId : roleIds) {
            if (roleId != null && roleId > 0L) continue;
            errors.put("roleIds", "invalid");
            break;
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateUserRoleNames(Collection<String> roleNames) {
        if (EzyCollections.isEmpty(roleNames)) {
            return;
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String roleName : roleNames) {
            if (!EzyStrings.isBlank((String)roleName) && !DefaultValidator.maybeContainsSqlInjection((String)roleName)) continue;
            errors.put("roleNames", "invalid");
            break;
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }

    public void validateUserRoleName(String roleName) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (DefaultValidator.maybeContainsSqlInjection((String)roleName)) {
            errors.put("roleName", "invalid");
        }
        if (!errors.isEmpty()) {
            throw new HttpBadRequestException(errors);
        }
    }
}

