/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.manager;

import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FeatureURIManager
implements EzyDestroyable {
    private final Map<String, Map<HttpMethod, String>> featureByURI = new ConcurrentHashMap<String, Map<HttpMethod, String>>();
    private final Map<String, Map<String, Set<HttpMethod>>> urisByFeature = new ConcurrentHashMap<String, Map<String, Set<HttpMethod>>>();

    public void addFeatureURI(String feature, HttpMethod method, String uri) {
        this.featureByURI.computeIfAbsent(uri, k -> new ConcurrentHashMap()).put(method, feature);
        this.urisByFeature.computeIfAbsent(feature, k -> new ConcurrentHashMap()).computeIfAbsent(uri, k -> ConcurrentHashMap.newKeySet()).add(method);
    }

    public List<String> getFeatures() {
        return new ArrayList<String>(this.urisByFeature.keySet());
    }

    public String getFeatureByURI(HttpMethod method, String uri) {
        Map<HttpMethod, String> featureByMethod = this.featureByURI.get(uri);
        return featureByMethod != null ? featureByMethod.get(method) : null;
    }

    public Map<String, List<HttpMethod>> getURIsByFeature(String feature) {
        return EzyMaps.newHashMapNewValues(this.urisByFeature.getOrDefault(feature, Collections.emptyMap()), ArrayList::new);
    }

    public Map<String, Map<HttpMethod, String>> getFeatureByURIMap() {
        return EzyMaps.newHashMapNewValues(this.featureByURI, HashMap::new);
    }

    public Map<String, Map<String, List<HttpMethod>>> getURIsByFeatureMap() {
        return EzyMaps.newHashMapNewValues(this.urisByFeature, v -> EzyMaps.newHashMapNewValues((Map)v, ArrayList::new));
    }

    public void destroy() {
        this.featureByURI.clear();
        this.urisByFeature.clear();
    }
}

