/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.interceptor;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.annotation.Interceptor;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.interceptor.RequestInterceptor;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.annotation.AdminAccessToken;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.entity.AccessTokenType;
import org.youngmonkeys.ezyplatform.web.service.WebAdminService;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;

@Interceptor(priority=-2147483647)
public class WebManagementAuthenticationInterceptor
extends EzyLoggable
implements RequestInterceptor {
    private final WebAdminService adminService;
    private final WebSettingService settingService;
    private final RequestURIManager requestUriManager;
    private static final Set<String> ACCEPTED_ADMIN_ACCESS_TOKEN_TYPES = Sets.newHashSet((Object[])new String[]{AccessTokenType.ACCESS_TOKEN.toString(), AccessTokenType.WEB_MANAGEMENT_TOKEN.toString()});

    public boolean preHandle(RequestArguments arguments, Method handler) {
        Set<String> autoPassUris;
        String uriTemplate;
        HttpMethod method = arguments.getMethod();
        if (!this.requestUriManager.isManagementURI(method, uriTemplate = arguments.getUriTemplate())) {
            return true;
        }
        String accessToken = this.getAdminAccessToken(arguments);
        boolean accessTokenIsBlank = EzyStrings.isBlank((String)accessToken);
        if (!accessTokenIsBlank) {
            arguments.setArgument(AdminAccessToken.class, (Object)accessToken);
        }
        if ((autoPassUris = this.settingService.getAutoPassManagementUris()).contains("*") || autoPassUris.contains(uriTemplate)) {
            return true;
        }
        long adminId = this.adminService.validateAdminAccessToken(accessToken, ACCEPTED_ADMIN_ACCESS_TOKEN_TYPES);
        arguments.setArgument(AdminId.class, (Object)adminId);
        return true;
    }

    private String getAdminAccessToken(RequestArguments arguments) {
        return arguments.getRequestValueAnyway(new String[]{"adminAccessToken", "sharedAdminAccessToken", "adminWebManagementAccessToken"});
    }

    @Generated
    public WebManagementAuthenticationInterceptor(WebAdminService adminService, WebSettingService settingService, RequestURIManager requestUriManager) {
        this.adminService = adminService;
        this.settingService = settingService;
        this.requestUriManager = requestUriManager;
    }
}

